/*
 * Decompiled with CFR 0.152.
 */
package com.MT.xxxtrigger50xxx.Guide;

import com.MT.triggersUtility.SkullCreator;
import com.MT.triggersUtility.TUInterface.TUIComponent;
import com.MT.triggersUtility.TUInterface.TUInterface;
import com.MT.triggersUtility.TUItems;
import com.MT.xxxtrigger50xxx.Guide.GuideMenu;
import com.MT.xxxtrigger50xxx.Guide.MainMenu;
import com.MT.xxxtrigger50xxx.MineItems;
import com.MT.xxxtrigger50xxx.MineMain;
import com.MT.xxxtrigger50xxx.MineUtil;
import java.util.ArrayList;
import java.util.HashMap;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.scheduler.BukkitRunnable;

public class ExampleFactorys {
    private static ItemStack upStack;
    private static ItemStack downStack;
    private static ItemStack leftStack;
    private static ItemStack rightStack;
    private static ItemStack lengthStack;
    private static ItemStack widthStack;
    private static ItemStack heightStack;

    public static void openExampleFactory(Player player, String factoryType) {
        TUInterface face = ExampleFactorys.getFace(factoryType);
        face.openInterface(player);
    }

    private static TUInterface getFace(String type) {
        TUInterface face = new TUInterface(MineItems.goldBold() + type, 6);
        int i = 45;
        while (i <= 53) {
            face.addComponent(GuideMenu.pane(Material.ORANGE_STAINED_GLASS_PANE, i));
            ++i;
        }
        face.addComponent(ExampleFactorys.createReturnArrow());
        ExampleFactorys.populateScreen(face, type);
        return face;
    }

    private static TUIComponent createReturnArrow() {
        ItemStack itemStack = MainMenu.createReturnArrow();
        return new TUIComponent(50, itemStack){

            @Override
            public void onLeftClick(Player player) {
                player.playSound(player.getLocation(), Sound.UI_BUTTON_CLICK, 1.0f, 1.0f);
                GuideMenu.openGuideMenu(player, false);
            }
        };
    }

    private static void createExampleComp(TUInterface face, int slot, Material mat, String name, String note, String desc, String direction) {
        ItemStack stack = TUItems.createItem(mat, MineItems.goldBold() + name);
        ArrayList<String> lore = new ArrayList<String>();
        if (note != null) {
            for (String str : MineUtil.wrapText(note, 45, ChatColor.YELLOW, 1)) {
                lore.add(String.valueOf(ChatColor.YELLOW) + str);
            }
            lore.add(" ");
        }
        for (String str : MineUtil.wrapText(desc, 45, ChatColor.WHITE, 1)) {
            lore.add(String.valueOf(ChatColor.WHITE) + str);
        }
        TUItems.addLore(stack, lore);
        TUIComponent comp = new TUIComponent(slot, stack);
        if (direction != null) {
            comp.setTag(direction);
        }
        face.addComponent(comp);
    }

    private static void setBelt(TUInterface face, int slot, Material mat) {
        ExampleFactorys.createExampleComp(face, slot, mat, "Belt", null, "Belts can move items like a conveyor when connected to motorized belt!", null);
    }

    private static void setMover(TUInterface face, int slot, String note, String direction) {
        ExampleFactorys.createExampleComp(face, slot, Material.DROPPER, "Mover ", note, "This mover grabs an item from a container or device from behind it and moves it into another container or device in front of it.", direction);
    }

    private static void setInserter(TUInterface face, int slot, String note, String direction) {
        ExampleFactorys.createExampleComp(face, slot, Material.DROPPER, "Mover - Inserter", note, "This mover type moves items from behind it from a contianer, device or belt and inserts it onto a belt. When a lever is placed above it, it can insert to both sides of the belt.", direction);
    }

    private static void setGrabber(TUInterface face, int slot, String note, String direction) {
        ExampleFactorys.createExampleComp(face, slot, Material.DROPPER, "Mover - Grabber", note, "This mover type grabs items from behind it from a belt and places it into a device, belt or container in front of it. When a lever is placed above it, it can grab from both sides of the belt.", direction);
    }

    private static void setMotor(TUInterface face, int slot, String note, String direction) {
        ExampleFactorys.createExampleComp(face, slot, Material.DROPPER, "Mover - Motorized", note, "Make sure to place a repeater above this mover! This type of mover makes all of the carpet connected to its front face turn into a conveyor belt! Motorized movers should never share the same belt. It will still work like an inserter though to the belt!", direction);
    }

    private static void setChest(TUInterface face, int slot, String note) {
        ExampleFactorys.createExampleComp(face, slot, Material.CHEST, "Chest", note, "Chests can have items moved into and out of them via movers. Movers can grab items from behind it in other chests, belts, devices and much more!", null);
    }

    private static void populateScreen(final TUInterface face, String factoryType) {
        if (factoryType.equals("Chest Sorting")) {
            ExampleFactorys.chestSorting(face);
        }
        if (factoryType.equals("Auto Smelting")) {
            ExampleFactorys.autoSmelter(face);
        }
        face.addComponent(MineUtil.createInfoComponent(48, "Mover direction is based on the direction of the arrow that takes its place every other second!", true));
        new BukkitRunnable(){
            boolean firstRun = true;
            boolean showMovers = false;
            HashMap<TUIComponent, ItemStack> moverStack = new HashMap();
            HashMap<TUIComponent, ItemStack> dirStack = new HashMap();

            public void run() {
                if (face.getInv().getViewers().size() <= 0) {
                    this.cancel();
                    return;
                }
                if (this.firstRun) {
                    this.firstRun = false;
                    for (TUIComponent comp : face.getComponents()) {
                        if (comp.getTag() == null) continue;
                        this.moverStack.put(comp, comp.getLinkedStack());
                        ItemStack arrowStack = ExampleFactorys.directionHead(comp.getTag()).clone();
                        TUItems.addLore(arrowStack, new ArrayList<String>(comp.getLinkedStack().getItemMeta().getLore()));
                        ItemMeta im = arrowStack.getItemMeta();
                        im.setDisplayName(comp.getLinkedStack().getItemMeta().getDisplayName());
                        arrowStack.setItemMeta(im);
                        this.dirStack.put(comp, arrowStack);
                    }
                }
                for (TUIComponent comp : this.moverStack.keySet()) {
                    if (this.showMovers) {
                        comp.setLinkedStack(this.moverStack.get(comp));
                        comp.createItemStack();
                        continue;
                    }
                    comp.setLinkedStack(this.dirStack.get(comp));
                    comp.createItemStack();
                }
                this.showMovers = !this.showMovers;
            }
        }.runTaskTimer(MineMain.getPlugin(), 20L, 20L);
    }

    private static void autoSmelter(TUInterface face) {
        int i;
        ExampleFactorys.setChest(face, 9, "This chest should have raw ore in it.");
        ExampleFactorys.setChest(face, 38, "This chest should have charcoal, coal or a fuel source in it.");
        ExampleFactorys.setChest(face, 44, "This chest will have all of your smelted ores in it.");
        int[] nArray = new int[]{20, 11, 2, 3, 4, 5, 6, 40, 41, 42};
        int n = nArray.length;
        int n2 = 0;
        while (n2 < n) {
            i = nArray[n2];
            ExampleFactorys.setBelt(face, i, Material.WHITE_CARPET);
            ++n2;
        }
        ExampleFactorys.setInserter(face, 10, "This inserter will place raw ore on the left side of the belt.", "RIGHT");
        ExampleFactorys.setMotor(face, 29, "Make sure to set the repeater position to 3 so that it only places on the right side of the belt.", "UP");
        nArray = new int[]{13, 14, 15};
        n = nArray.length;
        n2 = 0;
        while (n2 < n) {
            i = nArray[n2];
            ExampleFactorys.setGrabber(face, i, "A lever is required above this mover so it can grab both fuel and a smeltable. You don't have to but it would be wise to have filters on each furnace for each raw ore. This will prevent the belt from a stand still because the furnaces can't accept a different ore then it's smelting.", "DOWN");
            ++n2;
        }
        nArray = new int[]{31, 32, 33};
        n = nArray.length;
        n2 = 0;
        while (n2 < n) {
            i = nArray[n2];
            ExampleFactorys.setGrabber(face, i, "A lever here is optional but could be used to deposit items on both sides of the belt.", "DOWN");
            ++n2;
        }
        ExampleFactorys.setInserter(face, 43, "", "RIGHT");
        face.addComponent(new TUIComponent(22, new ItemStack(Material.FURNACE)));
        face.addComponent(new TUIComponent(23, new ItemStack(Material.FURNACE)));
        face.addComponent(new TUIComponent(24, new ItemStack(Material.FURNACE)));
        face.addComponent(MineUtil.createInfoComponent(8, "No power is required for this setup! However you do need to make sure your output chest doesn't backup, if it does it could stop this smelting proccess. Let's say you need ingots, but all there is nothing but copper on the belts. You could either add more storage for the resources or make individual Auto Smelting factories for each resource. This would prevent backups. The backing up could be annoying as you could need those iron ingots in your factory elsewhere!"));
    }

    private static void chestSorting(TUInterface face) {
        Material mat = Material.WHITE_CARPET;
        int i = 0;
        while (i <= 8) {
            ExampleFactorys.setBelt(face, i, mat);
            ++i;
        }
        ExampleFactorys.setBelt(face, 9, mat);
        ExampleFactorys.setBelt(face, 18, mat);
        ExampleFactorys.setBelt(face, 17, mat);
        ExampleFactorys.setBelt(face, 26, mat);
        ExampleFactorys.setChest(face, 36, "This chest is your drop box, drop any items into here for sorting. ");
        ExampleFactorys.setChest(face, 44, "This chest is anything that wasnt sorted out. ");
        i = 19;
        while (i <= 25) {
            ExampleFactorys.setChest(face, i, "This chest stores the filtered item out here. ");
            ++i;
        }
        i = 10;
        while (i <= 16) {
            ExampleFactorys.setGrabber(face, i, "This mover needs to have a filter on it for the specific item you want to store in the connected chest. It also needs a lever above it so it can grab from both sides of the belt. ", "DOWN");
            ++i;
        }
        ExampleFactorys.setGrabber(face, 35, "This grabber will grab items that where not filtered out and put them into the connected chest.", "DOWN");
        ExampleFactorys.setMotor(face, 27, "This will take items from the drop chest and place them on the belt, you could set it so it only dispenses item on the right side of the belt by setting the delay to 3 on the repeater, this would avoid having to use levers on the grabbers, however your sorting speed drops in half. ", "UP");
        face.addComponent(MineUtil.createInfoComponent(40, "This system requires no power to work! This is a very good investment early game! You can easily upgrade this setup as well!"));
    }

    public static ItemStack directionHead(String direction) {
        ItemStack dir = null;
        if (direction.equals("UP")) {
            if (upStack == null) {
                upStack = SkullCreator.getHead("eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvMWFkNmM4MWY4OTlhNzg1ZWNmMjZiZTFkYzQ4ZWFlMmJjZmU3NzdhODYyMzkwZjU3ODVlOTViZDgzYmQxNGQifX19");
            }
            dir = upStack;
        }
        if (direction.equals("DOWN")) {
            if (downStack == null) {
                downStack = SkullCreator.getHead("eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvODgyZmFmOWE1ODRjNGQ2NzZkNzMwYjIzZjg5NDJiYjk5N2ZhM2RhZDQ2ZDRmNjVlMjg4YzM5ZWI0NzFjZTcifX19");
            }
            dir = downStack;
        }
        if (direction.equals("LEFT")) {
            if (leftStack == null) {
                leftStack = SkullCreator.getHead("eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvY2RjOWU0ZGNmYTQyMjFhMWZhZGMxYjViMmIxMWQ4YmVlYjU3ODc5YWYxYzQyMzYyMTQyYmFlMWVkZDUifX19");
            }
            dir = leftStack;
        }
        if (direction.equals("RIGHT")) {
            if (rightStack == null) {
                rightStack = SkullCreator.getHead("eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvOTU2YTM2MTg0NTllNDNiMjg3YjIyYjdlMjM1ZWM2OTk1OTQ1NDZjNmZjZDZkYzg0YmZjYTRjZjMwYWI5MzExIn19fQ==");
            }
            dir = rightStack;
        }
        return dir;
    }

    public static ItemStack measurementHead(String measurement) {
        ItemStack dir = null;
        if (measurement.equals("LENGTH")) {
            if (lengthStack == null) {
                lengthStack = SkullCreator.getHead("eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvZDRhZmZhNDU1YjdmNTgyMTdkZThhY2JiZDkyMDFjOWVhODdjMTM0YWEzNTYyNTQ5NGY1ZDNmNjVjZTk0NiJ9fX0=");
            }
            dir = lengthStack;
        }
        if (measurement.equals("WIDTH")) {
            if (widthStack == null) {
                widthStack = SkullCreator.getHead("eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvODBjOTQ4M2Y1MWQxMjY3NDMyZTBmMmYzYmFhOGNkOTNlNjViNWVhYzc0ODJiMjdkYmNjZWJhZmI3MjE3NDhiIn19fQ==");
            }
            dir = widthStack;
        }
        if (measurement.equals("HEIGHT")) {
            if (heightStack == null) {
                heightStack = SkullCreator.getHead("eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvN2JhOWMzM2E5NWZhMWU1MTlmODVhNDFjYTU2Nzk5Mzg0ZGI0MWZlN2UxZDdhNzkxNzUxZWNlOWJiYWU1ZDI3ZiJ9fX0=");
            }
            dir = heightStack;
        }
        return dir;
    }
}

