/*
 * Decompiled with CFR 0.152.
 */
package com.MT.xxxtrigger50xxx.Planets.SpaceObjects;

import com.MT.triggersUtility.TUMaths;
import com.MT.xxxtrigger50xxx.Devices.Defense.SamSite;
import com.MT.xxxtrigger50xxx.Devices.Spaceship.ShipCore;
import com.MT.xxxtrigger50xxx.MineMain;
import com.MT.xxxtrigger50xxx.Planets.SpaceObjects.Asteroid;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Random;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.inventory.ItemStack;

public class ResourceAsteroid
extends Asteroid {
    private ItemStack storedResource;
    private int storedAmount = 0;
    private int health = 100;
    private Size asteroidSize;

    public ResourceAsteroid(Location location, ShipCore core) {
        super(location, core);
    }

    public ItemStack getStoredResource() {
        return this.storedResource;
    }

    public void setStoredResource(ItemStack storedResource) {
        this.storedResource = storedResource;
    }

    public int getStoredAmount() {
        return this.storedAmount;
    }

    public void setStoredAmount(int storedAmount) {
        this.storedAmount = storedAmount;
    }

    public int getHealth() {
        return this.health;
    }

    public void setHealth(int health) {
        this.health = health;
    }

    public Size getAsteroidSize() {
        return this.asteroidSize;
    }

    public void setAsteroidSize(Size asteroidSize) {
        this.asteroidSize = asteroidSize;
    }

    public void damage(int amount) {
        this.health -= amount;
        if (this.health <= 0) {
            int radius = 3;
            if (this.getAsteroidSize().equals((Object)Size.LARGE)) {
                radius = 9;
            }
            if (this.getAsteroidSize().equals((Object)Size.MEDIUM)) {
                radius = 6;
            }
            this.getLocation().getWorld().playSound(this.getLocation(), Sound.ENTITY_GENERIC_EXPLODE, 10.0f, 1.0f);
            SamSite.spawnParticleBurst(this.getLocation(), Particle.EXPLOSION, radius * 3, radius);
            SamSite.spawnParticleBurst(this.getLocation(), Particle.CAMPFIRE_COSY_SMOKE, radius * 3, radius);
            this.splinter();
            this.removeObject();
        }
    }

    private void splinter() {
        int splinters = 3;
        int range = 3;
        if (this.getAsteroidSize().equals((Object)Size.LARGE)) {
            splinters = 2;
            range = 9;
        }
        if (this.getAsteroidSize().equals((Object)Size.MEDIUM)) {
            splinters = 2;
            range = 6;
        }
        int amount = this.getStoredAmount() / splinters;
        int i = 0;
        while (i < splinters) {
            final ResourceAsteroid incoming = new ResourceAsteroid(this.getLocation().add((double)TUMaths.rollRange(-range, range), (double)TUMaths.rollRange(-range, range), (double)TUMaths.rollRange(-range, range)), this.getShipCore());
            incoming.setMainMat(this.getMainMat());
            incoming.setPeiceMat(this.getPeiceMat());
            incoming.setTargetLocation(this.getTargetLocation().add((double)TUMaths.rollRange(-14, 14), 0.0, 0.0));
            incoming.setDisplayMoveSpeed(Math.max(1, (int)((double)this.getDisplayMoveSpeed() * 0.75)));
            incoming.setStoredResource(this.getStoredResource());
            if (this.getAsteroidSize().equals((Object)Size.SMALL)) {
                incoming.setAsteroidSize(Size.CHUNK);
                incoming.setScale(1);
                incoming.setCenterPieces(1);
            }
            if (this.getAsteroidSize().equals((Object)Size.MEDIUM)) {
                incoming.setAsteroidSize(Size.SMALL);
            }
            if (this.getAsteroidSize().equals((Object)Size.LARGE)) {
                incoming.setAsteroidSize(Size.MEDIUM);
                incoming.setScale(6);
            }
            incoming.setStoredAmount(amount);
            incoming.render(true);
            Bukkit.getServer().getScheduler().scheduleSyncDelayedTask(MineMain.getPlugin(), new Runnable(){

                @Override
                public void run() {
                    incoming.postTick(true);
                }
            }, 1L);
            this.getShipCore().incomingRoids.add(incoming);
            ++i;
        }
    }

    @Override
    public void postTick(boolean forced) {
        super.postTick(forced);
        Location col = this.isColliding();
        if (col != null) {
            int radius;
            int particleRadius = 3;
            boolean createParticles = false;
            boolean destoryBlocks = false;
            if (this.getAsteroidSize().equals((Object)Size.CHUNK)) {
                createParticles = true;
            }
            if (!this.getAsteroidSize().equals((Object)Size.CHUNK)) {
                createParticles = true;
                destoryBlocks = true;
            }
            if (destoryBlocks) {
                radius = 2;
                int amount = 1;
                if (this.getAsteroidSize().equals((Object)Size.MEDIUM)) {
                    radius = 3;
                    amount = 6;
                }
                if (this.getAsteroidSize().equals((Object)Size.LARGE)) {
                    radius = 4;
                    amount = 12;
                }
                this.removeRandomBlocks(col, radius, amount);
            }
            if (createParticles) {
                radius = 3;
                if (this.getAsteroidSize().equals((Object)Size.LARGE)) {
                    radius = 6;
                    particleRadius = 18;
                }
                if (this.getAsteroidSize().equals((Object)Size.MEDIUM)) {
                    radius = 3;
                    particleRadius = 12;
                }
                this.getLocation().getWorld().playSound(this.getLocation(), Sound.ENTITY_GENERIC_EXPLODE, 20.0f, 0.6f);
                SamSite.spawnParticleBurst(this.getLocation(), Particle.CAMPFIRE_COSY_SMOKE, radius * 10, particleRadius);
            }
            this.removeObject();
        }
    }

    public Location isColliding() {
        World world;
        if (this.getLocation().getZ() < -64.0) {
            return null;
        }
        if (this.getAsteroidSize().equals((Object)Size.CHUNK)) {
            if (!this.getLocation().getBlock().getType().isAir()) {
                return this.getLocation();
            }
            return null;
        }
        Location center = this.getLocation();
        int width = 12;
        int height = 12;
        int length = 12;
        if (this.getAsteroidSize().equals((Object)Size.LARGE)) {
            width = 18;
            height = 18;
            length = 18;
        }
        if ((world = center.getWorld()) == null) {
            return null;
        }
        int startX = center.getBlockX() - width / 2;
        int startY = center.getBlockY() - height / 2;
        int startZ = center.getBlockZ() - length / 2;
        int x = 0;
        while (x <= width) {
            int y = 0;
            while (y <= height) {
                Block block = world.getBlockAt(startX + x, startY + y, startZ + length);
                if (block.getType() != Material.AIR) {
                    return block.getLocation();
                }
                y += 3;
            }
            x += 3;
        }
        return null;
    }

    public void removeRandomBlocks(Location center, int radius, int amountToRemove) {
        World world = center.getWorld();
        if (world == null) {
            return;
        }
        ArrayList<Block> blocksInRange = new ArrayList<Block>();
        int cx = center.getBlockX();
        int cy = center.getBlockY();
        int cz = center.getBlockZ();
        int x = cx - radius;
        while (x <= cx + radius) {
            int y = cy - radius;
            while (y <= cy + radius) {
                int z = cz - radius;
                while (z <= cz + radius) {
                    Block block;
                    Location loc = new Location(world, (double)x, (double)y, (double)z);
                    if (loc.distance(center) <= (double)radius && !(block = world.getBlockAt(loc)).getType().isAir()) {
                        blocksInRange.add(block);
                    }
                    ++z;
                }
                ++y;
            }
            ++x;
        }
        Collections.shuffle(blocksInRange, new Random());
        int i = 0;
        while (i < Math.min(amountToRemove, blocksInRange.size())) {
            ((Block)blocksInRange.get(i)).setType(Material.AIR);
            ++i;
        }
    }

    public static enum Size {
        CHUNK,
        SMALL,
        MEDIUM,
        LARGE;

    }
}

