/*
 * Decompiled with CFR 0.152.
 */
package com.MT.xxxtrigger50xxx.Pollution;

import com.MT.triggersUtility.Saveable;
import com.MT.triggersUtility.TUMaths;
import com.MT.xxxtrigger50xxx.Devices.Device;
import com.MT.xxxtrigger50xxx.MineMain;
import com.MT.xxxtrigger50xxx.MinetorioListener;
import com.MT.xxxtrigger50xxx.Pollution.BiterNest;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Axis;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.Keyed;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Registry;
import org.bukkit.Sound;
import org.bukkit.Tag;
import org.bukkit.World;
import org.bukkit.block.Biome;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.Ageable;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.Orientable;
import org.bukkit.block.data.Waterlogged;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Monster;
import org.terraform.biome.BiomeBank;

public class SuperChunk
extends Saveable {
    private static HashMap<String, ArrayList<SuperChunk>> superChunksByWorld = new HashMap();
    private static HashMap<String, SuperChunk> allSuperChunks = new HashMap();
    private static ArrayList<SuperChunk> allSupers = new ArrayList();
    private static final long serialVersionUID = -198119860027791643L;
    private static int skipTicks = 5;
    private transient boolean worldChecks = false;
    private transient boolean disabledWorld = false;
    public int x;
    public int z;
    private int pollution = 0;
    private int lifeSpanPollution = 0;
    private int dissapation = 2;
    private int ecoDamage = 0;
    public String world;
    public boolean debug = false;
    private ArrayList<String> sampledBiomes = new ArrayList();
    public boolean dissapationTagged = false;
    private transient int cacheDiss2 = 0;
    public boolean sampled = false;
    private static final Map<String, Integer> dissipationValues = new HashMap<String, Integer>();
    private boolean gennedFirstNests = false;
    private int nestAttempTick = 0;
    private ArrayList<String> nestLocations = new ArrayList();
    private transient HashSet<SuperChunk> neibors = new HashSet();
    private transient HashSet<SuperChunk> neiborsCorners = new HashSet();
    private transient Location centerCache;
    private transient ArrayList<Chunk> chunkCache;
    private transient ArrayList<Location> pollutingLocations = new ArrayList();
    private HashMap<String, String> landMineLocation = new HashMap();
    private transient HashMap<Location, UUID> cachedLandMines = new HashMap();
    private transient World cachedWorld;
    private transient int landMineCount = 0;
    private int ecoTimer = 5;
    private HashMap<String, Integer> worldInstructions;

    public static void tickSuperChunks() {
        if (skipTicks > 0) {
            --skipTicks;
            return;
        }
        ArrayList activeSupers = new ArrayList();
        for (Map.Entry<String, ArrayList<SuperChunk>> entry : superChunksByWorld.entrySet()) {
            World world = Bukkit.getWorld((String)entry.getKey());
            if (world == null) continue;
            activeSupers.addAll(entry.getValue());
        }
        if (activeSupers.isEmpty()) {
            return;
        }
        int chunksPerTick = (int)Math.ceil((double)activeSupers.size() / 20.0);
        int tick = 0;
        while (tick < 20) {
            int startIndex = tick * chunksPerTick;
            int endIndex = Math.min(startIndex + chunksPerTick, activeSupers.size());
            Bukkit.getScheduler().scheduleSyncDelayedTask(MineMain.getPlugin(), () -> {
                int i = startIndex;
                while (i < endIndex) {
                    ((SuperChunk)activeSupers.get(i)).tickSuperChunk();
                    ++i;
                }
            }, (long)tick);
            ++tick;
        }
    }

    private void tickSuperChunk() {
        if (!this.worldChecks) {
            this.worldChecks = true;
            if (MineMain.disabledBiterWorlds.contains(this.world) || MineMain.disabledWorlds.contains(this.world)) {
                this.disabledWorld = true;
            }
        }
        if (MineMain.useBiters && MineMain.generateNestsOnCreate && !this.disabledWorld) {
            this.doFirstSpawn();
        }
        if (MineMain.usePollution) {
            if (this.dissapationTagged) {
                this.sampleBiomes(false);
            }
            this.tickEcoSystem();
            this.disspatePollution();
            this.movePollution();
        }
        this.tickLandMines();
        if (MineMain.useBiters && !this.disabledWorld) {
            this.attemptNestSpawn(false, true);
        }
        this.dissapationTagged = false;
    }

    public SuperChunk(int x, int z, String worldName) {
        super("Super Chunks", x + "=" + z);
        this.x = x;
        this.z = z;
        this.world = worldName;
        this.registerSC(x, z);
        if (MineMain.nestSpawnTimer > 0) {
            this.nestAttempTick += TUMaths.rollRange(0, MineMain.nestSpawnTimer);
        }
    }

    @Override
    public void onCreate(boolean isFirstTime) {
        if (!isFirstTime) {
            this.registerSC(this.x, this.z);
            Bukkit.getServer().getScheduler().scheduleSyncDelayedTask(MineMain.getPlugin(), new Runnable(){

                @Override
                public void run() {
                    SuperChunk.this.validateNests();
                }
            }, 20L);
        }
        this.cacheLandMines();
    }

    public void validateNests() {
        if (this.nestLocations.size() == 0) {
            return;
        }
        for (String locSTR : new ArrayList<String>(this.nestLocations)) {
            Location loc = TUMaths.getStringLocation(locSTR);
            Device device = Device.getDevice(loc);
            if (device != null) {
                if (device.getName().equals("Biter Nest")) continue;
                this.removeNestLocation(loc);
                continue;
            }
            this.removeNestLocation(loc);
        }
    }

    public static ArrayList<SuperChunk> getAllSuperChunks() {
        return new ArrayList<SuperChunk>(allSuperChunks.values());
    }

    private void registerSC(int x, int z) {
        String key = SuperChunk.getKey(x, z);
        if (!allSuperChunks.containsKey(key)) {
            allSuperChunks.put(key, this);
            if (!superChunksByWorld.containsKey(this.world)) {
                superChunksByWorld.put(this.world, new ArrayList());
            }
            superChunksByWorld.get(this.world).add(this);
            allSupers.add(this);
        }
    }

    private static String getKey(int x, int z) {
        return x + "=" + z;
    }

    public static SuperChunk getSuperChunk(int superX, int superZ, String worldName) {
        String key = superX + "=" + superZ;
        SuperChunk sc = allSuperChunks.get(key);
        if (sc == null) {
            sc = new SuperChunk(superX, superZ, worldName);
        }
        return sc;
    }

    public static boolean superChunkExists(Location loc) {
        int superX = loc.getChunk().getX() / 3;
        int superZ = loc.getChunk().getZ() / 3;
        return SuperChunk.superChunkExists(superX, superZ);
    }

    public static boolean superChunkExists(int scX, int scZ) {
        String key = scX + "=" + scZ;
        return allSuperChunks.containsKey(key);
    }

    public static SuperChunk getSuperChunk(Location seedLoc) {
        int superX = seedLoc.getChunk().getX() / 3;
        int superZ = seedLoc.getChunk().getZ() / 3;
        return SuperChunk.getSuperChunk(superX, superZ, seedLoc.getWorld().getName());
    }

    public int getPollution() {
        return this.pollution;
    }

    public void addPollution(int amount) {
        this.setPollution(this.getPollution() + amount);
        this.setLifeSpanPollution(this.getLifeSpanPollution() + amount);
    }

    public void setPollution(int pollution) {
        this.pollution = pollution;
        if (this.pollution < 0) {
            this.pollution = 0;
        }
    }

    public int getDissapation() {
        if (this.cacheDiss2 != 0) {
            return this.cacheDiss2;
        }
        int diss = (int)((double)this.dissapation * MineMain.dissapationMP);
        if (diss < 2) {
            diss = 2;
        }
        this.cacheDiss2 = diss;
        return diss;
    }

    public void sampleBiomes(boolean force) {
        int z;
        if (this.sampled && !force) {
            return;
        }
        if (this.cachedWorld == null) {
            return;
        }
        if (this.sampledBiomes == null) {
            this.sampledBiomes = new ArrayList();
        }
        this.sampledBiomes.clear();
        int chunkX = this.x * 3;
        int chunkZ = this.z * 3;
        int x = chunkX - 1;
        while (x <= chunkX + 1) {
            z = chunkZ - 1;
            while (z <= chunkZ + 1) {
                if (!this.cachedWorld.isChunkLoaded(x, z)) {
                    return;
                }
                ++z;
            }
            ++x;
        }
        this.sampled = true;
        x = chunkX - 1;
        while (x <= chunkX + 1) {
            z = chunkZ - 1;
            while (z <= chunkZ + 1) {
                Block block = this.cachedWorld.getHighestBlockAt(this.cachedWorld.getChunkAt(x, z).getBlock(7, 0, 7).getLocation());
                String biomeStr = block.getBiome().toString();
                if (biomeStr.contains("terraformgenerator")) {
                    biomeStr = biomeStr.split(":")[1].toUpperCase();
                }
                this.sampledBiomes.add(biomeStr);
                ++z;
            }
            ++x;
        }
        this.cacheDiss2 = 0;
        this.updateDissapation();
    }

    public void updateDissapation() {
        int diss = 0;
        int defaults = 0;
        for (String biome : this.sampledBiomes) {
            int biomeDiss = SuperChunk.getDissipationValue(biome);
            if (biomeDiss == 0) {
                ++defaults;
                continue;
            }
            diss += biomeDiss;
        }
        if ((diss = (int)(((double)diss + (double)defaults * 0.25) * 0.5)) < 2) {
            diss = 2;
        }
        this.setDissapation(diss);
    }

    public static void loadDissipationValues(List<String> entries) {
        for (String entry : entries) {
            String[] split = entry.split(":");
            if (split.length != 2) continue;
            String[] patterns = split[0].split("/");
            int value = Integer.parseInt(split[1]);
            String[] stringArray = patterns;
            int n = patterns.length;
            int n2 = 0;
            while (n2 < n) {
                String check;
                String pattern = stringArray[n2];
                boolean wildcard = pattern.endsWith("*");
                String string = check = wildcard ? pattern.substring(0, pattern.length() - 1).toLowerCase() : pattern.toLowerCase();
                if (MineMain.usingTerraformGenerator) {
                    BiomeBank[] biomeBankArray = BiomeBank.values();
                    int n3 = biomeBankArray.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        Biome biome = biomeBankArray[n4];
                        String biomeName = biome.toString().toLowerCase();
                        if (wildcard && biomeName.contains(check) || !wildcard && biomeName.equals(check)) {
                            dissipationValues.put(biomeName, value);
                        }
                        ++n4;
                    }
                }
                for (Biome biome : Registry.BIOME) {
                    String biomeName = biome.toString().toLowerCase();
                    if (dissipationValues.containsKey(biomeName) || (!wildcard || !biomeName.contains(check)) && (wildcard || !biomeName.equals(check))) continue;
                    dissipationValues.put(biomeName, value);
                }
                ++n2;
            }
        }
    }

    public static int getDissipationValue(String biome) {
        return dissipationValues.getOrDefault(biome.toLowerCase(), 0);
    }

    public void setDissapation(int newDiss) {
        this.dissapation = newDiss;
    }

    private void doFirstSpawn() {
        if (!MineMain.generateNestsOnCreate) {
            return;
        }
        if (this.gennedFirstNests) {
            return;
        }
        World world = Bukkit.getWorld((String)this.world);
        if (world == null) {
            return;
        }
        int chunkX = this.x * 3;
        int chunkZ = this.z * 3;
        int x = chunkX - 1;
        while (x <= chunkX + 1) {
            int z = chunkZ - 1;
            while (z <= chunkZ + 1) {
                if (!world.isChunkLoaded(x, z)) {
                    return;
                }
                ++z;
            }
            ++x;
        }
        this.gennedFirstNests = true;
        int chance = (int)(100.0 * MineMain.nestGenChance);
        int i = 0;
        while (i < MineMain.nestGeneMaxSize) {
            if (chance <= 0 || TUMaths.rollRange(1, 100) > chance) break;
            this.attemptNestSpawn(true, false);
            chance = (int)((double)chance * MineMain.nestGenDiminish);
            ++i;
        }
    }

    public void attemptNestSpawn(boolean forced, boolean ignoreInhabitTime) {
        if (!forced) {
            --this.nestAttempTick;
        }
        if (this.nestAttempTick > 0 && !forced) {
            return;
        }
        if (!forced) {
            this.nestAttempTick = MineMain.nestSpawnTimer;
        }
        if (MineMain.nestSpawnTimer != -1 || forced) {
            int factor = MineMain.nestSpawnFactor;
            if (this.getPollution() >= factor && !this.hasPollutionSource() || forced) {
                int chance = this.getPollution() / factor;
                if (TUMaths.rollRange(0, 99) <= chance || forced) {
                    boolean hasSpace = true;
                    if (!forced) {
                        for (SuperChunk nsc : this.getNeibors(true)) {
                            if (!nsc.hasPollutionSource()) continue;
                            hasSpace = false;
                            break;
                        }
                    }
                    if (hasSpace) {
                        for (Chunk chunk : this.getChunks()) {
                            Location loc;
                            if ((ignoreInhabitTime || chunk.getInhabitedTime() < 36000L) && !this.getNestChunks().contains(chunk) && this.spawnNest(loc = chunk.getWorld().getHighestBlockAt(chunk.getBlock(TUMaths.rollRange(3, 12), 7, TUMaths.rollRange(3, 12)).getLocation()).getLocation())) break;
                        }
                    }
                }
            }
        }
    }

    public boolean spawnNest(Location loc) {
        boolean spawned = false;
        if (!loc.getBlock().getType().equals((Object)Material.WATER)) {
            boolean spawnAllowed = true;
            if (MineMain.noBiterZones.containsKey(this.world)) {
                for (Location noBiterLoc : MineMain.noBiterZones.get(this.world)) {
                    if (!TUMaths.isLocationNearby(noBiterLoc, loc, MineMain.noBiterZonesRange.get(noBiterLoc).intValue())) continue;
                    spawnAllowed = false;
                    break;
                }
            }
            if (spawnAllowed) {
                loc.add(0.0, 1.0, 0.0);
                BiterNest nest = new BiterNest(loc, true);
                nest.compute();
                this.nestLocations.add(TUMaths.locationString(loc));
                spawned = true;
            }
        }
        return spawned;
    }

    public Location getPossibleNestLocation(boolean ignoreInhabitTime) {
        for (Chunk chunk : this.getChunks()) {
            Location loc;
            if (!ignoreInhabitTime && chunk.getInhabitedTime() >= 36000L || this.getNestChunks().contains(chunk) || (loc = chunk.getWorld().getHighestBlockAt(chunk.getBlock(TUMaths.rollRange(3, 12), 7, TUMaths.rollRange(3, 12)).getLocation()).getLocation()).getBlock().getType().equals((Object)Material.WATER)) continue;
            loc.add(0.0, 1.0, 0.0);
            return loc;
        }
        return null;
    }

    public int getNestCount() {
        return this.nestLocations.size();
    }

    private ArrayList<Chunk> getNestChunks() {
        ArrayList<Chunk> chunks = new ArrayList<Chunk>();
        for (String strLoc : this.nestLocations) {
            chunks.add(TUMaths.getStringLocation(strLoc).getChunk());
        }
        return chunks;
    }

    public void removeNestLocation(Location loc) {
        this.nestLocations.remove(TUMaths.locationString(loc));
    }

    private void disspatePollution() {
        if (this.getPollution() > 0) {
            this.setPollution(this.getPollution() - this.getDissapation());
        }
        if (this.getLifeSpanPollution() > 0) {
            this.setLifeSpanPollution(this.getLifeSpanPollution() - 2);
        }
    }

    private void movePollution() {
        double pollutionToMove;
        int pollutionPerMove;
        if (this.getPollution() > 100 && (pollutionPerMove = (int)((pollutionToMove = (double)this.getPollution() * MineMain.pollmovePCT) / 4.0)) >= 1) {
            for (SuperChunk sc : this.getNeibors(false)) {
                sc.addPollution(pollutionPerMove);
                this.setPollution(this.getPollution() - pollutionPerMove);
            }
        }
    }

    public HashSet<SuperChunk> getNeibors(boolean includeCorners) {
        if (!includeCorners) {
            if (this.neibors != null && this.neibors.size() != 0) {
                return this.neibors;
            }
            HashSet<SuperChunk> neibors = new HashSet<SuperChunk>();
            neibors.add(SuperChunk.getSuperChunk(this.x - 1, this.z, this.world));
            neibors.add(SuperChunk.getSuperChunk(this.x + 1, this.z, this.world));
            neibors.add(SuperChunk.getSuperChunk(this.x, this.z - 1, this.world));
            neibors.add(SuperChunk.getSuperChunk(this.x, this.z + 1, this.world));
            this.neibors = neibors;
            return this.neibors;
        }
        if (this.neiborsCorners != null && this.neiborsCorners.size() != 0) {
            return this.neiborsCorners;
        }
        HashSet<SuperChunk> neibors = new HashSet<SuperChunk>();
        neibors.add(SuperChunk.getSuperChunk(this.x - 1, this.z, this.world));
        neibors.add(SuperChunk.getSuperChunk(this.x + 1, this.z, this.world));
        neibors.add(SuperChunk.getSuperChunk(this.x, this.z - 1, this.world));
        neibors.add(SuperChunk.getSuperChunk(this.x, this.z + 1, this.world));
        neibors.add(SuperChunk.getSuperChunk(this.x + 1, this.z + 1, this.world));
        neibors.add(SuperChunk.getSuperChunk(this.x - 1, this.z - 1, this.world));
        neibors.add(SuperChunk.getSuperChunk(this.x - 1, this.z + 1, this.world));
        neibors.add(SuperChunk.getSuperChunk(this.x + 1, this.z - 1, this.world));
        this.neiborsCorners = neibors;
        return this.neiborsCorners;
    }

    public ArrayList<String> getBiomes() {
        if (this.sampledBiomes == null) {
            this.sampledBiomes = new ArrayList();
        }
        return new ArrayList<String>(this.sampledBiomes);
    }

    public Chunk getCenterChunk() {
        int chunkX = this.x * 3;
        int chunkZ = this.z * 3;
        World world = Bukkit.getWorld((String)this.world);
        return world.getChunkAt(chunkX, chunkZ);
    }

    public Location getCenterLocation() {
        if (this.centerCache != null) {
            return this.centerCache;
        }
        int x = this.x * 16 * 3;
        int z = this.z * 16 * 3;
        this.centerCache = new Location(Bukkit.getWorld((String)this.world), (double)x, 0.0, (double)z);
        return this.centerCache;
    }

    public ArrayList<Chunk> getChunks() {
        if (this.chunkCache != null) {
            return this.chunkCache;
        }
        ArrayList<Chunk> chunks = new ArrayList<Chunk>();
        Chunk center = this.getCenterChunk();
        chunks.add(center);
        int x = -1;
        while (x <= 1) {
            int z = -1;
            while (z <= 1) {
                chunks.add(center.getWorld().getChunkAt(center.getX() + x, center.getZ() + z));
                ++z;
            }
            ++x;
        }
        this.chunkCache = chunks;
        return this.chunkCache;
    }

    public void addPollutingLocation(Location loc) {
        if (this.pollutingLocations == null) {
            this.pollutingLocations = new ArrayList();
        }
        if (!this.pollutingLocations.contains(loc)) {
            this.pollutingLocations.add(loc);
        }
    }

    public boolean hasPollutionSource() {
        if (this.pollutingLocations == null) {
            this.pollutingLocations = new ArrayList();
        }
        return this.pollutingLocations.size() > 0;
    }

    public ArrayList<Location> getPollutionSources() {
        return this.pollutingLocations;
    }

    public void addLandMine(Location loc, UUID placer) {
        String strLoc;
        if (this.cachedLandMines == null) {
            this.cachedLandMines = new HashMap();
        }
        if (!this.landMineLocation.containsKey(strLoc = TUMaths.locationString(loc))) {
            this.landMineLocation.put(strLoc, placer.toString());
            this.cachedLandMines.put(loc, placer);
            ++this.landMineCount;
        }
    }

    public HashMap<Location, UUID> getLandMines() {
        if (this.cachedLandMines == null) {
            this.cachedLandMines = new HashMap();
        }
        return new HashMap<Location, UUID>(this.cachedLandMines);
    }

    public void cacheLandMines() {
        if (this.world == null) {
            return;
        }
        if (this.cachedWorld == null) {
            this.cachedWorld = Bukkit.getWorld((String)this.world);
        }
        if (this.landMineLocation == null) {
            this.landMineLocation = new HashMap();
        }
        if (this.cachedLandMines == null) {
            this.cachedLandMines = new HashMap();
        }
        for (String strLoc : new ArrayList<String>(this.landMineLocation.keySet())) {
            this.cachedLandMines.put(TUMaths.getStringLocation(strLoc), UUID.fromString(this.landMineLocation.get(strLoc)));
            ++this.landMineCount;
        }
    }

    public void removeLandMine(Location loc) {
        if (this.cachedLandMines.containsKey(loc)) {
            this.cachedLandMines.remove(loc);
            --this.landMineCount;
            this.landMineLocation.remove(TUMaths.locationString(loc));
        }
    }

    public Location getNearbyLandMine(Location loc, int distance) {
        if (this.cachedLandMines == null) {
            this.cachedLandMines = new HashMap();
        }
        for (Location landMineLoc : this.cachedLandMines.keySet()) {
            if (TUMaths.getManhattanDistance(landMineLoc, loc) > distance) continue;
            return landMineLoc.clone();
        }
        return null;
    }

    public boolean hasLandMine(Location loc) {
        return this.cachedLandMines.containsKey(loc);
    }

    public void tripLandMine(Location landMine) {
        this.removeLandMine(landMine);
        if (TUMaths.isPlayerNearby(landMine, 32.0)) {
            landMine.getWorld().playSound(landMine, Sound.ENTITY_GENERIC_EXPLODE, 1.0f, 0.75f);
            MinetorioListener.spawnRandomParticles(landMine, 1, MineMain.version.getExplosionParticle(), 2, 0L, 5, -1.0);
            MinetorioListener.spawnRandomParticles(landMine, 3, MineMain.version.getSmokeParticle(), 30, 15L, 1, 0.001);
            MinetorioListener.spawnRandomParticles(landMine, 1, MineMain.version.getSmokeParticle(), 30, 10L, 1, -1.0);
        }
        for (Entity entity : landMine.getWorld().getNearbyEntities(landMine, 6.0, 6.0, 6.0)) {
            if (!(entity instanceof LivingEntity)) continue;
            LivingEntity lent = (LivingEntity)entity;
            lent.damage(10.0);
        }
    }

    private void tickLandMines() {
        if (this.landMineCount <= 0) {
            return;
        }
        if (this.world == null) {
            return;
        }
        if (this.cachedLandMines == null) {
            this.cachedLandMines = new HashMap();
        }
        if (this.cachedLandMines.size() == 0) {
            return;
        }
        if (this.cachedWorld == null) {
            this.cachedWorld = Bukkit.getWorld((String)this.world);
        }
        if (this.cachedWorld == null) {
            return;
        }
        if (this.getCenterLocation() != null && TUMaths.isPlayerNearby2D(this.getCenterLocation(), MineMain.chunkViewDistance)) {
            block0: for (Location landMineLoc : new ArrayList<Location>(this.cachedLandMines.keySet())) {
                int chunkZ;
                int chunkX = landMineLoc.getBlockX() >> 4;
                if (!this.cachedWorld.isChunkLoaded(chunkX, chunkZ = landMineLoc.getBlockZ() >> 4)) continue;
                for (Entity entity : this.cachedWorld.getNearbyEntities(landMineLoc, 2.0, 2.0, 2.0)) {
                    if (!(entity instanceof Monster)) continue;
                    this.tripLandMine(landMineLoc);
                    continue block0;
                }
            }
        }
    }

    public int getLifeSpanPollution() {
        return this.lifeSpanPollution;
    }

    public void setLifeSpanPollution(int lifeSpanPollution) {
        this.lifeSpanPollution = lifeSpanPollution;
    }

    public int getEvolutionPercent() {
        return (int)((double)this.getLifeSpanPollution() / 10000.0);
    }

    public int getEcoDamagePCT() {
        return (int)((double)this.getEcoDamage() / 1000.0 * 100.0);
    }

    public int getEcoDamage() {
        return this.ecoDamage;
    }

    public void setEcoDamage(int ecoDamage) {
        if (ecoDamage > 1000) {
            ecoDamage = 1000;
        }
        this.ecoDamage = ecoDamage;
    }

    public void tickEcoSystem() {
        if (!MineMain.usePollutionAltering) {
            return;
        }
        --this.ecoTimer;
        if (this.ecoTimer <= 0) {
            this.adjustEcoDamage();
            this.queAlterations();
            this.ecoTimer = 5;
        }
        this.alterChunks();
    }

    private void adjustEcoDamage() {
        if (this.getPollution() > 200) {
            double factor = (double)this.getPollution() / 200.0;
            if (factor >= 1.0) {
                if ((double)TUMaths.rollRange(0, 199) <= factor) {
                    this.setEcoDamage(this.getEcoDamage() + 1);
                }
            } else if (this.getEcoDamage() > 0 && TUMaths.rollRange(0, 99) <= 10) {
                this.setEcoDamage(this.getEcoDamage() - 1);
            }
        } else if (this.getPollution() < 50 && this.getEcoDamage() > 0 && TUMaths.rollRange(0, 99) <= 25) {
            this.setEcoDamage(this.getEcoDamage() - 1);
        }
    }

    private void queAlterations() {
        if (this.world == null) {
            return;
        }
        if (this.cachedWorld == null) {
            this.cachedWorld = Bukkit.getWorld((String)this.world);
        }
        if (this.cachedWorld == null) {
            return;
        }
        int chance = this.getEcoDamage() / 10;
        if (chance == 0) {
            return;
        }
        if (TUMaths.rollRange(0, 99) > chance) {
            return;
        }
        int cx = this.x * 3 + TUMaths.rollRange(-1, 1);
        int cz = this.z * 3 + TUMaths.rollRange(-1, 1);
        String key = cx + ":" + cz;
        this.getWorldInstructions().put(key, this.getWorldInstructions().getOrDefault(key, 0) + 1);
    }

    public HashMap<String, Integer> getWorldInstructions() {
        if (this.worldInstructions == null) {
            this.worldInstructions = new HashMap();
        }
        return this.worldInstructions;
    }

    private void alterChunks() {
        if (!this.dissapationTagged) {
            return;
        }
        HashMap<String, Integer> alterations = this.getWorldInstructions();
        if (alterations.size() == 0) {
            return;
        }
        for (String order : new ArrayList<String>(this.worldInstructions.keySet())) {
            Chunk chunk = this.cachedWorld.getChunkAt(Integer.valueOf(order.split(":")[0]).intValue(), Integer.valueOf(order.split(":")[1]).intValue());
            int i = 0;
            while (i < alterations.get(order)) {
                Block block = chunk.getBlock(TUMaths.rollRange(0, 15), 64, TUMaths.rollRange(0, 15));
                block = block.getWorld().getHighestBlockAt(block.getLocation());
                this.alterBlock(block.getRelative(BlockFace.UP));
                this.alterBlock(block);
                ++i;
            }
            alterations.remove(order);
        }
    }

    private void alterBlock(Block block) {
        Material newType = null;
        if (block.getType().toString().contains("_LEAVES")) {
            newType = Material.AIR;
        }
        if (newType == null && block.getType().toString().contains("_LOG")) {
            while (block.getType().equals((Object)Material.PALE_OAK_LOG)) {
                block = block.getRelative(BlockFace.DOWN);
            }
            if (block.getType().toString().contains("_LOG")) {
                newType = Material.PALE_OAK_LOG;
            }
            for (Block near : TUMaths.getNearbyBlocks(block, 2)) {
                if (TUMaths.rollRange(0, 1) != 0 || !near.getType().toString().contains("_LEAVES") || near.getType().equals((Object)Material.PALE_OAK_LEAVES)) continue;
                near.setType(Material.PALE_OAK_LEAVES);
            }
        }
        if (newType == null && block.getType().toString().contains("SHORT_GRASS")) {
            if (!MineMain.is1214) {
                newType = Material.SHORT_DRY_GRASS;
                if (TUMaths.rollRange(0, 99) <= 10) {
                    newType = Material.DEAD_BUSH;
                }
            } else {
                newType = Material.DEAD_BUSH;
            }
        }
        if (newType == null && block.getType().toString().contains("TALL_GRASS")) {
            newType = !MineMain.is1214 ? Material.TALL_DRY_GRASS : Material.DEAD_BUSH;
        }
        if (newType == null && block.getBlockData() instanceof Ageable) {
            newType = Material.AIR;
        }
        if (newType == null) {
            if (block.getType().equals((Object)Material.CACTUS)) {
                newType = Material.AIR;
            }
            if (block.getType().equals((Object)Material.SUGAR_CANE)) {
                newType = Material.AIR;
            }
            if (block.getType().equals((Object)Material.PUMPKIN)) {
                newType = Material.AIR;
            }
            if (block.getType().equals((Object)Material.MELON)) {
                newType = Material.AIR;
            }
        }
        if (newType == null && newType == null && Tag.SMALL_FLOWERS.isTagged((Keyed)block.getType())) {
            switch (TUMaths.rollRange(0, 7)) {
                case 0: {
                    newType = Material.DEAD_BRAIN_CORAL;
                    break;
                }
                case 1: {
                    newType = Material.DEAD_TUBE_CORAL;
                    break;
                }
                case 2: {
                    newType = Material.DEAD_BUBBLE_CORAL;
                    break;
                }
                case 3: {
                    newType = Material.DEAD_FIRE_CORAL;
                    break;
                }
                case 4: {
                    newType = Material.DEAD_HORN_CORAL_FAN;
                    break;
                }
                case 5: {
                    newType = Material.DEAD_TUBE_CORAL_FAN;
                    break;
                }
                case 6: {
                    newType = Material.DEAD_FIRE_CORAL_FAN;
                    break;
                }
                case 7: {
                    newType = Material.DEAD_BUBBLE_CORAL_FAN;
                }
            }
        }
        if (newType == null && Tag.FLOWERS.isTagged((Keyed)block.getType())) {
            newType = !MineMain.is1214 ? Material.TALL_DRY_GRASS : Material.DEAD_BUSH;
        }
        if (newType == null && block.getType().equals((Object)Material.GRASS_BLOCK)) {
            newType = Material.COARSE_DIRT;
            if (TUMaths.rollRange(0, 99) <= 20) {
                newType = Material.ROOTED_DIRT;
            }
            if (TUMaths.rollRange(0, 99) <= 5) {
                newType = Material.GRAVEL;
            }
        }
        if (newType != null) {
            Axis ax = null;
            BlockData blockData = block.getBlockData();
            if (blockData instanceof Orientable) {
                Orientable orig = (Orientable)blockData;
                ax = orig.getAxis();
            }
            block.setType(newType);
            BlockData data = block.getBlockData();
            if (data instanceof Waterlogged) {
                ((Waterlogged)data).setWaterlogged(false);
                block.setBlockData(data, false);
            }
            if (ax != null && newType.equals((Object)Material.PALE_OAK_LOG) && data instanceof Orientable) {
                Orientable orientable = (Orientable)data;
                orientable.setAxis(ax);
                block.setBlockData((BlockData)orientable, false);
            }
        }
    }
}

