/*
 * Decompiled with CFR 0.152.
 */
package ua.valeriishymchuk.simpleitemgenerator;

import java.util.function.Function;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;
import ua.valeriishymchuk.simpleitemgenerator.commandframework.CommandManager;
import ua.valeriishymchuk.simpleitemgenerator.commandframework.bukkit.BukkitCommandManager;
import ua.valeriishymchuk.simpleitemgenerator.commandframework.execution.CommandExecutionCoordinator;
import ua.valeriishymchuk.simpleitemgenerator.commandframework.minecraft.extras.MinecraftExceptionHandler;
import ua.valeriishymchuk.simpleitemgenerator.common.config.ConfigLoader;
import ua.valeriishymchuk.simpleitemgenerator.common.config.builder.ConfigLoaderConfigurationBuilder;
import ua.valeriishymchuk.simpleitemgenerator.common.message.KyoriHelper;
import ua.valeriishymchuk.simpleitemgenerator.common.metrics.MetricsHelper;
import ua.valeriishymchuk.simpleitemgenerator.common.scheduler.BukkitTaskScheduler;
import ua.valeriishymchuk.simpleitemgenerator.controller.CommandsController;
import ua.valeriishymchuk.simpleitemgenerator.controller.EventsController;
import ua.valeriishymchuk.simpleitemgenerator.controller.TickController;
import ua.valeriishymchuk.simpleitemgenerator.kyori.adventure.audience.Audience;
import ua.valeriishymchuk.simpleitemgenerator.kyori.adventure.text.Component;
import ua.valeriishymchuk.simpleitemgenerator.repository.impl.ConfigRepository;
import ua.valeriishymchuk.simpleitemgenerator.service.impl.ItemService;
import ua.valeriishymchuk.simpleitemgenerator.spongepowered.configurate.yaml.NodeStyle;

public final class SimpleItemGeneratorPlugin
extends JavaPlugin {
    public void onEnable() {
        ConfigLoader configLoader = this.yamlLoader();
        CommandManager<CommandSender> commandManager = this.setupCommandManager();
        BukkitTaskScheduler taskScheduler = new BukkitTaskScheduler((Plugin)this);
        ConfigRepository configRepository = new ConfigRepository(configLoader);
        if (!configRepository.reload()) {
            this.getLogger().severe("Failed to load config. Shutting down...");
            Bukkit.getPluginManager().disablePlugin((Plugin)this);
            return;
        }
        ItemService itemService = new ItemService(configRepository);
        new CommandsController(itemService).setupCommands(commandManager);
        Bukkit.getPluginManager().registerEvents((Listener)new EventsController(itemService), (Plugin)this);
        new TickController(itemService, taskScheduler).start();
        MetricsHelper.init(this);
    }

    public void onDisable() {
        MetricsHelper.shutdown();
    }

    private ConfigLoader yamlLoader() {
        return new ConfigLoader(this.getDataFolder(), ".yml", ConfigLoaderConfigurationBuilder.yaml().peekBuilder(b -> b.indent(2).nodeStyle(NodeStyle.BLOCK)).build());
    }

    private CommandManager<CommandSender> setupCommandManager() {
        BukkitCommandManager<CommandSender> manager = new BukkitCommandManager<CommandSender>((Plugin)this, CommandExecutionCoordinator.simpleCoordinator(), Function.identity(), Function.identity());
        new MinecraftExceptionHandler().withDefaultHandlers().withHandler(MinecraftExceptionHandler.ExceptionType.NO_PERMISSION, (sender, exception) -> Component.text("You don't have permission to use this command! " + exception.getMessage())).withHandler(MinecraftExceptionHandler.ExceptionType.INVALID_SYNTAX, (sender, exception) -> Component.text("Invalid syntax! " + exception.getMessage())).apply(manager, s2 -> new Audience((CommandSender)s2){
            final /* synthetic */ CommandSender val$s;
            {
                this.val$s = commandSender;
            }

            @Override
            public void sendMessage(@NotNull Component message) {
                KyoriHelper.sendMessage(this.val$s, message);
            }
        });
        return manager;
    }
}

