/*
 * Decompiled with CFR 0.152.
 */
package ua.valeriishymchuk.simpleitemgenerator.commandframework.arguments.standard;

import java.util.List;
import java.util.Objects;
import java.util.Queue;
import java.util.function.BiFunction;
import org.apiguardian.api.API;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import ua.valeriishymchuk.simpleitemgenerator.commandframework.ArgumentDescription;
import ua.valeriishymchuk.simpleitemgenerator.commandframework.arguments.CommandArgument;
import ua.valeriishymchuk.simpleitemgenerator.commandframework.arguments.parser.ArgumentParseResult;
import ua.valeriishymchuk.simpleitemgenerator.commandframework.arguments.parser.ArgumentParser;
import ua.valeriishymchuk.simpleitemgenerator.commandframework.captions.CaptionVariable;
import ua.valeriishymchuk.simpleitemgenerator.commandframework.captions.StandardCaptionKeys;
import ua.valeriishymchuk.simpleitemgenerator.commandframework.context.CommandContext;
import ua.valeriishymchuk.simpleitemgenerator.commandframework.exceptions.parsing.NoInputProvidedException;
import ua.valeriishymchuk.simpleitemgenerator.commandframework.exceptions.parsing.ParserException;

@API(status=API.Status.STABLE)
public final class CharArgument<C>
extends CommandArgument<C, Character> {
    private CharArgument(boolean required, @NonNull String name, @NonNull String defaultValue, @Nullable BiFunction<@NonNull CommandContext<C>, @NonNull String, @NonNull List<@NonNull String>> suggestionsProvider, @NonNull ArgumentDescription defaultDescription) {
        super(required, name, new CharacterParser(), defaultValue, Character.class, suggestionsProvider, defaultDescription);
    }

    @API(status=API.Status.STABLE, since="1.8.0")
    public static <C> @NonNull Builder<C> builder(@NonNull String name) {
        return new Builder(name);
    }

    @API(status=API.Status.DEPRECATED, since="1.8.0")
    @Deprecated
    public static <C> @NonNull Builder<C> newBuilder(@NonNull String name) {
        return CharArgument.builder(name);
    }

    public static <C> @NonNull CommandArgument<C, Character> of(@NonNull String name) {
        return CharArgument.builder(name).asRequired().build();
    }

    public static <C> @NonNull CommandArgument<C, Character> optional(@NonNull String name) {
        return CharArgument.builder(name).asOptional().build();
    }

    public static <C> @NonNull CommandArgument<C, Character> optional(@NonNull String name, @NonNull String defaultNum) {
        return CharArgument.builder(name).asOptionalWithDefault(defaultNum).build();
    }

    @API(status=API.Status.STABLE)
    public static final class CharacterParser<C>
    implements ArgumentParser<C, Character> {
        @Override
        public @NonNull ArgumentParseResult<Character> parse(@NonNull CommandContext<C> commandContext, @NonNull Queue<@NonNull String> inputQueue) {
            String input = inputQueue.peek();
            if (input == null) {
                return ArgumentParseResult.failure(new NoInputProvidedException(CharacterParser.class, commandContext));
            }
            if (input.length() != 1) {
                return ArgumentParseResult.failure(new CharParseException(input, commandContext));
            }
            inputQueue.remove();
            return ArgumentParseResult.success(Character.valueOf(input.charAt(0)));
        }

        @Override
        public boolean isContextFree() {
            return true;
        }
    }

    @API(status=API.Status.STABLE)
    public static final class Builder<C>
    extends CommandArgument.Builder<C, Character> {
        private Builder(@NonNull String name) {
            super(Character.class, name);
        }

        public @NonNull CharArgument<C> build() {
            return new CharArgument(this.isRequired(), this.getName(), this.getDefaultValue(), this.getSuggestionsProvider(), this.getDefaultDescription());
        }
    }

    @API(status=API.Status.STABLE)
    public static final class CharParseException
    extends ParserException {
        private static final long serialVersionUID = 6458851071584278854L;
        private final String input;

        public CharParseException(@NonNull String input, @NonNull CommandContext<?> context) {
            super(CharacterParser.class, context, StandardCaptionKeys.ARGUMENT_PARSE_FAILURE_CHAR, CaptionVariable.of("input", input));
            this.input = input;
        }

        public @NonNull String getInput() {
            return this.input;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CharParseException that = (CharParseException)o;
            return this.input.equals(that.input);
        }

        public int hashCode() {
            return Objects.hash(this.input);
        }
    }
}

