/*
 * Decompiled with CFR 0.152.
 */
package ua.valeriishymchuk.simpleitemgenerator.commandframework.arguments.standard;

import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Queue;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import org.apiguardian.api.API;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import ua.valeriishymchuk.simpleitemgenerator.commandframework.ArgumentDescription;
import ua.valeriishymchuk.simpleitemgenerator.commandframework.arguments.CommandArgument;
import ua.valeriishymchuk.simpleitemgenerator.commandframework.arguments.parser.ArgumentParseResult;
import ua.valeriishymchuk.simpleitemgenerator.commandframework.arguments.parser.ArgumentParser;
import ua.valeriishymchuk.simpleitemgenerator.commandframework.captions.CaptionVariable;
import ua.valeriishymchuk.simpleitemgenerator.commandframework.captions.StandardCaptionKeys;
import ua.valeriishymchuk.simpleitemgenerator.commandframework.context.CommandContext;
import ua.valeriishymchuk.simpleitemgenerator.commandframework.exceptions.parsing.NoInputProvidedException;
import ua.valeriishymchuk.simpleitemgenerator.commandframework.exceptions.parsing.ParserException;

@API(status=API.Status.STABLE)
public class EnumArgument<C, E extends Enum<E>>
extends CommandArgument<C, E> {
    protected EnumArgument(@NonNull Class<E> enumClass, boolean required, @NonNull String name, @NonNull String defaultValue, @Nullable BiFunction<@NonNull CommandContext<C>, @NonNull String, @NonNull List<@NonNull String>> suggestionsProvider, @NonNull ArgumentDescription defaultDescription) {
        super(required, name, new EnumParser(enumClass), defaultValue, enumClass, suggestionsProvider, defaultDescription);
    }

    @API(status=API.Status.STABLE, since="1.8.0")
    public static <C, E extends Enum<E>> @NonNull Builder<C, E> builder(@NonNull Class<E> enumClass, @NonNull String name) {
        return new Builder(name, enumClass);
    }

    @API(status=API.Status.DEPRECATED, since="1.8.0")
    @Deprecated
    public static <C, E extends Enum<E>> @NonNull Builder<C, E> newBuilder(@NonNull Class<E> enumClass, @NonNull String name) {
        return EnumArgument.builder(enumClass, name);
    }

    public static <C, E extends Enum<E>> @NonNull CommandArgument<C, E> of(@NonNull Class<E> enumClass, @NonNull String name) {
        return EnumArgument.builder(enumClass, name).asRequired().build();
    }

    public static <C, E extends Enum<E>> @NonNull CommandArgument<C, E> optional(@NonNull Class<E> enumClass, @NonNull String name) {
        return EnumArgument.builder(enumClass, name).asOptional().build();
    }

    public static <C, E extends Enum<E>> @NonNull CommandArgument<C, E> optional(@NonNull Class<E> enumClass, @NonNull String name, @NonNull E defaultValue) {
        return EnumArgument.builder(enumClass, name).asOptionalWithDefault(defaultValue.name().toLowerCase()).build();
    }

    @API(status=API.Status.STABLE)
    public static final class EnumParser<C, E extends Enum<E>>
    implements ArgumentParser<C, E> {
        private final Class<E> enumClass;
        private final EnumSet<E> allowedValues;

        public EnumParser(@NonNull Class<E> enumClass) {
            this.enumClass = enumClass;
            this.allowedValues = EnumSet.allOf(enumClass);
        }

        @Override
        public @NonNull ArgumentParseResult<E> parse(@NonNull CommandContext<C> commandContext, @NonNull Queue<@NonNull String> inputQueue) {
            String input = inputQueue.peek();
            if (input == null) {
                return ArgumentParseResult.failure(new NoInputProvidedException(EnumParser.class, commandContext));
            }
            for (Enum value : this.allowedValues) {
                if (!value.name().equalsIgnoreCase(input)) continue;
                inputQueue.remove();
                return ArgumentParseResult.success(value);
            }
            return ArgumentParseResult.failure(new EnumParseException(input, this.enumClass, commandContext));
        }

        @Override
        public @NonNull List<@NonNull String> suggestions(@NonNull CommandContext<C> commandContext, @NonNull String input) {
            return EnumSet.allOf(this.enumClass).stream().map((? super T e) -> e.name().toLowerCase()).collect(Collectors.toList());
        }

        @Override
        public boolean isContextFree() {
            return true;
        }
    }

    @API(status=API.Status.STABLE)
    public static final class Builder<C, E extends Enum<E>>
    extends CommandArgument.Builder<C, E> {
        private final Class<E> enumClass;

        private Builder(@NonNull String name, @NonNull Class<E> enumClass) {
            super(enumClass, name);
            this.enumClass = enumClass;
        }

        @Override
        public @NonNull CommandArgument<C, E> build() {
            return new EnumArgument(this.enumClass, this.isRequired(), this.getName(), this.getDefaultValue(), this.getSuggestionsProvider(), this.getDefaultDescription());
        }
    }

    @API(status=API.Status.STABLE)
    public static final class EnumParseException
    extends ParserException {
        private static final long serialVersionUID = 3465389578951428862L;
        private final String input;
        private final Class<? extends Enum<?>> enumClass;

        public EnumParseException(@NonNull String input, @NonNull Class<? extends Enum<?>> enumClass, @NonNull CommandContext<?> context) {
            super(EnumParser.class, context, StandardCaptionKeys.ARGUMENT_PARSE_FAILURE_ENUM, CaptionVariable.of("input", input), CaptionVariable.of("acceptableValues", EnumParseException.join(enumClass)));
            this.input = input;
            this.enumClass = enumClass;
        }

        private static @NonNull String join(@NonNull Class<? extends Enum> clazz) {
            EnumSet<? extends Enum> enumSet = EnumSet.allOf(clazz);
            return enumSet.stream().map(e -> e.toString().toLowerCase()).collect(Collectors.joining(", "));
        }

        public @NonNull String getInput() {
            return this.input;
        }

        public @NonNull Class<? extends Enum<?>> getEnumClass() {
            return this.enumClass;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            EnumParseException that = (EnumParseException)o;
            return this.input.equals(that.input) && this.enumClass.equals(that.enumClass);
        }

        public int hashCode() {
            return Objects.hash(this.input, this.enumClass);
        }
    }
}

