/*
 * Decompiled with CFR 0.152.
 */
package ua.valeriishymchuk.simpleitemgenerator.commandframework.arguments.standard;

import java.util.List;
import java.util.Objects;
import java.util.Queue;
import java.util.function.BiFunction;
import org.apiguardian.api.API;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.common.returnsreceiver.qual.This;
import ua.valeriishymchuk.simpleitemgenerator.commandframework.ArgumentDescription;
import ua.valeriishymchuk.simpleitemgenerator.commandframework.arguments.CommandArgument;
import ua.valeriishymchuk.simpleitemgenerator.commandframework.arguments.parser.ArgumentParseResult;
import ua.valeriishymchuk.simpleitemgenerator.commandframework.arguments.parser.ArgumentParser;
import ua.valeriishymchuk.simpleitemgenerator.commandframework.context.CommandContext;
import ua.valeriishymchuk.simpleitemgenerator.commandframework.exceptions.parsing.NoInputProvidedException;
import ua.valeriishymchuk.simpleitemgenerator.commandframework.exceptions.parsing.NumberParseException;

@API(status=API.Status.STABLE)
public final class FloatArgument<C>
extends CommandArgument<C, Float> {
    private final float min;
    private final float max;

    private FloatArgument(boolean required, @NonNull String name, float min2, float max, @NonNull String defaultValue, @Nullable BiFunction<@NonNull CommandContext<C>, @NonNull String, @NonNull List<@NonNull String>> suggestionsProvider, @NonNull ArgumentDescription defaultDescription) {
        super(required, name, new FloatParser(min2, max), defaultValue, Float.class, suggestionsProvider, defaultDescription);
        this.min = min2;
        this.max = max;
    }

    @API(status=API.Status.STABLE, since="1.8.0")
    public static <C> @NonNull Builder<C> builder(@NonNull String name) {
        return new Builder(name);
    }

    @API(status=API.Status.DEPRECATED, since="1.8.0")
    @Deprecated
    public static <C> @NonNull Builder<C> newBuilder(@NonNull String name) {
        return FloatArgument.builder(name);
    }

    public static <C> @NonNull CommandArgument<C, Float> of(@NonNull String name) {
        return FloatArgument.builder(name).asRequired().build();
    }

    public static <C> @NonNull CommandArgument<C, Float> optional(@NonNull String name) {
        return FloatArgument.builder(name).asOptional().build();
    }

    public static <C> @NonNull CommandArgument<C, Float> optional(@NonNull String name, float defaultNum) {
        return FloatArgument.builder(name).asOptionalWithDefault(defaultNum).build();
    }

    public float getMin() {
        return this.min;
    }

    public float getMax() {
        return this.max;
    }

    @API(status=API.Status.STABLE)
    public static final class FloatParser<C>
    implements ArgumentParser<C, Float> {
        @API(status=API.Status.STABLE, since="1.5.0")
        public static final float DEFAULT_MINIMUM = Float.NEGATIVE_INFINITY;
        @API(status=API.Status.STABLE, since="1.5.0")
        public static final float DEFAULT_MAXIMUM = Float.POSITIVE_INFINITY;
        private final float min;
        private final float max;

        public FloatParser(float min2, float max) {
            this.min = min2;
            this.max = max;
        }

        @Override
        public @NonNull ArgumentParseResult<Float> parse(@NonNull CommandContext<C> commandContext, @NonNull Queue<String> inputQueue) {
            String input = inputQueue.peek();
            if (input == null) {
                return ArgumentParseResult.failure(new NoInputProvidedException(FloatParser.class, commandContext));
            }
            try {
                float value = Float.parseFloat(input);
                if (value < this.min || value > this.max) {
                    return ArgumentParseResult.failure(new FloatParseException(input, this, commandContext));
                }
                inputQueue.remove();
                return ArgumentParseResult.success(Float.valueOf(value));
            }
            catch (Exception e) {
                return ArgumentParseResult.failure(new FloatParseException(input, this, commandContext));
            }
        }

        @Override
        public boolean isContextFree() {
            return true;
        }

        public float getMax() {
            return this.max;
        }

        public float getMin() {
            return this.min;
        }

        @API(status=API.Status.STABLE, since="1.5.0")
        public boolean hasMax() {
            return this.max != Float.POSITIVE_INFINITY;
        }

        @API(status=API.Status.STABLE, since="1.5.0")
        public boolean hasMin() {
            return this.min != Float.NEGATIVE_INFINITY;
        }
    }

    @API(status=API.Status.STABLE)
    public static final class Builder<C>
    extends CommandArgument.Builder<C, Float> {
        private float min = Float.NEGATIVE_INFINITY;
        private float max = Float.POSITIVE_INFINITY;

        private Builder(@NonNull String name) {
            super(Float.class, name);
        }

        public @NonNull @This Builder<C> withMin(int min2) {
            this.min = min2;
            return this;
        }

        public @NonNull @This Builder<C> withMax(int max) {
            this.max = max;
            return this;
        }

        @API(status=API.Status.STABLE, since="1.5.0")
        public @NonNull Builder<C> asOptionalWithDefault(float defaultValue) {
            return (Builder)this.asOptionalWithDefault(Float.toString(defaultValue));
        }

        public @NonNull FloatArgument<C> build() {
            return new FloatArgument(this.isRequired(), this.getName(), this.min, this.max, this.getDefaultValue(), this.getSuggestionsProvider(), this.getDefaultDescription());
        }
    }

    @API(status=API.Status.STABLE)
    public static final class FloatParseException
    extends NumberParseException {
        private static final long serialVersionUID = -1162983846751812292L;
        private final FloatParser<?> parser;

        @Deprecated
        @API(status=API.Status.DEPRECATED, since="1.5.0")
        public FloatParseException(@NonNull String input, float min2, float max, @NonNull CommandContext<?> commandContext) {
            this(input, new FloatParser(min2, max), commandContext);
        }

        @API(status=API.Status.STABLE, since="1.5.0")
        public FloatParseException(@NonNull String input, @NonNull FloatParser<?> parser, @NonNull CommandContext<?> commandContext) {
            super(input, Float.valueOf(((FloatParser)parser).min), Float.valueOf(((FloatParser)parser).max), FloatParser.class, commandContext);
            this.parser = parser;
        }

        @Override
        public boolean hasMin() {
            return this.parser.hasMin();
        }

        @Override
        public boolean hasMax() {
            return this.parser.hasMax();
        }

        @Override
        public @NonNull String getNumberType() {
            return "float";
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            FloatParseException that = (FloatParseException)o;
            return this.parser.equals(that.parser);
        }

        public int hashCode() {
            return Objects.hash(this.parser);
        }
    }
}

