/*
 * Decompiled with CFR 0.152.
 */
package ua.valeriishymchuk.simpleitemgenerator.commandframework.brigadier;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import java.util.Objects;
import java.util.function.Function;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import ua.valeriishymchuk.simpleitemgenerator.commandframework.arguments.parser.ArgumentParser;
import ua.valeriishymchuk.simpleitemgenerator.commandframework.brigadier.BrigadierMappingBuilder;
import ua.valeriishymchuk.simpleitemgenerator.commandframework.brigadier.CloudBrigadierManager;

final class BrigadierMapping<C, K extends ArgumentParser<C, ?>, S> {
    private final boolean cloudSuggestions;
    private final @Nullable BrigadierMappingBuilder.SuggestionProviderSupplier<K, S> suggestionsOverride;
    private final @Nullable Function<K, ? extends ArgumentType<?>> mapper;

    BrigadierMapping(boolean cloudSuggestions, @Nullable BrigadierMappingBuilder.SuggestionProviderSupplier<K, S> suggestionsOverride, @Nullable Function<K, ? extends ArgumentType<?>> mapper) {
        this.cloudSuggestions = cloudSuggestions;
        this.suggestionsOverride = suggestionsOverride;
        this.mapper = mapper;
    }

    public @Nullable Function<K, ? extends ArgumentType<?>> getMapper() {
        return this.mapper;
    }

    public @NonNull BrigadierMapping<C, K, S> withNativeSuggestions(boolean nativeSuggestions) {
        if (nativeSuggestions && this.cloudSuggestions) {
            return new BrigadierMapping<C, K, S>(false, this.suggestionsOverride, this.mapper);
        }
        if (!nativeSuggestions && !this.cloudSuggestions) {
            return new BrigadierMapping<C, K, S>(true, this.suggestionsOverride, this.mapper);
        }
        return this;
    }

    public @Nullable SuggestionProvider<S> makeSuggestionProvider(K commandArgument) {
        if (this.cloudSuggestions) {
            return CloudBrigadierManager.delegateSuggestions();
        }
        return this.suggestionsOverride == null ? null : this.suggestionsOverride.provide(commandArgument, CloudBrigadierManager.delegateSuggestions());
    }

    static final class BuilderImpl<C, K extends ArgumentParser<C, ?>, S>
    implements BrigadierMappingBuilder<K, S> {
        private Function<K, ? extends ArgumentType<?>> mapper;
        private boolean cloudSuggestions = false;
        private BrigadierMappingBuilder.SuggestionProviderSupplier<K, S> suggestionsOverride;

        BuilderImpl() {
        }

        @Override
        public BrigadierMappingBuilder<K, S> toConstant(ArgumentType<?> constant) {
            return this.to(parser -> constant);
        }

        @Override
        public BrigadierMappingBuilder<K, S> to(Function<K, ? extends ArgumentType<?>> mapper) {
            this.mapper = mapper;
            return this;
        }

        @Override
        public BrigadierMappingBuilder<K, S> nativeSuggestions() {
            this.cloudSuggestions = false;
            this.suggestionsOverride = null;
            return this;
        }

        @Override
        public BrigadierMappingBuilder<K, S> cloudSuggestions() {
            this.cloudSuggestions = true;
            this.suggestionsOverride = null;
            return this;
        }

        @Override
        public BrigadierMappingBuilder<K, S> suggestedByConstant(SuggestionProvider<S> provider) {
            BrigadierMappingBuilder.super.suggestedByConstant(provider);
            this.cloudSuggestions = false;
            return this;
        }

        @Override
        public BrigadierMappingBuilder<K, S> suggestedBy(BrigadierMappingBuilder.SuggestionProviderSupplier<K, S> provider) {
            this.suggestionsOverride = Objects.requireNonNull(provider, "provider");
            this.cloudSuggestions = false;
            return this;
        }

        public BrigadierMapping<C, K, S> build() {
            return new BrigadierMapping(this.cloudSuggestions, this.suggestionsOverride, this.mapper);
        }
    }
}

