/*
 * Decompiled with CFR 0.152.
 */
package ua.valeriishymchuk.simpleitemgenerator.commandframework.bukkit.parsers.location;

import io.leangen.geantyref.TypeToken;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import org.apiguardian.api.API;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.command.BlockCommandSender;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.util.Vector;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import ua.valeriishymchuk.simpleitemgenerator.commandframework.ArgumentDescription;
import ua.valeriishymchuk.simpleitemgenerator.commandframework.arguments.CommandArgument;
import ua.valeriishymchuk.simpleitemgenerator.commandframework.arguments.parser.ArgumentParseResult;
import ua.valeriishymchuk.simpleitemgenerator.commandframework.arguments.parser.ArgumentParser;
import ua.valeriishymchuk.simpleitemgenerator.commandframework.arguments.standard.IntegerArgument;
import ua.valeriishymchuk.simpleitemgenerator.commandframework.bukkit.BukkitCaptionKeys;
import ua.valeriishymchuk.simpleitemgenerator.commandframework.bukkit.BukkitCommandContextKeys;
import ua.valeriishymchuk.simpleitemgenerator.commandframework.bukkit.parsers.location.LocationCoordinate;
import ua.valeriishymchuk.simpleitemgenerator.commandframework.bukkit.parsers.location.LocationCoordinateParser;
import ua.valeriishymchuk.simpleitemgenerator.commandframework.bukkit.parsers.location.LocationCoordinateType;
import ua.valeriishymchuk.simpleitemgenerator.commandframework.captions.Caption;
import ua.valeriishymchuk.simpleitemgenerator.commandframework.captions.CaptionVariable;
import ua.valeriishymchuk.simpleitemgenerator.commandframework.context.CommandContext;
import ua.valeriishymchuk.simpleitemgenerator.commandframework.exceptions.parsing.ParserException;

public final class LocationArgument<C>
extends CommandArgument<C, Location> {
    private LocationArgument(boolean required, @NonNull String name, @NonNull String defaultValue, @Nullable BiFunction<CommandContext<C>, String, List<String>> suggestionsProvider, @NonNull ArgumentDescription defaultDescription, @NonNull Collection<@NonNull BiFunction<@NonNull CommandContext<C>, @NonNull Queue<@NonNull String>, @NonNull ArgumentParseResult<Boolean>>> argumentPreprocessors) {
        super(required, name, new LocationParser(), defaultValue, TypeToken.get(Location.class), suggestionsProvider, defaultDescription, argumentPreprocessors);
    }

    @API(status=API.Status.STABLE, since="1.8.0")
    public static <C> @NonNull Builder<C> builder(@NonNull String name) {
        return new Builder(name);
    }

    @API(status=API.Status.DEPRECATED, since="1.8.0")
    @Deprecated
    public static <C> @NonNull Builder<C> newBuilder(@NonNull String name) {
        return LocationArgument.builder(name);
    }

    public static <C> @NonNull CommandArgument<C, Location> of(@NonNull String name) {
        return LocationArgument.builder(name).asRequired().build();
    }

    public static <C> @NonNull CommandArgument<C, Location> optional(@NonNull String name) {
        return LocationArgument.builder(name).asOptional().build();
    }

    public static final class LocationParser<C>
    implements ArgumentParser<C, Location> {
        private static final int EXPECTED_PARAMETER_COUNT = 3;
        private final LocationCoordinateParser<C> locationCoordinateParser = new LocationCoordinateParser();

        @Override
        public @NonNull ArgumentParseResult<@NonNull Location> parse(@NonNull CommandContext<@NonNull C> commandContext, @NonNull Queue<@NonNull String> inputQueue) {
            if (inputQueue.size() < 3) {
                StringBuilder input = new StringBuilder();
                for (int i = 0; i < inputQueue.size(); ++i) {
                    input.append((String)((LinkedList)inputQueue).get(i));
                    if (i + 1 >= inputQueue.size()) continue;
                    input.append(" ");
                }
                return ArgumentParseResult.failure(new LocationParseException(commandContext, LocationParseException.FailureReason.WRONG_FORMAT, input.toString()));
            }
            LocationCoordinate[] coordinates = new LocationCoordinate[3];
            for (int i = 0; i < 3; ++i) {
                ArgumentParseResult<@NonNull LocationCoordinate> coordinate = this.locationCoordinateParser.parse(commandContext, inputQueue);
                if (coordinate.getFailure().isPresent()) {
                    return ArgumentParseResult.failure(coordinate.getFailure().get());
                }
                coordinates[i] = coordinate.getParsedValue().orElseThrow(NullPointerException::new);
            }
            CommandSender bukkitSender = commandContext.get(BukkitCommandContextKeys.BUKKIT_COMMAND_SENDER);
            Location originalLocation = bukkitSender instanceof BlockCommandSender ? ((BlockCommandSender)bukkitSender).getBlock().getLocation() : (bukkitSender instanceof Entity ? ((Entity)bukkitSender).getLocation() : new Location((World)Bukkit.getWorlds().get(0), 0.0, 0.0, 0.0));
            if (coordinates[0].getType() == LocationCoordinateType.LOCAL != (coordinates[1].getType() == LocationCoordinateType.LOCAL) || coordinates[0].getType() == LocationCoordinateType.LOCAL != (coordinates[2].getType() == LocationCoordinateType.LOCAL)) {
                return ArgumentParseResult.failure(new LocationParseException(commandContext, LocationParseException.FailureReason.MIXED_LOCAL_ABSOLUTE, ""));
            }
            if (coordinates[0].getType() == LocationCoordinateType.ABSOLUTE) {
                originalLocation.setX(coordinates[0].getCoordinate());
            } else if (coordinates[0].getType() == LocationCoordinateType.RELATIVE) {
                originalLocation.add(coordinates[0].getCoordinate(), 0.0, 0.0);
            }
            if (coordinates[1].getType() == LocationCoordinateType.ABSOLUTE) {
                originalLocation.setY(coordinates[1].getCoordinate());
            } else if (coordinates[1].getType() == LocationCoordinateType.RELATIVE) {
                originalLocation.add(0.0, coordinates[1].getCoordinate(), 0.0);
            }
            if (coordinates[2].getType() == LocationCoordinateType.ABSOLUTE) {
                originalLocation.setZ(coordinates[2].getCoordinate());
            } else if (coordinates[2].getType() == LocationCoordinateType.RELATIVE) {
                originalLocation.add(0.0, 0.0, coordinates[2].getCoordinate());
            } else {
                Vector declaredPos = new Vector(coordinates[0].getCoordinate(), coordinates[1].getCoordinate(), coordinates[2].getCoordinate());
                return ArgumentParseResult.success(LocationParser.toLocalSpace(originalLocation, declaredPos));
            }
            return ArgumentParseResult.success(originalLocation);
        }

        static @NonNull Location toLocalSpace(@NonNull Location originalLocation, @NonNull Vector declaredPos) {
            double cosYaw = Math.cos(LocationParser.toRadians(originalLocation.getYaw() + 90.0f));
            double sinYaw = Math.sin(LocationParser.toRadians(originalLocation.getYaw() + 90.0f));
            double cosPitch = Math.cos(LocationParser.toRadians(-originalLocation.getPitch()));
            double sinPitch = Math.sin(LocationParser.toRadians(-originalLocation.getPitch()));
            double cosNegYaw = Math.cos(LocationParser.toRadians(-originalLocation.getPitch() + 90.0f));
            double sinNegYaw = Math.sin(LocationParser.toRadians(-originalLocation.getPitch() + 90.0f));
            Vector zModifier = new Vector(cosYaw * cosPitch, sinPitch, sinYaw * cosPitch);
            Vector yModifier = new Vector(cosYaw * cosNegYaw, sinNegYaw, sinYaw * cosNegYaw);
            Vector xModifier = zModifier.crossProduct(yModifier).multiply(-1);
            double xOffset = LocationParser.dotProduct(declaredPos, xModifier.getX(), yModifier.getX(), zModifier.getX());
            double yOffset = LocationParser.dotProduct(declaredPos, xModifier.getY(), yModifier.getY(), zModifier.getY());
            double zOffset = LocationParser.dotProduct(declaredPos, xModifier.getZ(), yModifier.getZ(), zModifier.getZ());
            return originalLocation.add(xOffset, yOffset, zOffset);
        }

        private static double dotProduct(Vector location, double x, double y, double z) {
            return location.getX() * x + location.getY() * y + location.getZ() * z;
        }

        private static float toRadians(float degrees2) {
            return degrees2 * (float)Math.PI / 180.0f;
        }

        @Override
        public @NonNull List<@NonNull String> suggestions(@NonNull CommandContext<C> commandContext, @NonNull String input) {
            return LocationParser.getSuggestions(commandContext, input);
        }

        static <C> @NonNull List<@NonNull String> getSuggestions(@NonNull CommandContext<C> commandContext, @NonNull String input) {
            String workingInput;
            String prefix;
            if (input.startsWith("~") || input.startsWith("^")) {
                prefix = Character.toString(input.charAt(0));
                workingInput = input.substring(1);
            } else {
                prefix = "";
                workingInput = input;
            }
            return IntegerArgument.IntegerParser.getSuggestions(Integer.MIN_VALUE, Integer.MAX_VALUE, workingInput).stream().map((? super T string) -> prefix + string).collect(Collectors.toList());
        }

        @Override
        public int getRequestedArgumentCount() {
            return 3;
        }
    }

    public static final class Builder<C>
    extends CommandArgument.Builder<C, Location> {
        private Builder(@NonNull String name) {
            super(TypeToken.get(Location.class), name);
        }

        @Override
        public @NonNull CommandArgument<@NonNull C, @NonNull Location> build() {
            return new LocationArgument(this.isRequired(), this.getName(), this.getDefaultValue(), this.getSuggestionsProvider(), this.getDefaultDescription(), new LinkedList());
        }
    }

    static class LocationParseException
    extends ParserException {
        private static final long serialVersionUID = -3261835227265878218L;

        protected LocationParseException(@NonNull CommandContext<?> context, @NonNull FailureReason reason, @NonNull String input) {
            super(LocationParser.class, context, reason.getCaption(), CaptionVariable.of("input", input));
        }

        public static enum FailureReason {
            WRONG_FORMAT(BukkitCaptionKeys.ARGUMENT_PARSE_FAILURE_LOCATION_INVALID_FORMAT),
            MIXED_LOCAL_ABSOLUTE(BukkitCaptionKeys.ARGUMENT_PARSE_FAILURE_LOCATION_MIXED_LOCAL_ABSOLUTE);

            private final Caption caption;

            private FailureReason(Caption caption) {
                this.caption = caption;
            }

            public @NonNull Caption getCaption() {
                return this.caption;
            }
        }
    }
}

