/*
 * Decompiled with CFR 0.152.
 */
package ua.valeriishymchuk.simpleitemgenerator.commandframework.exceptions;

import java.util.List;
import org.apiguardian.api.API;
import org.checkerframework.checker.nullness.qual.NonNull;
import ua.valeriishymchuk.simpleitemgenerator.commandframework.arguments.CommandArgument;
import ua.valeriishymchuk.simpleitemgenerator.commandframework.exceptions.CommandParseException;
import ua.valeriishymchuk.simpleitemgenerator.commandframework.permission.CommandPermission;

@API(status=API.Status.STABLE)
public class NoPermissionException
extends CommandParseException {
    private static final long serialVersionUID = 7103413337750692843L;
    private final CommandPermission missingPermission;

    @API(status=API.Status.INTERNAL, consumers={"ua.valeriishymchuk.simpleitemgenerator.commandframework.*"})
    public NoPermissionException(@NonNull CommandPermission missingPermission, @NonNull Object commandSender, @NonNull List<@NonNull CommandArgument<?, ?>> currentChain) {
        super(commandSender, currentChain);
        this.missingPermission = missingPermission;
    }

    @Override
    public final String getMessage() {
        return String.format("Missing permission '%s'", this.missingPermission);
    }

    public @NonNull String getMissingPermission() {
        return this.missingPermission.toString();
    }

    @Override
    public final synchronized Throwable fillInStackTrace() {
        return this;
    }

    @Override
    public final synchronized Throwable initCause(Throwable cause) {
        return this;
    }
}

