/*
 * Decompiled with CFR 0.152.
 */
package ua.valeriishymchuk.simpleitemgenerator.commandframework.exceptions.parsing;

import java.util.Arrays;
import org.apiguardian.api.API;
import org.checkerframework.checker.nullness.qual.NonNull;
import ua.valeriishymchuk.simpleitemgenerator.commandframework.captions.Caption;
import ua.valeriishymchuk.simpleitemgenerator.commandframework.captions.CaptionVariable;
import ua.valeriishymchuk.simpleitemgenerator.commandframework.context.CommandContext;

@API(status=API.Status.STABLE)
public class ParserException
extends IllegalArgumentException {
    private static final long serialVersionUID = -4409795575435072170L;
    private final Class<?> argumentParser;
    private final CommandContext<?> context;
    private final Caption errorCaption;
    private final CaptionVariable[] captionVariables;

    protected ParserException(@NonNull Class<?> argumentParser, @NonNull CommandContext<?> context, @NonNull Caption errorCaption, CaptionVariable ... captionVariables) {
        this.argumentParser = argumentParser;
        this.context = context;
        this.errorCaption = errorCaption;
        this.captionVariables = captionVariables;
    }

    @Override
    public final String getMessage() {
        return this.context.formatMessage(this.errorCaption, this.captionVariables);
    }

    @API(status=API.Status.STABLE, since="1.4.0")
    public @NonNull Caption errorCaption() {
        return this.errorCaption;
    }

    @API(status=API.Status.STABLE, since="1.4.0")
    public @NonNull CaptionVariable @NonNull [] captionVariables() {
        return Arrays.copyOf(this.captionVariables, this.captionVariables.length);
    }

    public final @NonNull Class<?> getArgumentParserClass() {
        return this.argumentParser;
    }

    public final @NonNull CommandContext<?> getContext() {
        return this.context;
    }
}

