/*
 * Decompiled with CFR 0.152.
 */
package ua.valeriishymchuk.simpleitemgenerator.commandframework.minecraft.extras;

import io.leangen.geantyref.TypeToken;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.regex.Pattern;
import org.checkerframework.checker.nullness.qual.NonNull;
import ua.valeriishymchuk.simpleitemgenerator.commandframework.arguments.CommandArgument;
import ua.valeriishymchuk.simpleitemgenerator.commandframework.arguments.parser.ArgumentParseResult;
import ua.valeriishymchuk.simpleitemgenerator.commandframework.arguments.parser.ArgumentParser;
import ua.valeriishymchuk.simpleitemgenerator.commandframework.captions.CaptionVariable;
import ua.valeriishymchuk.simpleitemgenerator.commandframework.captions.StandardCaptionKeys;
import ua.valeriishymchuk.simpleitemgenerator.commandframework.context.CommandContext;
import ua.valeriishymchuk.simpleitemgenerator.commandframework.exceptions.parsing.NoInputProvidedException;
import ua.valeriishymchuk.simpleitemgenerator.commandframework.exceptions.parsing.ParserException;
import ua.valeriishymchuk.simpleitemgenerator.commandframework.types.tuples.Pair;
import ua.valeriishymchuk.simpleitemgenerator.kyori.adventure.text.format.NamedTextColor;
import ua.valeriishymchuk.simpleitemgenerator.kyori.adventure.text.format.TextColor;

public final class TextColorArgument<C>
extends CommandArgument<C, TextColor> {
    private static final Pattern LEGACY_PREDICATE = Pattern.compile("&[0-9a-fA-F]");
    private static final Pattern HEX_PREDICATE = Pattern.compile("#?([a-fA-F0-9]{1,6})");
    private static final Collection<Pair<Character, NamedTextColor>> COLORS = Arrays.asList(Pair.of(Character.valueOf('0'), NamedTextColor.BLACK), Pair.of(Character.valueOf('1'), NamedTextColor.DARK_BLUE), Pair.of(Character.valueOf('2'), NamedTextColor.DARK_GREEN), Pair.of(Character.valueOf('3'), NamedTextColor.DARK_AQUA), Pair.of(Character.valueOf('4'), NamedTextColor.DARK_RED), Pair.of(Character.valueOf('5'), NamedTextColor.DARK_PURPLE), Pair.of(Character.valueOf('6'), NamedTextColor.GOLD), Pair.of(Character.valueOf('7'), NamedTextColor.GRAY), Pair.of(Character.valueOf('8'), NamedTextColor.DARK_GRAY), Pair.of(Character.valueOf('9'), NamedTextColor.BLUE), Pair.of(Character.valueOf('a'), NamedTextColor.GREEN), Pair.of(Character.valueOf('b'), NamedTextColor.AQUA), Pair.of(Character.valueOf('c'), NamedTextColor.RED), Pair.of(Character.valueOf('d'), NamedTextColor.LIGHT_PURPLE), Pair.of(Character.valueOf('e'), NamedTextColor.YELLOW), Pair.of(Character.valueOf('f'), NamedTextColor.WHITE));

    private TextColorArgument(boolean required, @NonNull String name, @NonNull String defaultValue) {
        super(required, name, new TextColorParser(), defaultValue, TypeToken.get(TextColor.class), null, new LinkedList());
    }

    public static <C> @NonNull TextColorArgument<C> of(@NonNull String name) {
        return new TextColorArgument<C>(true, name, "");
    }

    public static <C> @NonNull TextColorArgument<C> optional(@NonNull String name) {
        return new TextColorArgument<C>(false, name, "");
    }

    public static <C> @NonNull TextColorArgument<C> optionalWithDefault(@NonNull String name, @NonNull String defaultValue) {
        return new TextColorArgument<C>(false, name, defaultValue);
    }

    public static final class TextColorParser<C>
    implements ArgumentParser<C, TextColor> {
        @Override
        public @NonNull ArgumentParseResult<@NonNull TextColor> parse(@NonNull CommandContext<@NonNull C> commandContext, @NonNull Queue<@NonNull String> inputQueue) {
            String input = inputQueue.peek();
            if (input == null) {
                return ArgumentParseResult.failure(new NoInputProvidedException(TextColorParser.class, commandContext));
            }
            if (LEGACY_PREDICATE.matcher(input).matches()) {
                char code = input.substring(1).toLowerCase().charAt(0);
                for (Pair pair : COLORS) {
                    if (((Character)pair.getFirst()).charValue() != code) continue;
                    inputQueue.remove();
                    return ArgumentParseResult.success((TextColor)pair.getSecond());
                }
            }
            for (Pair pair : COLORS) {
                if (!((NamedTextColor)pair.getSecond()).toString().equalsIgnoreCase(input)) continue;
                inputQueue.remove();
                return ArgumentParseResult.success((TextColor)pair.getSecond());
            }
            if (HEX_PREDICATE.matcher(input).matches()) {
                inputQueue.remove();
                return ArgumentParseResult.success(TextColor.color(Integer.parseInt(input.startsWith("#") ? input.substring(1) : input, 16)));
            }
            return ArgumentParseResult.failure(new TextColorParseException(commandContext, input));
        }

        @Override
        public @NonNull List<@NonNull String> suggestions(@NonNull CommandContext<C> commandContext, @NonNull String input) {
            LinkedList<String> suggestions = new LinkedList<String>();
            if (input.isEmpty() || input.equals("#") || HEX_PREDICATE.matcher(input).matches() && input.length() < (input.startsWith("#") ? 7 : 6)) {
                char c;
                for (c = 'a'; c <= 'f'; c = (char)(c + '\u0001')) {
                    suggestions.add(String.format("%s%c", input, Character.valueOf(c)));
                    suggestions.add(String.format("&%c", Character.valueOf(c)));
                }
                for (c = '0'; c <= '9'; c = (char)(c + '\u0001')) {
                    suggestions.add(String.format("%s%c", input, Character.valueOf(c)));
                    suggestions.add(String.format("&%c", Character.valueOf(c)));
                }
            }
            suggestions.addAll(NamedTextColor.NAMES.keys());
            return suggestions;
        }
    }

    private static final class TextColorParseException
    extends ParserException {
        private static final long serialVersionUID = -6236625328843879518L;

        private TextColorParseException(@NonNull CommandContext<?> commandContext, @NonNull String input) {
            super(TextColorParser.class, commandContext, StandardCaptionKeys.ARGUMENT_PARSE_FAILURE_COLOR, CaptionVariable.of("input", input));
        }
    }
}

