/*
 * Decompiled with CFR 0.152.
 */
package ua.valeriishymchuk.simpleitemgenerator.commandframework.permission;

import java.util.function.Predicate;
import org.apiguardian.api.API;
import org.checkerframework.checker.nullness.qual.NonNull;
import ua.valeriishymchuk.simpleitemgenerator.commandframework.keys.CloudKey;
import ua.valeriishymchuk.simpleitemgenerator.commandframework.permission.PredicatePermission;

@API(status=API.Status.INTERNAL, consumers={"ua.valeriishymchuk.simpleitemgenerator.commandframework.*"})
final class WrappingPredicatePermission<C>
implements PredicatePermission<C> {
    private final CloudKey<Void> key;
    private final Predicate<C> predicate;

    WrappingPredicatePermission(@NonNull CloudKey<Void> key, @NonNull Predicate<C> predicate) {
        this.key = key;
        this.predicate = predicate;
    }

    @Override
    public boolean hasPermission(C sender) {
        return this.predicate.test(sender);
    }

    @Override
    public @NonNull CloudKey<Void> getKey() {
        return this.key;
    }

    @Override
    public String toString() {
        return this.key.getName();
    }
}

