/*
 * Decompiled with CFR 0.152.
 */
package ua.valeriishymchuk.simpleitemgenerator.common.component;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import ua.valeriishymchuk.simpleitemgenerator.kyori.adventure.text.Component;
import ua.valeriishymchuk.simpleitemgenerator.kyori.adventure.text.minimessage.MiniMessage;
import ua.valeriishymchuk.simpleitemgenerator.spongepowered.configurate.objectmapping.ConfigSerializable;
import ua.valeriishymchuk.simpleitemgenerator.spongepowered.configurate.objectmapping.meta.Setting;

@ConfigSerializable
public class RawComponent {
    @Setting(nodeFromParent=true)
    private List<String> raw;

    public RawComponent(List<String> raw) {
        this.raw = raw;
    }

    public RawComponent(String ... raw) {
        this(Arrays.asList(raw));
    }

    private RawComponent() {
        this(Collections.emptyList());
    }

    public Component bake() {
        Component message = Component.empty();
        for (int i = 0; i < this.raw.size(); ++i) {
            String line = this.raw.get(i);
            message = message.append(Component.text(line));
            if (i + 1 >= this.raw.size()) continue;
            message = message.append(Component.newline());
        }
        return message;
    }

    public List<Component> bakeAsLore() {
        return this.raw.stream().map(MiniMessage.miniMessage()::deserialize).collect(Collectors.toList());
    }

    public RawComponent replaceText(String placeholder, String text) {
        return new RawComponent(this.raw.stream().map(s2 -> s2.replace(placeholder, text)).collect(Collectors.toList()));
    }

    public RawComponent replaceText(String placeholder, Component text) {
        return this.replaceText(placeholder, (String)MiniMessage.miniMessage().serialize(text));
    }

    public RawComponent replaceText(String placeholder, RawComponent text) {
        return this.replaceText(placeholder, text.bake());
    }

    public RawComponent replaceText(String placeholder, Object obj) {
        return this.replaceText(placeholder, obj.toString());
    }

    @Generated
    public List<String> getRaw() {
        return this.raw;
    }
}

