/*
 * Decompiled with CFR 0.152.
 */
package ua.valeriishymchuk.simpleitemgenerator.common.config;

import io.vavr.control.Option;
import java.io.File;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;
import lombok.Generated;
import ua.valeriishymchuk.simpleitemgenerator.common.config.IConfigLoaderConfigurator;
import ua.valeriishymchuk.simpleitemgenerator.spongepowered.configurate.ConfigurationNode;
import ua.valeriishymchuk.simpleitemgenerator.spongepowered.configurate.loader.ConfigurationLoader;
import ua.valeriishymchuk.simpleitemgenerator.spongepowered.configurate.objectmapping.ConfigSerializable;

public class ConfigLoader {
    private final File folder;
    private final String extension;
    private final IConfigLoaderConfigurator configurator;

    public <T, C> T applyContext(Class<C> clazz, String key, Function<ContextLoader<C>, T> mapper) {
        this.validateConfigClass(clazz);
        return mapper.apply(new ContextLoader<C>(clazz, key));
    }

    public <C> C loadOrSave(Class<C> clazz, String key, C defaultConfig) {
        return (C)this.applyContext(clazz, key, c -> c.load().getOrElse(() -> {
            c.save(defaultConfig);
            return defaultConfig;
        }));
    }

    public <C> C loadOrSave(Class<C> clazz, String key) {
        this.validateConfigClass(clazz);
        return this.loadOrSave(clazz, key, this.emptyConstructor(clazz).get());
    }

    public <C> Option<C> load(Class<C> clazz, String key) {
        this.validateConfigClass(clazz);
        File file = this.getFile(key);
        if (!file.exists()) {
            return Option.none();
        }
        ConfigurationLoader<?> loader = this.configurator.configure(file);
        Object rootNode = loader.load();
        return Option.of(rootNode.get(clazz));
    }

    public <C> C loadOrDefault(Class<C> clazz, String key, C defaultConfig) {
        return this.load(clazz, key).getOrElse(defaultConfig);
    }

    public <C> C loadOrDefault(Class<C> clazz, String key) {
        this.validateConfigClass(clazz);
        return this.loadOrDefault(clazz, key, this.emptyConstructor(clazz).get());
    }

    public <C> void save(Class<C> clazz, String key, C config) {
        this.validateConfigClass(clazz);
        File file = this.getFile(key);
        ConfigurationLoader<?> loader = this.configurator.configure(file);
        Object rootNode = loader.load();
        rootNode.set(clazz, config);
        loader.save((ConfigurationNode)rootNode);
    }

    public <C> void saveDefault(Class<C> clazz, String key) {
        this.validateConfigClass(clazz);
        this.save(clazz, key, this.emptyConstructor(clazz).get());
    }

    private <C> Supplier<C> emptyConstructor(Class<C> clazz) {
        Constructor constructor = Stream.of(clazz.getConstructors(), clazz.getDeclaredConstructors()).flatMap(Arrays::stream).filter(c -> c.getParameterCount() == 0).peek(c -> c.setAccessible(true)).findFirst().get();
        return () -> {
            try {
                return constructor.newInstance(new Object[0]);
            }
            catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        };
    }

    private File getFile(String key) {
        return new File(this.folder, key + this.extension);
    }

    private void validateConfigClass(Class<?> clazz) {
        this.validateAnnotation(clazz);
        this.validateEmptyConstructor(clazz);
    }

    private void validateAnnotation(Class<?> clazz) {
        this.validate(Arrays.stream(clazz.getAnnotations()).anyMatch(a -> a instanceof ConfigSerializable), "Your %s class doesn't have a %s annotation", clazz.getName(), ConfigSerializable.class.getName());
    }

    private void validateEmptyConstructor(Class<?> clazz) {
        this.validate(Stream.of(clazz.getConstructors(), clazz.getDeclaredConstructors()).flatMap(Arrays::stream).anyMatch(c -> c.getParameterCount() == 0), "Your %s class doesn't have an empty constructor", clazz.getName());
    }

    private void validate(Boolean validationCondition, String errorMessage, Object ... args) {
        if (validationCondition.booleanValue()) {
            return;
        }
        throw new IllegalStateException(String.format(errorMessage, args));
    }

    @Generated
    public ConfigLoader(File folder, String extension, IConfigLoaderConfigurator configurator) {
        this.folder = folder;
        this.extension = extension;
        this.configurator = configurator;
    }

    public class ContextLoader<C> {
        private final Class<C> clazz;
        private final String key;

        public Option<C> load() {
            return ConfigLoader.this.load(this.clazz, this.key);
        }

        public C loadOrDefault(C defaultConfig) {
            return ConfigLoader.this.loadOrDefault(this.clazz, this.key, defaultConfig);
        }

        public C loadOrDefault() {
            return ConfigLoader.this.loadOrDefault(this.clazz, this.key);
        }

        public void save(C config) {
            ConfigLoader.this.save(this.clazz, this.key, config);
        }

        public void saveDefault() {
            ConfigLoader.this.saveDefault(this.clazz, this.key);
        }

        @Generated
        public ContextLoader(Class<C> clazz, String key) {
            this.clazz = clazz;
            this.key = key;
        }
    }
}

