/*
 * Decompiled with CFR 0.152.
 */
package ua.valeriishymchuk.simpleitemgenerator.common.item;

import io.vavr.control.Option;
import lombok.Generated;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.Nullable;
import ua.valeriishymchuk.simpleitemgenerator.kyori.adventure.key.Key;
import ua.valeriishymchuk.simpleitemgenerator.nbtapi.NBT;
import ua.valeriishymchuk.simpleitemgenerator.nbtapi.iface.ReadWriteNBT;
import ua.valeriishymchuk.simpleitemgenerator.nbtapi.iface.ReadableNBT;

public class NBTCustomItem {
    private static final Key CUSTOM_ITEM_ID_KEY = Key.key("simpleitemgenerator:custom_item_id");
    private static final Key CUSTOM_ITEM_COOLDOWN_KEY = Key.key("simpleitemgenerator:custom_item_cooldown");
    private static final Key CUSTOM_ITEM_COOLDOWN_FREEZETIME_KEY = Key.key("simpleitemgenerator:custom_item_freezetime");
    private static final String PUBLIC_BUKKIT_VALUES = "PublicBukkitValues";

    public static Option<String> getCustomItemId(ItemStack item) {
        return NBT.get(item, nbt -> NBTCustomItem.getBukkitValues(nbt).map(bukkitValues -> bukkitValues.getString(CUSTOM_ITEM_ID_KEY.asString())).flatMap(Option::of));
    }

    public static boolean hasCustomItemId(ItemStack item) {
        return NBTCustomItem.getCustomItemId(item).isDefined();
    }

    public static void setCustomItemId(ItemStack item, String customItemId) {
        NBT.modify(item, nbt -> nbt.getOrCreateCompound(PUBLIC_BUKKIT_VALUES).setString(CUSTOM_ITEM_ID_KEY.asString(), customItemId));
    }

    public static Cooldown getCooldown(ItemStack itemStack, int cooldownId) {
        return NBT.get(itemStack, nbt -> {
            Long cooldown = (Long)NBTCustomItem.getBukkitValues(nbt).map(bukkitValues -> bukkitValues.getLong(CUSTOM_ITEM_COOLDOWN_KEY.asString() + cooldownId)).getOrNull();
            Long freezetime = (Long)NBTCustomItem.getBukkitValues(nbt).map(bukkitValues -> bukkitValues.getLong(CUSTOM_ITEM_COOLDOWN_FREEZETIME_KEY.asString() + cooldownId)).getOrNull();
            if (cooldown == null || cooldown < System.currentTimeMillis()) {
                return CooldownType.NONE.toCooldown(0L);
            }
            if (freezetime == null || freezetime < System.currentTimeMillis()) {
                return CooldownType.DEFAULT.toCooldown(cooldown);
            }
            return CooldownType.FROZEN.toCooldown(freezetime);
        });
    }

    public static Cooldown queryCooldown(ItemStack itemStack, long cooldownMillis, long freezetimeMillis, int cooldownId) {
        Cooldown cooldown = NBTCustomItem.getCooldown(itemStack, cooldownId);
        if (cooldown.isFrozen()) {
            return cooldown;
        }
        if (cooldown.isAbsent()) {
            NBTCustomItem.updateCooldown(itemStack, System.currentTimeMillis() + cooldownMillis, cooldownId);
            NBTCustomItem.updateFreezetime(itemStack, System.currentTimeMillis() + freezetimeMillis, cooldownId);
            return CooldownType.NONE.toCooldown(0L);
        }
        NBTCustomItem.updateFreezetime(itemStack, System.currentTimeMillis() + freezetimeMillis, cooldownId);
        return cooldown;
    }

    public static void updateCooldown(ItemStack itemStack, @Nullable Long cooldown, int cooldownId) {
        NBT.modify(itemStack, nbt -> {
            ReadWriteNBT bukkitValues = nbt.getOrCreateCompound(PUBLIC_BUKKIT_VALUES);
            bukkitValues.setLong(CUSTOM_ITEM_COOLDOWN_KEY.asString() + cooldownId, cooldown);
        });
    }

    public static void updateFreezetime(ItemStack itemStack, @Nullable Long freezetime, int cooldownId) {
        NBT.modify(itemStack, nbt -> {
            ReadWriteNBT bukkitValues = nbt.getOrCreateCompound(PUBLIC_BUKKIT_VALUES);
            bukkitValues.setLong(CUSTOM_ITEM_COOLDOWN_FREEZETIME_KEY.asString() + cooldownId, freezetime);
        });
    }

    private static Option<ReadableNBT> getBukkitValues(ReadableNBT item) {
        return Option.of(item.getCompound(PUBLIC_BUKKIT_VALUES));
    }

    public static enum CooldownType {
        NONE,
        DEFAULT,
        FROZEN;


        public Cooldown toCooldown(long epoch) {
            return new Cooldown(this, epoch - System.currentTimeMillis());
        }
    }

    public static class Cooldown {
        private final CooldownType type;
        private final long remainingMillis;

        public boolean isFrozen() {
            return this.type == CooldownType.FROZEN;
        }

        public boolean isDefault() {
            return this.type == CooldownType.DEFAULT;
        }

        public boolean isAbsent() {
            return this.type == CooldownType.NONE;
        }

        @Generated
        public Cooldown(CooldownType type, long remainingMillis) {
            this.type = type;
            this.remainingMillis = remainingMillis;
        }

        @Generated
        public CooldownType getType() {
            return this.type;
        }

        @Generated
        public long getRemainingMillis() {
            return this.remainingMillis;
        }
    }
}

