/*
 * Decompiled with CFR 0.152.
 */
package ua.valeriishymchuk.simpleitemgenerator.common.item;

import io.vavr.control.Option;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import org.bukkit.Material;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.jetbrains.annotations.Nullable;
import ua.valeriishymchuk.simpleitemgenerator.common.message.KyoriHelper;
import ua.valeriishymchuk.simpleitemgenerator.common.reflection.ReflectedRepresentations;
import ua.valeriishymchuk.simpleitemgenerator.spongepowered.configurate.objectmapping.ConfigSerializable;

@ConfigSerializable
public class RawItem
implements Cloneable {
    public static final RawItem EMPTY = new RawItem();
    private final String material;
    @Nullable
    private final String name;
    private final List<String> lore;
    @Nullable
    private final Integer cmd;
    private final List<ItemFlag> itemFlags;
    private final Map<String, Integer> enchantments;

    public RawItem clone() {
        return this.withName(this.name);
    }

    public RawItem replace(String placeholder, String value) {
        return this.withName((String)Option.of(this.name).map(s2 -> s2.replace(placeholder, value)).getOrNull()).withLore(this.lore.stream().map(s2 -> s2.replace(placeholder, value)).collect(Collectors.toList()));
    }

    private RawItem() {
        this("DIAMOND", null, Collections.emptyList(), null, Collections.emptyList(), Collections.emptyMap());
    }

    public ItemStack bake() {
        ItemStack item = new ItemStack(Material.valueOf((String)this.material));
        ItemMeta meta = item.getItemMeta();
        if (this.name != null) {
            ReflectedRepresentations.ItemMeta.setDisplayName(meta, KyoriHelper.parseMiniMessage(this.name));
        }
        if (!this.lore.isEmpty()) {
            ReflectedRepresentations.ItemMeta.setLore(meta, this.lore.stream().map(KyoriHelper::parseMiniMessage).collect(Collectors.toList()));
        }
        if (this.cmd != null) {
            this.setCustomModelData(meta, this.cmd);
        }
        if (!this.itemFlags.isEmpty()) {
            meta.addItemFlags(this.itemFlags.toArray(new ItemFlag[0]));
        }
        if (!this.enchantments.isEmpty()) {
            this.enchantments.forEach((k, v) -> meta.addEnchant(this.findEnchantment((String)k), v.intValue(), true));
        }
        item.setItemMeta(meta);
        return item;
    }

    private Enchantment findEnchantment(String name) {
        return ReflectedRepresentations.Enchantment.tryGetByKey(name).getOrElse(() -> Enchantment.getByName((String)name));
    }

    private void setCustomModelData(ItemMeta itemMeta, int cmd) {
        ReflectedRepresentations.ItemMeta.setCustomModelData(itemMeta, cmd);
    }

    @Generated
    public RawItem(String material, @Nullable String name, List<String> lore, @Nullable Integer cmd, List<ItemFlag> itemFlags, Map<String, Integer> enchantments) {
        this.material = material;
        this.name = name;
        this.lore = lore;
        this.cmd = cmd;
        this.itemFlags = itemFlags;
        this.enchantments = enchantments;
    }

    @Generated
    public RawItem withMaterial(String material) {
        return this.material == material ? this : new RawItem(material, this.name, this.lore, this.cmd, this.itemFlags, this.enchantments);
    }

    @Generated
    public RawItem withName(@Nullable String name) {
        return this.name == name ? this : new RawItem(this.material, name, this.lore, this.cmd, this.itemFlags, this.enchantments);
    }

    @Generated
    public RawItem withLore(List<String> lore) {
        return this.lore == lore ? this : new RawItem(this.material, this.name, lore, this.cmd, this.itemFlags, this.enchantments);
    }

    @Generated
    public RawItem withCmd(@Nullable Integer cmd) {
        return this.cmd == cmd ? this : new RawItem(this.material, this.name, this.lore, cmd, this.itemFlags, this.enchantments);
    }

    @Generated
    public RawItem withItemFlags(List<ItemFlag> itemFlags) {
        return this.itemFlags == itemFlags ? this : new RawItem(this.material, this.name, this.lore, this.cmd, itemFlags, this.enchantments);
    }

    @Generated
    public RawItem withEnchantments(Map<String, Integer> enchantments) {
        return this.enchantments == enchantments ? this : new RawItem(this.material, this.name, this.lore, this.cmd, this.itemFlags, enchantments);
    }
}

