/*
 * Decompiled with CFR 0.152.
 */
package ua.valeriishymchuk.simpleitemgenerator.common.message;

import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.chat.ComponentSerializer;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.entity.Player;
import ua.valeriishymchuk.simpleitemgenerator.common.reflection.ReflectedRepresentations;
import ua.valeriishymchuk.simpleitemgenerator.kyori.adventure.text.Component;
import ua.valeriishymchuk.simpleitemgenerator.kyori.adventure.text.format.TextDecoration;
import ua.valeriishymchuk.simpleitemgenerator.kyori.adventure.text.minimessage.MiniMessage;
import ua.valeriishymchuk.simpleitemgenerator.kyori.adventure.text.serializer.gson.GsonComponentSerializer;
import ua.valeriishymchuk.simpleitemgenerator.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;

public class KyoriHelper {
    public static void sendMessage(CommandSender sender, Component message) {
        if (sender instanceof Player) {
            Player player = (Player)sender;
            player.spigot().sendMessage(KyoriHelper.convert(message));
        } else if (sender instanceof ConsoleCommandSender) {
            ReflectedRepresentations.ConsoleCommandSender.sendComponentMessage((ConsoleCommandSender)sender, message);
        } else {
            sender.sendMessage(KyoriHelper.toLegacy(message));
        }
    }

    public static BaseComponent[] convert(Component component) {
        return ComponentSerializer.parse((String)((String)GsonComponentSerializer.gson().serialize(component)));
    }

    public static String mimiMessageToJson(String miniMessage) {
        return KyoriHelper.toJson(KyoriHelper.parseMiniMessage(miniMessage));
    }

    public static Component parseMiniMessage(String miniMessage) {
        Object component = MiniMessage.miniMessage().deserialize(miniMessage);
        if (component.decoration(TextDecoration.ITALIC) == TextDecoration.State.NOT_SET) {
            return component.decoration(TextDecoration.ITALIC, TextDecoration.State.FALSE);
        }
        return component;
    }

    public static String toJson(Component component) {
        return (String)GsonComponentSerializer.gson().serialize(component);
    }

    public static String toLegacy(Component component) {
        return LegacyComponentSerializer.legacySection().serialize(component);
    }

    public static Component fromLegacy(String legacy) {
        return LegacyComponentSerializer.legacySection().deserialize(legacy);
    }

    public static Component fromJson(String json) {
        return GsonComponentSerializer.gson().deserialize(json);
    }

    public static String serializeMiniMessage(Component component) {
        return (String)MiniMessage.miniMessage().serialize(component);
    }

    public static String jsonToMiniMessage(String message) {
        return KyoriHelper.serializeMiniMessage(KyoriHelper.fromJson(message));
    }
}

