/*
 * Decompiled with CFR 0.152.
 */
package ua.valeriishymchuk.simpleitemgenerator.common.reflection;

import io.vavr.CheckedFunction0;
import java.util.Arrays;
import org.bukkit.Bukkit;
import ua.valeriishymchuk.simpleitemgenerator.common.message.KyoriHelper;
import ua.valeriishymchuk.simpleitemgenerator.common.reflection.ReflectionObject;
import ua.valeriishymchuk.simpleitemgenerator.kyori.adventure.text.Component;

public class MinecraftReflection {
    private static final String craftBukkit = CheckedFunction0.of(() -> {
        String[] split = Bukkit.getServer().getClass().getName().split("\\.");
        return String.join((CharSequence)".", Arrays.copyOf(split, split.length - 1));
    }).unchecked().apply();
    private static final Class<?> CRAFT_CHAT_MESSAGE = MinecraftReflection.getCraftBukkit("util.CraftChatMessage");

    public static Class<?> getCraftBukkit(String className) {
        return Class.forName(craftBukkit + "." + className);
    }

    public static ReflectionObject toMinecraftComponent(Component component) {
        ReflectionObject craftChatMessage = ReflectionObject.ofStatic(CRAFT_CHAT_MESSAGE);
        return craftChatMessage.invokePublic("fromJSON", KyoriHelper.toJson(component)).get();
    }

    public static Component fromMinecraftComponent(ReflectionObject component) {
        ReflectionObject craftChatMessage = ReflectionObject.ofStatic(CRAFT_CHAT_MESSAGE);
        String json = (String)craftChatMessage.invokePublic("toJSON", component).map(ReflectionObject::getObject).map(o -> (String)o).get();
        return KyoriHelper.fromJson(json);
    }
}

