/*
 * Decompiled with CFR 0.152.
 */
package ua.valeriishymchuk.simpleitemgenerator.common.reflection;

import io.vavr.CheckedFunction1;
import io.vavr.control.Option;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import net.md_5.bungee.api.chat.BaseComponent;
import ua.valeriishymchuk.simpleitemgenerator.common.message.KyoriHelper;
import ua.valeriishymchuk.simpleitemgenerator.common.reflection.MinecraftReflection;
import ua.valeriishymchuk.simpleitemgenerator.common.reflection.ReflectionObject;
import ua.valeriishymchuk.simpleitemgenerator.common.version.FeatureSupport;
import ua.valeriishymchuk.simpleitemgenerator.common.version.MinecraftVersion;
import ua.valeriishymchuk.simpleitemgenerator.kyori.adventure.key.Key;
import ua.valeriishymchuk.simpleitemgenerator.kyori.adventure.text.Component;

public class ReflectedRepresentations {

    public static class Enchantment {
        public static final Class<org.bukkit.enchantments.Enchantment> CLASS = org.bukkit.enchantments.Enchantment.class;

        public static org.bukkit.enchantments.Enchantment getByKey(Key key) {
            return Enchantment.getByKey(key.asString());
        }

        public static Option<org.bukkit.enchantments.Enchantment> tryGetByKey(Key key) {
            return Enchantment.tryGetByKey(key.asString());
        }

        public static Option<org.bukkit.enchantments.Enchantment> tryGetByKey(String key) {
            if (!FeatureSupport.NAMESPACED_ENCHANTMENTS_SUPPORT) {
                return Option.none();
            }
            return Option.of(Enchantment.getByKey(key));
        }

        public static org.bukkit.enchantments.Enchantment getByKey(String key) {
            Enchantment.ensureNamespacedEnchantmentsSupport();
            return (org.bukkit.enchantments.Enchantment)ReflectionObject.ofStatic(org.bukkit.enchantments.Enchantment.class).invokePublic("getByKey", NamespacedKey.from(key)).map(ReflectionObject::cast).getOrElseThrow(() -> new IllegalArgumentException("Unknown enchantment: " + key));
        }

        public static ReflectionObject getNamespacedKey(org.bukkit.enchantments.Enchantment enchantment) {
            Enchantment.ensureNamespacedEnchantmentsSupport();
            return new ReflectionObject(CLASS, enchantment).invokePublic("getKey", new ReflectionObject[0]).get();
        }

        public static Key getKyoriKey(org.bukkit.enchantments.Enchantment enchantment) {
            Enchantment.ensureNamespacedEnchantmentsSupport();
            return NamespacedKey.getKyoriKey(Enchantment.getNamespacedKey(enchantment));
        }

        private static void ensureNamespacedEnchantmentsSupport() {
            if (!FeatureSupport.NAMESPACED_ENCHANTMENTS_SUPPORT) {
                throw new IllegalStateException("Namespaced enchantments is supported from >=1.13. Current version " + MinecraftVersion.CURRENT);
            }
        }
    }

    public static class ItemMeta {
        public static final Class<org.bukkit.inventory.meta.ItemMeta> CLASS = org.bukkit.inventory.meta.ItemMeta.class;
        public static final Class<?> CRAFT_META = MinecraftReflection.getCraftBukkit("inventory.CraftMetaItem");
        public static final Field DISPLAY_NAME_FIELD;
        public static final Field LORE_FIELD;

        public static boolean isDisplayNameString() {
            return DISPLAY_NAME_FIELD.getType() == String.class;
        }

        public static void setDisplayName(org.bukkit.inventory.meta.ItemMeta meta, Component displayName) {
            if (!FeatureSupport.TEXT_COMPONENTS_IN_ITEMS_SUPPORT) {
                meta.setDisplayName(KyoriHelper.toLegacy(displayName));
                return;
            }
            Field displayNameField = CRAFT_META.getDeclaredField("displayName");
            displayNameField.setAccessible(true);
            if (ItemMeta.isDisplayNameString()) {
                DISPLAY_NAME_FIELD.set(meta, KyoriHelper.toJson(displayName));
            } else {
                DISPLAY_NAME_FIELD.set(meta, MinecraftReflection.toMinecraftComponent(displayName).getObject());
            }
        }

        public static Option<Component> getDisplayName(org.bukkit.inventory.meta.ItemMeta meta) {
            Object displayName = DISPLAY_NAME_FIELD.get(meta);
            if (displayName == null) {
                return Option.none();
            }
            if (displayName instanceof String) {
                if (!FeatureSupport.TEXT_COMPONENTS_IN_ITEMS_SUPPORT) {
                    return Option.some(KyoriHelper.fromLegacy((String)displayName));
                }
                return Option.some(KyoriHelper.fromJson((String)displayName));
            }
            return Option.some(MinecraftReflection.fromMinecraftComponent(ReflectionObject.of(displayName)));
        }

        public static void setLore(org.bukkit.inventory.meta.ItemMeta meta, Collection<Component> lore) {
            LORE_FIELD.set(meta, lore.stream().map(component -> {
                if (!FeatureSupport.TEXT_COMPONENTS_IN_ITEMS_SUPPORT) {
                    return KyoriHelper.toLegacy(component);
                }
                if (ItemMeta.isDisplayNameString()) {
                    return KyoriHelper.toJson(component);
                }
                return MinecraftReflection.toMinecraftComponent(component).getObject();
            }).collect(Collectors.toList()));
        }

        public static List<Component> getLore(org.bukkit.inventory.meta.ItemMeta meta) {
            List rawLore = (List)LORE_FIELD.get(meta);
            if (rawLore == null || rawLore.isEmpty()) {
                return Collections.emptyList();
            }
            return rawLore.stream().map(obj -> {
                if (!FeatureSupport.TEXT_COMPONENTS_IN_ITEMS_SUPPORT) {
                    return KyoriHelper.fromLegacy((String)obj);
                }
                if (ItemMeta.isDisplayNameString()) {
                    return KyoriHelper.fromJson((String)obj);
                }
                return MinecraftReflection.fromMinecraftComponent(ReflectionObject.of(obj));
            }).collect(Collectors.toList());
        }

        public static Option<Integer> getCustomModelData(org.bukkit.inventory.meta.ItemMeta itemMeta) {
            ItemMeta.ensureCmdSupport();
            Method getCustomModelData = CLASS.getMethod("getCustomModelData", new Class[0]);
            return Option.of((Integer)getCustomModelData.invoke((Object)itemMeta, new Object[0]));
        }

        public static Option<Integer> tryGetCustomModelData(org.bukkit.inventory.meta.ItemMeta itemMeta) {
            if (!FeatureSupport.CMD_SUPPORT) {
                return Option.none();
            }
            return ItemMeta.getCustomModelData(itemMeta);
        }

        public static void setCustomModelData(org.bukkit.inventory.meta.ItemMeta itemMeta, Integer cmd) {
            ItemMeta.ensureCmdSupport();
            Method setCustomModelData = CLASS.getMethod("setCustomModelData", Integer.class);
            setCustomModelData.invoke((Object)itemMeta, cmd);
        }

        private static void ensureCmdSupport() {
            if (!FeatureSupport.CMD_SUPPORT) {
                throw new IllegalStateException("Custom model data is supported from >=1.14. Current version " + MinecraftVersion.CURRENT);
            }
        }

        static {
            try {
                DISPLAY_NAME_FIELD = CRAFT_META.getDeclaredField("displayName");
                LORE_FIELD = CRAFT_META.getDeclaredField("lore");
                DISPLAY_NAME_FIELD.setAccessible(true);
                LORE_FIELD.setAccessible(true);
            }
            catch (NoSuchFieldException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static class NamespacedKey {
        public static final Class<?> CLASS;

        public static ReflectionObject of(String namespace, String key) {
            NamespacedKey.validate();
            return ReflectionObject.newInstance(CLASS, namespace, key);
        }

        public static ReflectionObject from(Key key) {
            return NamespacedKey.of(key.namespace(), key.value());
        }

        public static ReflectionObject from(String key) {
            return NamespacedKey.from(Key.key(key));
        }

        public static Key getKyoriKey(ReflectionObject reflectionObject) {
            NamespacedKey.validate();
            if (reflectionObject.getClazz() != CLASS) {
                throw new IllegalArgumentException("Not a namespaced key " + reflectionObject.getClazz() + " " + reflectionObject.getObject());
            }
            return Key.key(reflectionObject.getObject().toString());
        }

        private static void validate() {
            if (CLASS == null) {
                MinecraftVersion.CURRENT.assertAtLeast(1, 13);
            }
        }

        static {
            try {
                CLASS = MinecraftVersion.CURRENT.isAtLeast(1, 13) ? Class.forName("org.bukkit.NamespacedKey") : null;
            }
            catch (Throwable e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static class ConsoleCommandSender {
        public static final Class<org.bukkit.command.ConsoleCommandSender> CLASS = org.bukkit.command.ConsoleCommandSender.class;

        public static void sendComponentMessage(org.bukkit.command.ConsoleCommandSender consoleCommandSender, Component component) {
            boolean isSent = Option.ofOptional(Arrays.stream(CLASS.getMethods()).filter(m4 -> m4.getName().equals("spigot")).findFirst()).flatMap(CheckedFunction1.lift(method -> {
                Object spigot = method.invoke((Object)consoleCommandSender, new Object[0]);
                Class<?> spigotClass = spigot.getClass();
                Method sendMessage = spigotClass.getMethod("sendMessage", BaseComponent[].class);
                sendMessage.invoke(spigot, new Object[]{KyoriHelper.convert(component)});
                return true;
            })).getOrElse(false);
            if (!isSent) {
                consoleCommandSender.sendMessage(KyoriHelper.toLegacy(component));
            }
        }
    }
}

