/*
 * Decompiled with CFR 0.152.
 */
package ua.valeriishymchuk.simpleitemgenerator.common.time;

import io.vavr.control.Option;
import java.time.Duration;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TimeTokenParser {
    private static final Pattern TIME_TOKEN_PATTERN = Pattern.compile("((?<value>\\d+)(?<timeunit>[a-z]+)?)( +)?");

    public static long parse(String time) {
        Matcher matcher = TIME_TOKEN_PATTERN.matcher(time);
        long timeMillis = 0L;
        while (matcher.find()) {
            int value = Integer.parseInt(matcher.group("value"));
            long timeUnitMillis = Option.of(matcher.group("timeunit")).map(unit -> {
                switch (unit) {
                    case "s": {
                        return 1000L;
                    }
                    case "m": {
                        return 60000L;
                    }
                    case "h": {
                        return 3600000L;
                    }
                    case "t": {
                        return 50L;
                    }
                }
                throw new IllegalStateException("Unknown time unit: " + unit);
            }).getOrElse(1L);
            timeMillis += (long)value * timeUnitMillis;
        }
        return timeMillis;
    }

    public static String parse(long timeMillis) {
        Duration duration = Duration.ofMillis(timeMillis);
        long seconds = duration.getSeconds() % 60L;
        long minutes = duration.toMinutes() % 60L;
        long hours = duration.toHours() % 24L;
        long millis = duration.toMillis() % 1000L;
        StringBuilder sb = new StringBuilder();
        if (hours > 0L) {
            sb.append(hours).append("h ");
        }
        if (minutes > 0L) {
            sb.append(minutes).append("m ");
        }
        if (seconds > 0L) {
            sb.append(seconds).append("s ");
        }
        if (millis > 0L) {
            sb.append(millis);
        }
        return sb.toString().trim();
    }
}

