/*
 * Decompiled with CFR 0.152.
 */
package ua.valeriishymchuk.simpleitemgenerator.controller;

import io.vavr.Tuple;
import io.vavr.control.Option;
import java.util.stream.Collectors;
import lombok.Generated;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import ua.valeriishymchuk.simpleitemgenerator.commandframework.Command;
import ua.valeriishymchuk.simpleitemgenerator.commandframework.CommandManager;
import ua.valeriishymchuk.simpleitemgenerator.commandframework.arguments.standard.StringArgument;
import ua.valeriishymchuk.simpleitemgenerator.commandframework.bukkit.parsers.PlayerArgument;
import ua.valeriishymchuk.simpleitemgenerator.common.message.KyoriHelper;
import ua.valeriishymchuk.simpleitemgenerator.dto.GiveItemDTO;
import ua.valeriishymchuk.simpleitemgenerator.service.IItemService;

public class CommandsController {
    private static final String COMMAND_PERMISSION_PREPEND = "simpleitemgenerator.commands.";
    private final IItemService itemService;

    public void setupCommands(CommandManager<CommandSender> commandManager) {
        Command.Builder<CommandSender> builder = commandManager.commandBuilder("simpleitemgenerator", "sig").permission("simpleitemgenerator.commands.general");
        commandManager.command(builder.literal("give", new String[0]).permission("simpleitemgenerator.commands.give").argument(StringArgument.builder("key").withSuggestionsProvider((ctx, s2) -> this.itemService.getItemKeys().stream().filter(line -> line.contains((CharSequence)s2)).collect(Collectors.toList()))).argument(PlayerArgument.optional("player")).handler(ctx -> {
            String key = (String)ctx.get("key");
            Option<Player> playerOpt = Option.of(ctx.get("player")).orElse(() -> Option.when(ctx.getSender() instanceof Player, () -> (Player)ctx.getSender()));
            GiveItemDTO result = this.itemService.giveItem(key, (Player)playerOpt.getOrNull());
            KyoriHelper.sendMessage((CommandSender)ctx.getSender(), result.getMessage());
            playerOpt.flatMap(player -> result.getItemStack().map(item -> Tuple.of(player, item))).peek(tuple -> ((Player)tuple._1).getInventory().addItem(new ItemStack[]{(ItemStack)tuple._2}));
        }));
        commandManager.command(builder.literal("reload", new String[0]).permission("simpleitemgenerator.commands.reload").handler(ctx -> KyoriHelper.sendMessage((CommandSender)ctx.getSender(), this.itemService.reload())));
    }

    @Generated
    public CommandsController(IItemService itemService) {
        this.itemService = itemService;
    }
}

