/*
 * Decompiled with CFR 0.152.
 */
package ua.valeriishymchuk.simpleitemgenerator.controller;

import lombok.Generated;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Cancellable;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.player.PlayerInteractAtEntityEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import ua.valeriishymchuk.simpleitemgenerator.common.message.KyoriHelper;
import ua.valeriishymchuk.simpleitemgenerator.dto.ItemUsageResultDTO;
import ua.valeriishymchuk.simpleitemgenerator.service.IItemService;

public class EventsController
implements Listener {
    private final IItemService itemService;

    @EventHandler(priority=EventPriority.HIGH)
    private void onUsage(PlayerInteractEvent event) {
        if (event.useItemInHand() == Event.Result.DENY) {
            return;
        }
        ItemUsageResultDTO result = this.itemService.useItem(event.getPlayer(), event.getAction(), event.getItem());
        this.handleResult(result, event.getPlayer(), (Cancellable)event);
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.HIGH)
    private void onInteractAt(PlayerInteractAtEntityEvent event) {
        ItemUsageResultDTO result = this.itemService.useItemAt(event.getPlayer(), true, event.getRightClicked(), event.getPlayer().getItemInHand());
        this.handleResult(result, event.getPlayer(), (Cancellable)event);
    }

    @EventHandler(priority=EventPriority.HIGH)
    private void onDamage(EntityDamageByEntityEvent event) {
        if (!(event.getDamager() instanceof Player)) {
            return;
        }
        Player player = (Player)event.getDamager();
        boolean isCancelled = event.isCancelled();
        ItemUsageResultDTO result = this.itemService.useItemAt(player, false, event.getEntity(), player.getItemInHand());
        this.handleResult(result, player, (Cancellable)event);
        if (isCancelled) {
            event.setCancelled(true);
        }
    }

    private void handleResult(ItemUsageResultDTO result, Player player, Cancellable event) {
        event.setCancelled(result.isShouldCancel());
        result.getCommands().forEach(commands -> {
            ConsoleCommandSender sender = commands.isExecuteAsConsole() ? Bukkit.getConsoleSender() : player;
            Bukkit.dispatchCommand((CommandSender)sender, (String)commands.getCommand());
        });
        result.getMessage().peek(message -> KyoriHelper.sendMessage((CommandSender)player, message));
    }

    @Generated
    public EventsController(IItemService itemService) {
        this.itemService = itemService;
    }
}

