/*
 * Decompiled with CFR 0.152.
 */
package ua.valeriishymchuk.simpleitemgenerator.controller;

import java.util.Arrays;
import java.util.Objects;
import java.util.stream.Stream;
import lombok.Generated;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.ItemStack;
import ua.valeriishymchuk.simpleitemgenerator.common.scheduler.BukkitTaskScheduler;
import ua.valeriishymchuk.simpleitemgenerator.service.IItemService;

public class TickController {
    private final IItemService itemService;
    private final BukkitTaskScheduler taskScheduler;

    public void start() {
        this.taskScheduler.runTaskLater(() -> {
            this.updateItems();
            this.start();
        }, this.itemService.getUpdatePeriodTicks());
    }

    private void updateItems() {
        Bukkit.getOnlinePlayers().forEach(player -> {
            InventoryView inventoryView = player.getOpenInventory();
            Stream.of(inventoryView.getTopInventory().getContents(), inventoryView.getBottomInventory().getContents()).flatMap(Arrays::stream).filter(Objects::nonNull).filter(ItemStack::hasItemMeta).forEach(item -> this.itemService.updateItem((ItemStack)item, (Player)player));
        });
    }

    @Generated
    public TickController(IItemService itemService, BukkitTaskScheduler taskScheduler) {
        this.itemService = itemService;
        this.taskScheduler = taskScheduler;
    }
}

