/*
 * Decompiled with CFR 0.152.
 */
package ua.valeriishymchuk.simpleitemgenerator.entity;

import io.vavr.Function0;
import io.vavr.Lazy;
import io.vavr.collection.HashMap;
import io.vavr.collection.LinkedHashMap;
import io.vavr.control.Option;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import ua.valeriishymchuk.simpleitemgenerator.common.item.NBTCustomItem;
import ua.valeriishymchuk.simpleitemgenerator.common.item.RawItem;
import ua.valeriishymchuk.simpleitemgenerator.common.message.KyoriHelper;
import ua.valeriishymchuk.simpleitemgenerator.common.reflection.ReflectedRepresentations;
import ua.valeriishymchuk.simpleitemgenerator.common.regex.RegexUtils;
import ua.valeriishymchuk.simpleitemgenerator.common.support.ItemsAdderSupport;
import ua.valeriishymchuk.simpleitemgenerator.common.support.PapiSupport;
import ua.valeriishymchuk.simpleitemgenerator.common.time.TimeTokenParser;
import ua.valeriishymchuk.simpleitemgenerator.common.version.FeatureSupport;
import ua.valeriishymchuk.simpleitemgenerator.entity.UsageEntity;
import ua.valeriishymchuk.simpleitemgenerator.kyori.adventure.text.Component;
import ua.valeriishymchuk.simpleitemgenerator.spongepowered.configurate.ConfigurationNode;
import ua.valeriishymchuk.simpleitemgenerator.spongepowered.configurate.objectmapping.ConfigSerializable;
import ua.valeriishymchuk.simpleitemgenerator.spongepowered.configurate.yaml.NodeStyle;
import ua.valeriishymchuk.simpleitemgenerator.spongepowered.configurate.yaml.YamlConfigurationLoader;

@ConfigSerializable
public class ConfigEntity {
    private final Map<String, CustomItem> items = Function0.of(() -> {
        RawItem exampleItem = new RawItem("DIAMOND", "<red><bold>Cool diamond%id%", Arrays.asList("<green>First lore", "<red>Second lore"), FeatureSupport.CMD_SUPPORT ? Integer.valueOf(1) : null, Arrays.asList(ItemFlag.HIDE_ATTRIBUTES, ItemFlag.HIDE_ENCHANTS), HashMap.of(ConfigEntity.serializeEnchantment(Enchantment.LUCK), 1).toJavaMap());
        UsageEntity singleCommandUsage = UsageEntity.DEFAULT.withCommands(ConfigEntity.deserializeConfigCommands("[console] say %player% hi, you clicked item"));
        UsageEntity multipleCommandUsage = UsageEntity.DEFAULT.withCommands(ConfigEntity.deserializeConfigCommands("[console] tellraw %player% %minimessage_<red>I am using minimessage in placeholder%", "[console] tellraw %player% %minimessage_<bold><green>So you don't have to use json%"));
        UsageEntity example3 = multipleCommandUsage.withCooldownFreezeTimeMillis(TimeTokenParser.parse("1s")).withCooldownMillis(TimeTokenParser.parse("5s")).withOnCooldown(ConfigEntity.deserializeConfigCommands("[console] say %player% wait %time_s.2f%s"));
        UsageEntity example4 = example3.withCommands(ConfigEntity.deserializeConfigCommands("[console] say %player% you used item", "[player] open_some_menu")).withOnCooldown(ConfigEntity.deserializeConfigCommands("[console] say %player% wait %time_s.2f%s")).withPredicates(Collections.singletonList(UsageEntity.ClickButton.LEFT.asType())).withCancel(false);
        UsageEntity example5 = multipleCommandUsage.withPredicates(Collections.singletonList(UsageEntity.ClickAt.PLAYER.asType())).withCooldownMillis(TimeTokenParser.parse("3h5m3s200"));
        UsageEntity example6 = example5.withPredicates(Collections.singletonList(new UsageEntity.ClickType(UsageEntity.ClickButton.LEFT, UsageEntity.ClickAt.AIR)));
        UsageEntity example7 = example6.withCooldownMillis(0L);
        UsageEntity example8 = example7.withPredicates(Arrays.asList(new UsageEntity.ClickType(UsageEntity.ClickButton.LEFT, UsageEntity.ClickAt.AIR), UsageEntity.ClickAt.BLOCK.asType()));
        AtomicInteger ai = new AtomicInteger();
        return ((LinkedHashMap)LinkedHashMap.of("item0", Collections.emptyList(), "item1", Collections.singletonList(singleCommandUsage), "item2", Collections.singletonList(multipleCommandUsage), "item3", Collections.singletonList(example3), "item4", Collections.singletonList(example4), "item5", Collections.singletonList(example5), "item6", Collections.singletonList(example6), "item7", Collections.singletonList(example7), "item8", Collections.singletonList(example8), "item9", Arrays.asList(example8, example8.withPredicates(Collections.singletonList(UsageEntity.ClickAt.ENTITY.asType())).withCommands(ConfigEntity.deserializeConfigCommands("[console] tellraw %minimessage_<green>You clicked at entity%")))).mapValues(usage -> CustomItem.of(exampleItem.replace("%id%", ai.getAndIncrement() + ""), (List<UsageEntity>)usage))).toJavaMap();
    }).get();
    private final String placeholderUpdatePeriod = "10t";

    private static String serializeEnchantment(Enchantment enchantment) {
        if (!FeatureSupport.NAMESPACED_ENCHANTMENTS_SUPPORT) {
            return enchantment.getName();
        }
        return ReflectedRepresentations.Enchantment.getKyoriKey(enchantment).asString();
    }

    private static UsageEntity.Command deserializeCommand(String rawCommand) {
        return ConfigEntity.prepareCommand(rawCommand).replace(command -> RegexUtils.replaceAll(CustomItem.MINIMESSAGE_COMMAND_PLACEHOLDER.matcher((CharSequence)command), commandMatcher -> {
            String rawMessage = commandMatcher.group("placeholder");
            return KyoriHelper.mimiMessageToJson(rawMessage);
        }));
    }

    private static UsageEntity.Command prepareCommand(String rawCommand) {
        Matcher matcher = CustomItem.COMMAND_EXECUTION_PATTERN.matcher(rawCommand);
        if (!matcher.find()) {
            throw new IllegalArgumentException("Invalid command: " + rawCommand);
        }
        String command = matcher.group("command");
        boolean isConsoleSender = matcher.group("sender").equals("console");
        return new UsageEntity.Command(isConsoleSender, command);
    }

    private static List<UsageEntity.Command> deserializeCommands(List<String> rawCommands) {
        return rawCommands.stream().map(ConfigEntity::deserializeCommand).collect(Collectors.toList());
    }

    private static List<UsageEntity.Command> deserializeCommands(String ... rawCommands) {
        return ConfigEntity.deserializeCommands(Arrays.asList(rawCommands));
    }

    private static List<UsageEntity.Command> deserializeConfigCommands(List<String> rawCommands) {
        return rawCommands.stream().map(ConfigEntity::prepareCommand).collect(Collectors.toList());
    }

    private static List<UsageEntity.Command> deserializeConfigCommands(String ... rawCommands) {
        return ConfigEntity.deserializeConfigCommands(Arrays.asList(rawCommands));
    }

    private static String serializeCommand(UsageEntity.Command command) {
        String prepend = command.isExecuteAsConsole() ? "[console]" : "[player]";
        return prepend + " " + command.getCommand();
    }

    private static List<String> serializeCommands(List<UsageEntity.Command> commands) {
        return commands.stream().map(ConfigEntity::serializeCommand).collect(Collectors.toList());
    }

    public long getPlaceholderUpdatePeriod() {
        return TimeTokenParser.parse("10t");
    }

    public Option<ItemStack> bakeItem(String key, Player player) {
        CustomItem customItem = (CustomItem)this.getItem(key).getOrNull();
        if (customItem == null) {
            return Option.none();
        }
        ItemStack itemStack = customItem.getItemStack();
        NBTCustomItem.setCustomItemId(itemStack, key);
        this.updateItem(itemStack, player);
        return Option.some(itemStack);
    }

    public List<String> getItemKeys() {
        return new ArrayList<String>(this.items.keySet());
    }

    public Option<CustomItem> getItem(String key) {
        return Option.of(this.items.get(key));
    }

    public void updateItem(ItemStack itemStack, Player player) {
        String customItemId = (String)NBTCustomItem.getCustomItemId(itemStack).getOrNull();
        if (customItemId == null) {
            return;
        }
        CustomItem customItem = this.items.get(customItemId);
        if (!customItem.hasPlaceHolders()) {
            return;
        }
        ItemMeta configItemMeta = customItem.getItemStack().getItemMeta();
        ItemMeta meta = itemStack.getItemMeta();
        ReflectedRepresentations.ItemMeta.getDisplayName(configItemMeta).map(KyoriHelper::toJson).map(line -> PapiSupport.tryParse((OfflinePlayer)player, line)).map(KyoriHelper::fromJson).peek(line -> ReflectedRepresentations.ItemMeta.setDisplayName(meta, line));
        ReflectedRepresentations.ItemMeta.setLore(meta, ReflectedRepresentations.ItemMeta.getLore(configItemMeta).stream().map(KyoriHelper::toJson).map(line -> PapiSupport.tryParse((OfflinePlayer)player, line)).map(KyoriHelper::fromJson).collect(Collectors.toList()));
        itemStack.setItemMeta(meta);
    }

    @ConfigSerializable
    public static class CustomItem {
        private static final Pattern MINIMESSAGE_COMMAND_PLACEHOLDER = Pattern.compile("%minimessage_(?<placeholder>.+)%");
        private static final Pattern PLACEHOLDER_PATTERN = Pattern.compile("%(?<placeholder>\\S+)%");
        private static final Pattern COMMAND_EXECUTION_PATTERN = Pattern.compile("\\[(?<sender>player|console)] (?<command>.*)");
        private static final Pattern SINGLE_PREDICATE_PATTERN = Pattern.compile("\\[(?<enum>at|button)] (?<type>.*)");
        private static final Pattern ITEM_LINK_PATTERN = Pattern.compile("\\[(?<linktype>.+)] (?<link>.*)");
        private static final YamlConfigurationLoader NODE_LOADER = YamlConfigurationLoader.builder().nodeStyle(NodeStyle.BLOCK).indent(2).build();
        private final ConfigurationNode item;
        private final ConfigurationNode usage;
        private final transient Lazy<List<UsageEntity>> usages = Lazy.of(this::parseUsages);
        private final transient Lazy<ItemStack> itemStack = Lazy.of(this::parseItem);
        private final transient Lazy<Boolean> hasPlaceholders = Lazy.of(this::hasPlaceholders0);

        private CustomItem() {
            this(CustomItem.createNode(), CustomItem.createNode());
        }

        private static ConfigurationNode createNode() {
            return NODE_LOADER.createNode();
        }

        public static CustomItem of(ItemStack item, List<UsageEntity> usages) {
            return new CustomItem(CustomItem.serializeItemStack(item), CustomItem.serializeUsages(usages));
        }

        public static CustomItem of(RawItem item, List<UsageEntity> usages) {
            return new CustomItem(CustomItem.createNode().set(item), CustomItem.serializeUsages(usages));
        }

        private static ConfigurationNode serializeItemStack(ItemStack item) {
            ConfigurationNode node = CustomItem.createNode();
            ItemMeta meta = item.getItemMeta();
            Material material = item.getType();
            RawItem rawItem = new RawItem(material.name(), (String)Option.of(meta.getDisplayName()).map(KyoriHelper::jsonToMiniMessage).getOrNull(), meta.getLore().stream().map(KyoriHelper::jsonToMiniMessage).collect(Collectors.toList()), (Integer)ReflectedRepresentations.ItemMeta.tryGetCustomModelData(meta).getOrNull(), new ArrayList<ItemFlag>(meta.getItemFlags()), ((HashMap)HashMap.ofAll(meta.getEnchants()).mapKeys(x$0 -> ConfigEntity.serializeEnchantment(x$0))).toJavaMap());
            node.set(RawItem.class, rawItem);
            return node;
        }

        private static ConfigurationNode serializeUsages(List<UsageEntity> usages) {
            ConfigurationNode node = CustomItem.createNode();
            if (usages.isEmpty()) {
                return node;
            }
            if (usages.size() == 1) {
                return CustomItem.serializeUsage(usages.get(0));
            }
            return node.set(usages.stream().map(CustomItem::serializeUsage).map(ConfigurationNode::raw).collect(Collectors.toList()));
        }

        private static ConfigurationNode serializeUsage(UsageEntity usage) {
            boolean isCommandsOnly;
            boolean isEmpty;
            ConfigurationNode node = CustomItem.createNode();
            boolean bl = isEmpty = !usage.isCancel() && usage.getCommands().isEmpty() && usage.getOnCooldown().isEmpty() && usage.getPredicates().isEmpty();
            if (isEmpty) {
                return node;
            }
            boolean bl2 = isCommandsOnly = !usage.getCommands().isEmpty() && usage.getOnCooldown().isEmpty() && usage.getPredicates().isEmpty() && usage.getCooldownMillis() == 0L && usage.getCooldownFreezeTimeMillis() == 0L;
            if (isCommandsOnly) {
                if (usage.getCommands().size() == 1) {
                    return CustomItem.serializeCommand(usage.getCommands().get(0));
                }
                return node.set(usage.getCommands().stream().map(CustomItem::serializeCommand).map(ConfigurationNode::raw).collect(Collectors.toList()));
            }
            if (usage.getCooldownMillis() > 0L) {
                node.node("cooldown").set(TimeTokenParser.parse(usage.getCooldownMillis()));
            }
            if (usage.getCooldownFreezeTimeMillis() > 0L) {
                node.node("freezetime").set(TimeTokenParser.parse(usage.getCooldownFreezeTimeMillis()));
            }
            if (!usage.isCancel()) {
                node.node("cancel").set(false);
            }
            node.node("commands").set(CustomItem.serializeCommands(usage.getCommands()).raw());
            node.node("on-cooldown").set(CustomItem.serializeCommands(usage.getOnCooldown()).raw());
            node.node("predicate").set(CustomItem.serializePredicates(usage.getPredicates()).raw());
            return node;
        }

        private static ConfigurationNode serializePredicates(List<UsageEntity.ClickType> predicate) {
            ConfigurationNode node = CustomItem.createNode();
            if (predicate.isEmpty()) {
                return node;
            }
            if (predicate.size() == 1) {
                return CustomItem.serializePredicate(predicate.get(0));
            }
            node.set(predicate.stream().map(CustomItem::serializePredicate).map(ConfigurationNode::raw).collect(Collectors.toList()));
            return node;
        }

        private static ConfigurationNode serializePredicate(UsageEntity.ClickType clickType) {
            boolean hasAtOrSide = clickType.getAt().isDefined() ^ clickType.getSide().isDefined();
            if (hasAtOrSide) {
                boolean isAt = clickType.getAt().isDefined();
                String prepend = isAt ? "at" : "button";
                String value = (String)clickType.getAt().map(Enum::name).orElse(clickType.getSide().map(Enum::name)).map(String::toLowerCase).get();
                ConfigurationNode node = CustomItem.createNode();
                node.set("[" + prepend + "] " + value);
                return node;
            }
            ConfigurationNode node = CustomItem.createNode();
            node.node("at").set(clickType.getAt().map(Enum::name).map(String::toLowerCase).get());
            node.node("button").set(clickType.getSide().map(Enum::name).map(String::toLowerCase).get());
            return node;
        }

        private static ConfigurationNode serializeCommands(List<UsageEntity.Command> commands) {
            ConfigurationNode node = CustomItem.createNode();
            if (commands.isEmpty()) {
                return node;
            }
            if (commands.size() == 1) {
                return CustomItem.serializeCommand(commands.get(0));
            }
            node.set(commands.stream().map(CustomItem::serializeCommand).map(ConfigurationNode::raw).collect(Collectors.toList()));
            return node;
        }

        private static ConfigurationNode serializeCommand(UsageEntity.Command command) {
            ConfigurationNode node = CustomItem.createNode();
            node.set(ConfigEntity.serializeCommand(command));
            return node;
        }

        public boolean hasPlaceHolders() {
            return this.hasPlaceholders.get();
        }

        private boolean hasPlaceholders0() {
            ItemStack item = this.getItemStack();
            Option<Component> displayOpt = ReflectedRepresentations.ItemMeta.getDisplayName(item.getItemMeta());
            List<Component> lore = ReflectedRepresentations.ItemMeta.getLore(item.getItemMeta());
            return Stream.of(displayOpt.toJavaList(), lore).flatMap(Collection::stream).map(KyoriHelper::toJson).map(PLACEHOLDER_PATTERN::matcher).anyMatch(Matcher::find);
        }

        public List<UsageEntity> getUsages() {
            return this.usages.get();
        }

        public ItemStack getItemStack() {
            return this.itemStack.get().clone();
        }

        private ItemStack parseItem() {
            if (this.item.isMap()) {
                return this.item.get(RawItem.class).bake();
            }
            String rawItem = this.item.getString();
            Matcher matcher = ITEM_LINK_PATTERN.matcher(rawItem);
            if (!matcher.find()) {
                throw new IllegalArgumentException("Invalid item: " + rawItem);
            }
            String linkType = matcher.group("linktype");
            String link = matcher.group("link");
            if (!linkType.equals("itemsadder")) {
                throw new IllegalArgumentException("Invalid link type: " + linkType);
            }
            ItemStack item = ItemsAdderSupport.getItem(link);
            return item;
        }

        private List<UsageEntity> parseUsages() {
            if (this.usage.isNull()) {
                return Collections.singletonList(new UsageEntity(Collections.emptyList(), 0L, 0L, true, Collections.emptyList(), Collections.emptyList()));
            }
            if (this.usage.isList()) {
                return this.usage.getList(ConfigurationNode.class).stream().map(this::parseUsage).collect(Collectors.toList());
            }
            return Collections.singletonList(this.parseUsage(this.usage));
        }

        private UsageEntity parseUsage(ConfigurationNode node) {
            if (!node.isMap()) {
                return new UsageEntity(Collections.emptyList(), 0L, 0L, true, Collections.emptyList(), this.parseCommands(node));
            }
            long cooldown = TimeTokenParser.parse(node.node("cooldown").getString(""));
            long freezeTime = TimeTokenParser.parse(node.node("freezetime").getString(""));
            boolean shouldCancelEvent = node.node("cancel").getBoolean(true);
            ConfigurationNode predicateNode = node.node("predicate");
            List<Object> predicate = predicateNode.isNull() ? Collections.emptyList() : (predicateNode.isList() ? predicateNode.getList(ConfigurationNode.class).stream().map(this::parsePredicate).collect(Collectors.toList()) : Collections.singletonList(this.parsePredicate(predicateNode)));
            List<UsageEntity.Command> onCooldown = this.parseCommands(node.node("on-cooldown"));
            List<UsageEntity.Command> commands = this.parseCommands(node.node("commands"));
            return new UsageEntity(predicate, cooldown, freezeTime, shouldCancelEvent, onCooldown, commands);
        }

        private List<UsageEntity.Command> parseCommands(ConfigurationNode node) {
            if (node.isNull()) {
                return Collections.emptyList();
            }
            if (node.isList()) {
                return node.getList(ConfigurationNode.class).stream().map(this::parseCommand).collect(Collectors.toList());
            }
            return Collections.singletonList(this.parseCommand(node));
        }

        private UsageEntity.Command parseCommand(ConfigurationNode node) {
            return ConfigEntity.deserializeCommand(node.getString());
        }

        private UsageEntity.ClickType parsePredicate(ConfigurationNode node) {
            if (node.isMap()) {
                UsageEntity.ClickAt clickAt = (UsageEntity.ClickAt)((Object)Option.of(node.node("at").getString()).map(String::toUpperCase).map(UsageEntity.ClickAt::valueOf).getOrNull());
                UsageEntity.ClickButton clickButton = (UsageEntity.ClickButton)((Object)Option.of(node.node("button").getString()).map(String::toUpperCase).map(UsageEntity.ClickButton::valueOf).getOrNull());
                return new UsageEntity.ClickType(clickButton, clickAt);
            }
            Matcher matcher = SINGLE_PREDICATE_PATTERN.matcher(node.getString());
            if (!matcher.find()) {
                throw new IllegalArgumentException("Invalid predicate: " + node.getString());
            }
            String type = matcher.group("type");
            boolean isAt = matcher.group("enum").equals("at");
            UsageEntity.ClickAt clickAt = null;
            UsageEntity.ClickButton clickButton = null;
            if (isAt) {
                clickAt = UsageEntity.ClickAt.valueOf(type.toUpperCase());
            } else {
                clickButton = UsageEntity.ClickButton.valueOf(type.toUpperCase());
            }
            return new UsageEntity.ClickType(clickButton, clickAt);
        }

        @Generated
        public CustomItem(ConfigurationNode item, ConfigurationNode usage) {
            this.item = item;
            this.usage = usage;
        }
    }
}

