/*
 * Decompiled with CFR 0.152.
 */
package ua.valeriishymchuk.simpleitemgenerator.entity;

import io.vavr.control.Option;
import java.util.Collections;
import java.util.List;
import java.util.function.UnaryOperator;
import lombok.Generated;
import org.jetbrains.annotations.Nullable;

public class UsageEntity {
    public static UsageEntity EMPTY = new UsageEntity(Collections.emptyList(), 0L, 0L, false, Collections.emptyList(), Collections.emptyList());
    public static UsageEntity DEFAULT = EMPTY.withCancel(true);
    private final List<ClickType> predicates;
    private final long cooldownMillis;
    private final long cooldownFreezeTimeMillis;
    private final boolean cancel;
    private final List<Command> onCooldown;
    private final List<Command> commands;

    public boolean accepts(ClickType clickType) {
        if (this.predicates.isEmpty()) {
            return true;
        }
        return this.predicates.stream().anyMatch(t2 -> t2.predicate(clickType));
    }

    @Generated
    public UsageEntity(List<ClickType> predicates, long cooldownMillis, long cooldownFreezeTimeMillis, boolean cancel, List<Command> onCooldown, List<Command> commands) {
        this.predicates = predicates;
        this.cooldownMillis = cooldownMillis;
        this.cooldownFreezeTimeMillis = cooldownFreezeTimeMillis;
        this.cancel = cancel;
        this.onCooldown = onCooldown;
        this.commands = commands;
    }

    @Generated
    public List<ClickType> getPredicates() {
        return this.predicates;
    }

    @Generated
    public long getCooldownMillis() {
        return this.cooldownMillis;
    }

    @Generated
    public long getCooldownFreezeTimeMillis() {
        return this.cooldownFreezeTimeMillis;
    }

    @Generated
    public boolean isCancel() {
        return this.cancel;
    }

    @Generated
    public List<Command> getOnCooldown() {
        return this.onCooldown;
    }

    @Generated
    public List<Command> getCommands() {
        return this.commands;
    }

    @Generated
    public UsageEntity withPredicates(List<ClickType> predicates) {
        return this.predicates == predicates ? this : new UsageEntity(predicates, this.cooldownMillis, this.cooldownFreezeTimeMillis, this.cancel, this.onCooldown, this.commands);
    }

    @Generated
    public UsageEntity withCooldownMillis(long cooldownMillis) {
        return this.cooldownMillis == cooldownMillis ? this : new UsageEntity(this.predicates, cooldownMillis, this.cooldownFreezeTimeMillis, this.cancel, this.onCooldown, this.commands);
    }

    @Generated
    public UsageEntity withCooldownFreezeTimeMillis(long cooldownFreezeTimeMillis) {
        return this.cooldownFreezeTimeMillis == cooldownFreezeTimeMillis ? this : new UsageEntity(this.predicates, this.cooldownMillis, cooldownFreezeTimeMillis, this.cancel, this.onCooldown, this.commands);
    }

    @Generated
    public UsageEntity withCancel(boolean cancel) {
        return this.cancel == cancel ? this : new UsageEntity(this.predicates, this.cooldownMillis, this.cooldownFreezeTimeMillis, cancel, this.onCooldown, this.commands);
    }

    @Generated
    public UsageEntity withOnCooldown(List<Command> onCooldown) {
        return this.onCooldown == onCooldown ? this : new UsageEntity(this.predicates, this.cooldownMillis, this.cooldownFreezeTimeMillis, this.cancel, onCooldown, this.commands);
    }

    @Generated
    public UsageEntity withCommands(List<Command> commands) {
        return this.commands == commands ? this : new UsageEntity(this.predicates, this.cooldownMillis, this.cooldownFreezeTimeMillis, this.cancel, this.onCooldown, commands);
    }

    @Generated
    public String toString() {
        return "UsageEntity(predicates=" + this.getPredicates() + ", cooldownMillis=" + this.getCooldownMillis() + ", cooldownFreezeTimeMillis=" + this.getCooldownFreezeTimeMillis() + ", cancel=" + this.isCancel() + ", onCooldown=" + this.getOnCooldown() + ", commands=" + this.getCommands() + ")";
    }

    public static enum ClickAt {
        AIR,
        PLAYER,
        ENTITY,
        BLOCK;


        public ClickType asType() {
            return new ClickType(null, this);
        }
    }

    public static enum ClickButton {
        RIGHT,
        LEFT,
        DROP;


        public ClickType asType() {
            return new ClickType(this, null);
        }
    }

    public static class ClickType {
        @Nullable
        private final ClickButton side;
        @Nullable
        private final ClickAt at;

        public Option<ClickButton> getSide() {
            return Option.of(this.side);
        }

        public Option<ClickAt> getAt() {
            return Option.of(this.at);
        }

        public boolean predicate(ClickType clickType) {
            return this.getSide().map(side1 -> side1 == clickType.side).getOrElse(true) != false && this.getAt().map(at1 -> at1 == clickType.at).getOrElse(true) != false;
        }

        @Generated
        public ClickType(@Nullable ClickButton side, @Nullable ClickAt at) {
            this.side = side;
            this.at = at;
        }

        @Generated
        public String toString() {
            return "UsageEntity.ClickType(side=" + this.getSide() + ", at=" + this.getAt() + ")";
        }
    }

    public static class Command {
        private final boolean executeAsConsole;
        private final String command;

        public Command replace(UnaryOperator<String> replacer) {
            return new Command(this.executeAsConsole, (String)replacer.apply(this.command));
        }

        @Generated
        public Command(boolean executeAsConsole, String command) {
            this.executeAsConsole = executeAsConsole;
            this.command = command;
        }

        @Generated
        public boolean isExecuteAsConsole() {
            return this.executeAsConsole;
        }

        @Generated
        public String getCommand() {
            return this.command;
        }

        @Generated
        public Command withExecuteAsConsole(boolean executeAsConsole) {
            return this.executeAsConsole == executeAsConsole ? this : new Command(executeAsConsole, this.command);
        }

        @Generated
        public Command withCommand(String command) {
            return this.command == command ? this : new Command(this.executeAsConsole, command);
        }
    }
}

