/*
 * Decompiled with CFR 0.152.
 */
package ua.valeriishymchuk.simpleitemgenerator.nbtapi;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import ua.valeriishymchuk.simpleitemgenerator.nbtapi.NBTCompound;
import ua.valeriishymchuk.simpleitemgenerator.nbtapi.NBTList;
import ua.valeriishymchuk.simpleitemgenerator.nbtapi.NBTType;
import ua.valeriishymchuk.simpleitemgenerator.nbtapi.NbtApiException;
import ua.valeriishymchuk.simpleitemgenerator.nbtapi.utils.nmsmappings.ClassWrapper;
import ua.valeriishymchuk.simpleitemgenerator.nbtapi.utils.nmsmappings.ReflectionMethod;

public class NBTFloatList
extends NBTList<Float> {
    protected NBTFloatList(NBTCompound owner, String name, NBTType type, Object list) {
        super(owner, name, type, list);
    }

    @Override
    protected Object asTag(Float object) {
        try {
            Constructor<?> con = ClassWrapper.NMS_NBTTAGFLOAT.getClazz().getDeclaredConstructor(Float.TYPE);
            con.setAccessible(true);
            return con.newInstance(object);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw new NbtApiException("Error while wrapping the Object " + object + " to it's NMS object!", e);
        }
    }

    @Override
    public Float get(int index) {
        try {
            Object obj = ReflectionMethod.LIST_GET.run(this.listObject, index);
            return Float.valueOf(obj.toString());
        }
        catch (NumberFormatException nf) {
            return Float.valueOf(0.0f);
        }
        catch (Exception ex) {
            throw new NbtApiException(ex);
        }
    }
}

