/*
 * Decompiled with CFR 0.152.
 */
package ua.valeriishymchuk.simpleitemgenerator.nbtapi.wrapper;

import java.util.function.UnaryOperator;

public enum Casing {
    camelCase(s2 -> {
        if (s2.length() < 2) {
            return s2.toLowerCase();
        }
        return Character.toLowerCase(s2.charAt(0)) + s2.substring(1);
    }),
    snake_case(s2 -> {
        StringBuilder result = new StringBuilder();
        result.append(Character.toLowerCase(s2.charAt(0)));
        for (int i = 1; i < s2.length(); ++i) {
            char currentChar = s2.charAt(i);
            if (Character.isUpperCase(currentChar)) {
                result.append('_').append(Character.toLowerCase(currentChar));
                continue;
            }
            result.append(currentChar);
        }
        return result.toString();
    }),
    PascalCase(s2 -> {
        if (s2.length() < 2) {
            return s2.toUpperCase();
        }
        return Character.toUpperCase(s2.charAt(0)) + s2.substring(1);
    }),
    lowercase(String::toLowerCase),
    UPPERCASE(String::toUpperCase);

    private UnaryOperator<String> convert;

    private Casing(UnaryOperator<String> function) {
        this.convert = function;
    }

    public String convertString(String str) {
        return (String)this.convert.apply(str);
    }
}

