/*
 * Decompiled with CFR 0.152.
 */
package ua.valeriishymchuk.simpleitemgenerator.service.impl;

import io.vavr.control.Option;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.block.Action;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.Nullable;
import ua.valeriishymchuk.simpleitemgenerator.common.component.RawComponent;
import ua.valeriishymchuk.simpleitemgenerator.common.item.NBTCustomItem;
import ua.valeriishymchuk.simpleitemgenerator.common.regex.RegexUtils;
import ua.valeriishymchuk.simpleitemgenerator.common.support.PapiSupport;
import ua.valeriishymchuk.simpleitemgenerator.dto.CommandExecutionDTO;
import ua.valeriishymchuk.simpleitemgenerator.dto.GiveItemDTO;
import ua.valeriishymchuk.simpleitemgenerator.dto.ItemUsageResultDTO;
import ua.valeriishymchuk.simpleitemgenerator.entity.ConfigEntity;
import ua.valeriishymchuk.simpleitemgenerator.entity.LangEntity;
import ua.valeriishymchuk.simpleitemgenerator.entity.UsageEntity;
import ua.valeriishymchuk.simpleitemgenerator.kyori.adventure.text.Component;
import ua.valeriishymchuk.simpleitemgenerator.repository.IConfigRepository;
import ua.valeriishymchuk.simpleitemgenerator.service.IItemService;

public class ItemService
implements IItemService {
    private static final Pattern TIME_PATTERN = Pattern.compile("%time_(?<timeunit>[a-z])(\\.(?<precision>\\d+)f)?%");
    private final IConfigRepository configRepository;

    private ConfigEntity config() {
        return this.configRepository.getConfig();
    }

    private LangEntity lang() {
        return this.configRepository.getLang();
    }

    @Override
    public ItemUsageResultDTO useItem(Player player, Action action, ItemStack item) {
        boolean isBlock = action == Action.RIGHT_CLICK_BLOCK || action == Action.LEFT_CLICK_BLOCK;
        boolean isLeftClick = action == Action.LEFT_CLICK_AIR || action == Action.LEFT_CLICK_BLOCK;
        UsageEntity.ClickType clickType = new UsageEntity.ClickType(isLeftClick ? UsageEntity.ClickButton.LEFT : UsageEntity.ClickButton.RIGHT, isBlock ? UsageEntity.ClickAt.BLOCK : UsageEntity.ClickAt.AIR);
        ItemUsageResultDTO nop = new ItemUsageResultDTO(null, Collections.emptyList(), false);
        if (action == Action.PHYSICAL) {
            return nop;
        }
        return this.useItem0(player, item, clickType);
    }

    private ItemUsageResultDTO useItem0(Player player, ItemStack item, UsageEntity.ClickType clickType) {
        ItemUsageResultDTO nop = new ItemUsageResultDTO(null, Collections.emptyList(), false);
        if (item == null || !NBTCustomItem.hasCustomItemId(item)) {
            return nop;
        }
        String customItemId = (String)NBTCustomItem.getCustomItemId(item).getOrNull();
        if (customItemId == null) {
            return nop;
        }
        ConfigEntity.CustomItem customItem = (ConfigEntity.CustomItem)this.config().getItem(customItemId).getOrNull();
        if (customItem == null) {
            return new ItemUsageResultDTO(this.lang().getInvalidItem().replaceText("%key%", customItemId).bake(), Collections.emptyList(), true);
        }
        List usages = customItem.getUsages().stream().filter(usageFilter -> usageFilter.accepts(clickType)).collect(Collectors.toList());
        return usages.stream().map(usage -> {
            NBTCustomItem.Cooldown cooldown = NBTCustomItem.queryCooldown(item, usage.getCooldownMillis(), usage.getCooldownFreezeTimeMillis(), usages.indexOf(usage));
            if (cooldown.isFrozen()) {
                return new ItemUsageResultDTO(null, Collections.emptyList(), true);
            }
            if (cooldown.isDefault()) {
                return new ItemUsageResultDTO(null, usage.getOnCooldown().stream().map(it -> this.prepareCooldown(cooldown.getRemainingMillis(), player, (UsageEntity.Command)it)).collect(Collectors.toList()), true);
            }
            return new ItemUsageResultDTO(null, usage.getCommands().stream().map(command -> this.prepare((UsageEntity.Command)command, player)).collect(Collectors.toList()), usage.isCancel());
        }).reduce((acc, e) -> new ItemUsageResultDTO(null, Stream.of(acc, e).map(ItemUsageResultDTO::getCommands).flatMap(Collection::stream).collect(Collectors.toList()), acc.isShouldCancel() || e.isShouldCancel())).orElse(new ItemUsageResultDTO(null, Collections.emptyList(), true));
    }

    private CommandExecutionDTO prepare(UsageEntity.Command command, Player player) {
        String rawCommand = this.replacePlayer(command.getCommand(), player);
        return new CommandExecutionDTO(command.isExecuteAsConsole(), rawCommand);
    }

    private CommandExecutionDTO prepareCooldown(long milliseconds, Player player, UsageEntity.Command command) {
        String rawCommand = this.replacePlayer(command.getCommand(), player);
        String finalCommand = RegexUtils.replaceAll(TIME_PATTERN.matcher(rawCommand), matcher -> {
            double value;
            String timeUnit = matcher.group("timeunit").toLowerCase();
            int precision = Option.of(matcher.group("precision")).map(Integer::parseInt).getOrElse(0);
            switch (timeUnit) {
                case "s": {
                    value = (double)milliseconds / 1000.0;
                    break;
                }
                case "m": {
                    value = (double)milliseconds / 1000.0 / 60.0;
                    break;
                }
                case "h": {
                    value = (double)milliseconds / 1000.0 / 60.0 / 60.0;
                    break;
                }
                case "t": {
                    value = (double)milliseconds / 50.0;
                    break;
                }
                default: {
                    throw new IllegalStateException("Unknown time unit: " + timeUnit);
                }
            }
            return String.format(Locale.ROOT, "%." + precision + "f", value);
        });
        return new CommandExecutionDTO(command.isExecuteAsConsole(), finalCommand);
    }

    private String replacePlayer(String text, Player player) {
        return PapiSupport.tryParse((OfflinePlayer)player, text).replace("%player%", player.getName());
    }

    @Override
    public ItemUsageResultDTO useItemAt(Player player, boolean isRightClicked, Entity clicked, ItemStack item) {
        boolean isPlayer = clicked instanceof Player;
        UsageEntity.ClickType clickType = new UsageEntity.ClickType(isRightClicked ? UsageEntity.ClickButton.RIGHT : UsageEntity.ClickButton.LEFT, isPlayer ? UsageEntity.ClickAt.PLAYER : UsageEntity.ClickAt.ENTITY);
        return this.useItem0(player, item, clickType);
    }

    @Override
    public void updateItem(ItemStack itemStack, Player player) {
        if (!PapiSupport.isPluginEnabled()) {
            return;
        }
        this.config().updateItem(itemStack, player);
    }

    @Override
    public GiveItemDTO giveItem(String key, @Nullable Player player) {
        if (player == null) {
            return new GiveItemDTO(this.lang().getSenderNotPlayer().bake(), null);
        }
        ItemStack itemStack = (ItemStack)this.config().bakeItem(key, player).getOrNull();
        RawComponent message = itemStack == null ? this.lang().getItemDoesntExist() : this.lang().getGiveItemSuccessfully();
        message = message.replaceText("%player%", player.getName()).replaceText("%key%", key);
        return new GiveItemDTO(message.bake(), itemStack);
    }

    @Override
    public List<String> getItemKeys() {
        return this.config().getItemKeys();
    }

    @Override
    public long getUpdatePeriodTicks() {
        return this.config().getPlaceholderUpdatePeriod() / 50L;
    }

    @Override
    public Component reload() {
        boolean result = this.configRepository.reload();
        return result ? this.lang().getReloadSuccessfully().bake() : this.lang().getReloadUnsuccessfully().bake();
    }

    @Generated
    public ItemService(IConfigRepository configRepository) {
        this.configRepository = configRepository;
    }
}

