/*
 * Decompiled with CFR 0.152.
 */
package ua.valeriishymchuk.simpleitemgenerator.spongepowered.configurate.loader;

import com.google.errorprone.annotations.Immutable;
import java.io.BufferedReader;
import java.io.IOException;
import java.nio.CharBuffer;
import java.util.Iterator;
import java.util.stream.Stream;
import org.checkerframework.checker.nullness.qual.Nullable;
import ua.valeriishymchuk.simpleitemgenerator.spongepowered.configurate.loader.CommentHandler;
import ua.valeriishymchuk.simpleitemgenerator.spongepowered.configurate.util.Strings;

@Immutable
public enum CommentHandlers implements CommentHandler
{
    HASH(new AbstractPrefixHandler("#")),
    DOUBLE_SLASH(new AbstractPrefixHandler("//")),
    SLASH_BLOCK(new AbstractDelineatedHandler("/*", "*/", "*")),
    XML_STYLE(new AbstractDelineatedHandler("<!--", "-->", "~"));

    private static final int READAHEAD_LEN = 4096;
    private final CommentHandler delegate;

    private CommentHandlers(CommentHandler delegate) {
        this.delegate = delegate;
    }

    @Override
    public @Nullable String extractHeader(BufferedReader reader) throws IOException {
        return this.delegate.extractHeader(reader);
    }

    @Override
    public Stream<String> toComment(Stream<String> lines) {
        return this.delegate.toComment(lines);
    }

    public static @Nullable String extractComment(BufferedReader reader, Iterable<CommentHandler> allowedHeaderTypes) throws IOException {
        reader.mark(4096);
        for (CommentHandler handler : allowedHeaderTypes) {
            @Nullable String comment = handler.extractHeader(reader);
            if (comment == null) {
                reader.reset();
                continue;
            }
            return comment;
        }
        return null;
    }

    static boolean beginsWithPrefix(String commentPrefix, BufferedReader reader) throws IOException {
        CharBuffer buf = CharBuffer.allocate(commentPrefix.length());
        if (reader.read(buf) != buf.limit()) {
            return false;
        }
        buf.flip();
        return commentPrefix.contentEquals(buf);
    }

    @Immutable
    private static final class AbstractPrefixHandler
    implements CommentHandler {
        private final String commentPrefix;

        AbstractPrefixHandler(String commentPrefix) {
            this.commentPrefix = commentPrefix;
        }

        @Override
        public @Nullable String extractHeader(BufferedReader reader) throws IOException {
            if (!CommentHandlers.beginsWithPrefix(this.commentPrefix, reader)) {
                return null;
            }
            boolean firstLine = true;
            StringBuilder build = new StringBuilder();
            String line = reader.readLine();
            while (line != null) {
                if (firstLine) {
                    if (line.length() > 0 && line.charAt(0) == ' ') {
                        line = line.substring(1);
                    }
                    build.append(line);
                    firstLine = false;
                } else if (line.trim().startsWith(this.commentPrefix)) {
                    if ((line = line.substring(line.indexOf(this.commentPrefix) + 1)).length() > 0 && line.charAt(0) == ' ') {
                        line = line.substring(1);
                    }
                    if (build.length() > 0) {
                        build.append("\n");
                    }
                    build.append(line);
                } else {
                    if (Strings.isBlank(line)) break;
                    return null;
                }
                line = reader.readLine();
            }
            return build.length() > 0 ? build.toString() : null;
        }

        @Override
        public Stream<String> toComment(Stream<String> lines) {
            return lines.map(s2 -> {
                if (s2.length() > 0 && s2.charAt(0) == ' ') {
                    return this.commentPrefix + s2;
                }
                return this.commentPrefix + " " + s2;
            });
        }
    }

    @Immutable
    private static final class AbstractDelineatedHandler
    implements CommentHandler {
        private final String startSequence;
        private final String endSequence;
        private final String lineIndentSequence;

        private AbstractDelineatedHandler(String startSequence, String endSequence, String lineIndentSequence) {
            this.startSequence = startSequence;
            this.endSequence = endSequence;
            this.lineIndentSequence = lineIndentSequence;
        }

        @Override
        public @Nullable String extractHeader(BufferedReader reader) throws IOException {
            if (!CommentHandlers.beginsWithPrefix(this.startSequence, reader)) {
                return null;
            }
            StringBuilder build = new StringBuilder();
            String line = reader.readLine();
            if (line == null) {
                return null;
            }
            if (this.handleSingleLine(build, line)) {
                line = reader.readLine();
                while (line != null && this.handleSingleLine(build, line)) {
                    line = reader.readLine();
                }
            }
            if ((line = reader.readLine()) != null && !line.trim().isEmpty()) {
                return null;
            }
            if (build.length() > 0) {
                return build.toString();
            }
            return null;
        }

        private boolean handleSingleLine(StringBuilder builder, String line) {
            boolean moreLines = true;
            if (line.trim().endsWith(this.endSequence)) {
                if ((line = line.substring(0, line.lastIndexOf(this.endSequence))).endsWith(" ")) {
                    line = line.substring(0, line.length() - 1);
                }
                moreLines = false;
                if (line.isEmpty()) {
                    return false;
                }
            }
            if (line.trim().startsWith(this.lineIndentSequence)) {
                line = line.substring(line.indexOf(this.lineIndentSequence) + 1);
            }
            if (line.length() > 0 && line.charAt(0) == ' ') {
                line = line.substring(1);
            }
            if (builder.length() > 0) {
                builder.append("\n");
            }
            builder.append(line.replace("\r", "").replace("\n", "").replace("\r\n", ""));
            return moreLines;
        }

        @Override
        public Stream<String> toComment(Stream<String> lines) {
            Stream.Builder<String> build = Stream.builder();
            boolean first = true;
            Iterator it = lines.iterator();
            while (it.hasNext()) {
                String next = (String)it.next();
                if (first) {
                    if (!it.hasNext()) {
                        build.add(this.startSequence + " " + next + " " + this.endSequence);
                        return build.build();
                    }
                    build.add(this.startSequence);
                    first = false;
                }
                build.add(" " + this.lineIndentSequence + " " + next);
            }
            build.add(" " + this.endSequence);
            return build.build();
        }
    }
}

