/*
 * Decompiled with CFR 0.152.
 */
package com.loqor.core.util;

import com.loqor.core.entities.WeepingAngelEntity;
import com.loqor.core.world.LWASounds;
import dev.drtheo.scheduler.api.TimeUnit;
import dev.drtheo.scheduler.api.common.Scheduler;
import dev.drtheo.scheduler.api.common.TaskStage;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.class_1937;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_3222;
import net.minecraft.class_3419;

public class HeartbeatUtil {
    private static final double ANGEL_DETECTION_RADIUS = 10.0;
    private static final Map<UUID, Long> lastHeartbeat = new HashMap<UUID, Long>();

    public static void checkHeartRate(class_3222 player) {
        UUID uuid;
        List<WeepingAngelEntity> angels = HeartbeatUtil.getNearbyWeepingAngels(player);
        if (angels.isEmpty()) {
            return;
        }
        double closestDistance = angels.stream().mapToDouble(angel -> angel.method_19538().method_1022(player.method_19538())).min().orElse(10.0);
        long interval = (long)Math.max(10.0, closestDistance / 10.0 * 60.0);
        long currentTime = player.method_51469().method_8510();
        if (currentTime - lastHeartbeat.getOrDefault(uuid = player.method_5667(), 0L) >= interval) {
            lastHeartbeat.put(uuid, currentTime);
            HeartbeatUtil.playDoubleHeartbeat(player);
        }
    }

    private static void playDoubleHeartbeat(class_3222 player) {
        class_1937 world = player.method_37908();
        world.method_8396(null, player.method_24515(), LWASounds.HEART_BEAT, class_3419.field_15248, 0.25f, 1.0f);
        Scheduler scheduler = Scheduler.get();
        if (scheduler != null) {
            scheduler.runTaskLater(() -> world.method_8396(null, player.method_24515(), LWASounds.HEART_BEAT, class_3419.field_15248, 0.25f, 0.95f), TaskStage.END_SERVER_TICK, TimeUnit.TICKS, 6L);
        }
    }

    private static List<WeepingAngelEntity> getNearbyWeepingAngels(class_3222 player) {
        class_243 pos = player.method_19538();
        class_238 range = new class_238(pos.method_1023(10.0, 10.0, 10.0), pos.method_1031(10.0, 10.0, 10.0));
        return player.method_37908().method_8390(WeepingAngelEntity.class, range, angel -> true);
    }
}

