/*
 * Decompiled with CFR 0.152.
 */
package com.loqor.core.entities;

import com.loqor.core.LWADamageTypes;
import com.loqor.core.angels.Angel;
import com.loqor.core.angels.AngelRegistry;
import com.loqor.core.entities.WeepingAngelBrain;
import com.loqor.core.util.StackUtil;
import com.loqor.core.world.LWASounds;
import com.mojang.serialization.Dynamic;
import dev.amble.lib.util.ServerLifecycleHooks;
import dev.drtheo.scheduler.api.TimeUnit;
import dev.drtheo.scheduler.api.common.Scheduler;
import dev.drtheo.scheduler.api.common.TaskStage;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.class_1266;
import net.minecraft.class_1267;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_13;
import net.minecraft.class_1304;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1315;
import net.minecraft.class_1330;
import net.minecraft.class_1333;
import net.minecraft.class_1334;
import net.minecraft.class_1335;
import net.minecraft.class_1339;
import net.minecraft.class_1352;
import net.minecraft.class_14;
import net.minecraft.class_1408;
import net.minecraft.class_1409;
import net.minecraft.class_1588;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1810;
import net.minecraft.class_1922;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_239;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_2746;
import net.minecraft.class_2769;
import net.minecraft.class_2902;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3695;
import net.minecraft.class_3730;
import net.minecraft.class_3959;
import net.minecraft.class_4051;
import net.minecraft.class_4076;
import net.minecraft.class_4095;
import net.minecraft.class_4140;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5425;
import net.minecraft.class_7;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;

public class WeepingAngelEntity
extends class_1588 {
    private static final List<class_1792> ANGEL_DROPS = new ArrayList<class_1792>();
    private static final Predicate<class_1267> DOOR_BREAK_DIFFICULTY_CHECKER = difficulty -> difficulty == class_1267.field_5807;
    private boolean canBreakDoors;
    private static final class_2940<Boolean> ISNOTSTONE = class_2945.method_12791(WeepingAngelEntity.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Boolean> ACTIVE = class_2945.method_12791(WeepingAngelEntity.class, (class_2941)class_2943.field_13323);
    private static final class_2940<String> ANGEL = class_2945.method_12791(WeepingAngelEntity.class, (class_2941)class_2943.field_13326);
    private static final class_2941<AngelPose> ANGEL_POSES = class_2941.method_43240(AngelPose.class);
    private static final class_2940<AngelPose> ANGEL_POSE = class_2945.method_12791(WeepingAngelEntity.class, ANGEL_POSES);
    private static final class_2940<Integer> BLOODLUST = class_2945.method_12791(WeepingAngelEntity.class, (class_2941)class_2943.field_13327);
    private static final String ANGEL_KEY = "Angel";
    public static final Predicate<class_1309> NOT_WEARING_GAZE_DISGUISE_PREDICATE = entity -> {
        if (entity instanceof class_1657) {
            class_1657 playerEntity = (class_1657)entity;
            class_1799 itemStack = playerEntity.method_6118(class_1304.field_6169);
            return itemStack.method_7909().equals(class_1802.field_17519);
        }
        return true;
    };
    private static final Set<class_2248> LIGHT_SOURCES = Set.of(class_2246.field_10336, class_2246.field_10099, class_2246.field_16541, class_2246.field_22092, class_2246.field_22110, class_2246.field_10171, class_2246.field_10524, class_2246.field_10174, class_2246.field_10455, class_2246.field_22122);
    private final Map<class_2338, Integer> flickeringLights = new HashMap<class_2338, Integer>();
    private int extinguishCooldown = 100;

    public WeepingAngelEntity(class_1299<? extends class_1588> entityType, class_1937 world) {
        super(entityType, world);
        ANGEL_DROPS.add(class_1802.field_20391);
        ANGEL_DROPS.add(class_1802.field_20412);
        ANGEL_DROPS.add(class_1802.field_23256);
        ANGEL_DROPS.add(class_1802.field_20395);
        ANGEL_DROPS.add(class_1802.field_20392);
        ANGEL_DROPS.add(class_1802.field_28866);
        ANGEL_DROPS.add(class_1802.field_28859);
        ANGEL_DROPS.add(class_1802.field_28860);
        ANGEL_DROPS.add(class_1802.field_17535);
        ANGEL_DROPS.add(class_1802.field_29025);
        ANGEL_DROPS.add(class_1802.field_20407);
        ANGEL_DROPS.add(class_1802.field_20411);
        ANGEL_DROPS.add(class_1802.field_20394);
        ANGEL_DROPS.add(class_1802.field_20397);
        ANGEL_DROPS.add(class_1802.field_20401);
        ANGEL_DROPS.add(class_1802.field_20403);
        this.field_6206 = new AngelLookControl(this);
        this.field_6207 = new AngelMoveControl(this);
        this.field_6204 = new AngelJumpControl(this);
        class_1409 mobNav = (class_1409)this.method_5942();
        mobNav.method_6354(true);
        mobNav.method_23964(4.0f);
        mobNav.method_46645(true);
        mobNav.method_35139(true);
        mobNav.method_6363(true);
        this.field_6194 = 0;
    }

    public static class_5132.class_5133 getAngelAttributes() {
        return WeepingAngelEntity.method_26828().method_26868(class_5134.field_23716, 40.0).method_26868(class_5134.field_23719, 0.4).method_26868(class_5134.field_23721, 6.0);
    }

    public float method_6029() {
        float base = super.method_6029();
        int bloodlust = this.getBloodlust();
        if (bloodlust > 0) {
            base *= 1.0f + (float)bloodlust / 100.0f * 0.5f;
        }
        if (this.method_37908().method_30272() > 0.9f) {
            base *= 1.25f;
        }
        if (this.method_6032() < this.method_6063() * 0.3f) {
            base *= 0.5f;
        }
        return base;
    }

    @Nullable
    public class_1315 method_5943(class_5425 world, class_1266 difficulty, class_3730 spawnReason, @Nullable class_1315 entityData, @Nullable class_2487 entityNbt) {
        this.setAngelPerDimension((class_1937)world.method_8410());
        return super.method_5943(world, difficulty, spawnReason, entityData, entityNbt);
    }

    public void setAngelPerDimension(class_1937 world) {
        Stream angelList = AngelRegistry.getInstance().toList().stream();
        if (world.method_27983().equals(class_1937.field_25181)) {
            this.setAngel(angelList.filter(angel -> angel.dimension().equals((Object)class_1937.field_25181)).findAny().orElse(AngelRegistry.ENDSTONE));
        } else if (world.method_27983().equals(class_1937.field_25180)) {
            this.setAngel(angelList.filter(angel -> angel.dimension().equals((Object)class_1937.field_25180)).findAny().orElse(AngelRegistry.BLACKSTONE));
        } else {
            this.setAngel(angelList.filter(angel -> angel.dimension().equals((Object)class_1937.field_25179)).findAny().orElse(AngelRegistry.STONE));
        }
    }

    protected class_1408 method_5965(class_1937 world) {
        return new AngelNavigation(this, world);
    }

    public void method_5773() {
        super.method_5773();
        if (!this.method_37908().field_9236) {
            this.extinguishNearbyLights();
            this.processFlickeringLights();
            this.decayBloodlust();
        }
    }

    protected void method_5693() {
        super.method_5693();
        this.field_6011.method_12784(ISNOTSTONE, (Object)true);
        this.field_6011.method_12784(ACTIVE, (Object)false);
        this.field_6011.method_12784(ANGEL, (Object)AngelRegistry.STONE.id().toString());
        this.field_6011.method_12784(ANGEL_POSE, (Object)AngelPose.HIDING);
        this.field_6011.method_12784(BLOODLUST, (Object)0);
    }

    public void method_5652(class_2487 nbt) {
        super.method_5652(nbt);
        nbt.method_10582(ANGEL_KEY, this.getAngelData());
    }

    public void method_6114(class_1297 target) {
        if (target.method_37908().method_8608()) {
            return;
        }
        if (target instanceof class_1657) {
            class_1657 player = (class_1657)target;
            if (player.method_6032() == player.method_6063()) {
                super.method_6114(target);
                return;
            }
            if (this.method_37908().method_8409().method_43056()) {
                MinecraftServer server = target.method_37908().method_8503();
                if (server == null) {
                    super.method_6114(target);
                    return;
                }
                server.execute(() -> {
                    int randomX = player.method_31477() + this.method_37908().method_8409().method_39332(-1500, 1500);
                    int randomZ = player.method_31479() + this.method_37908().method_8409().method_39332(-1500, 1500);
                    player.method_20620((double)randomX, (double)(player.method_37908().method_8497(class_4076.method_18675((int)randomX), class_4076.method_18675((int)randomZ)).method_12005(class_2902.class_2903.field_13203, randomX & 0xF, randomZ & 0xF) + 1), (double)randomZ);
                    Scheduler.get().runTaskLater(() -> player.method_5783(class_3417.field_14890, 1.0f, 2.0f), TaskStage.END_SERVER_TICK, TimeUnit.SECONDS, 2L);
                });
            } else {
                player.method_5643(LWADamageTypes.of(target.method_37908(), LWADamageTypes.ANGEL_NECK_SNAP), Math.max(20.0f, Float.MAX_VALUE * ((float)this.getBloodlust() / 100.0f)));
                this.method_5783(LWASounds.NECK_SNAP, 1.0f, 1.0f);
            }
        }
        super.method_6114(target);
    }

    public void method_5749(class_2487 nbt) {
        super.method_5749(nbt);
        if (nbt.method_10545(ANGEL_KEY)) {
            this.setAngel((Angel)AngelRegistry.getInstance().get(class_2960.method_12829((String)nbt.method_10558(ANGEL_KEY))));
        }
    }

    public void setAngel(Angel angel) {
        this.field_6011.method_12778(ANGEL, (Object)angel.id().toString());
    }

    public String getAngelData() {
        return (String)this.field_6011.method_12789(ANGEL);
    }

    public Angel getAngel() {
        return (Angel)AngelRegistry.getInstance().get(class_2960.method_12829((String)this.getAngelData()));
    }

    public int getBloodlust() {
        return (Integer)this.field_6011.method_12789(BLOODLUST);
    }

    public void addBloodlust(int amount) {
        int current = this.getBloodlust();
        int newValue = Math.min(100, Math.max(0, current + amount));
        this.field_6011.method_12778(BLOODLUST, (Object)newValue);
    }

    public void decayBloodlust() {
        int current = this.getBloodlust();
        if (current > 0) {
            this.field_6011.method_12778(BLOODLUST, (Object)(current - 1));
        }
    }

    protected class_1330 method_5963() {
        return new AngelBodyControl(this);
    }

    public class_4095<WeepingAngelEntity> method_18868() {
        return super.method_18868();
    }

    protected class_4095.class_5303<WeepingAngelEntity> method_28306() {
        return WeepingAngelBrain.createBrainProfile();
    }

    protected class_4095<?> method_18867(Dynamic<?> dynamic) {
        return WeepingAngelBrain.create((class_4095<WeepingAngelEntity>)this.method_28306().method_28335(dynamic));
    }

    public boolean method_5643(class_1282 damageSource, float amount) {
        class_1657 player;
        class_1799 stack;
        class_1297 class_12972 = damageSource.method_5526();
        if (class_12972 instanceof class_1657 && ((stack = (player = (class_1657)class_12972).method_6047()).method_7909() instanceof class_1810 || amount > 50000.0f)) {
            return super.method_5643(this.method_37908().method_48963().method_48822(), amount);
        }
        return false;
    }

    protected void method_5958() {
        class_3695 profiler = this.method_37908().method_16107();
        profiler.method_15396("angelBrain");
        this.method_18868().method_19542((class_3218)this.method_37908(), (class_1309)this);
        profiler.method_15407();
        WeepingAngelBrain.updateActivities(this);
    }

    public boolean method_5947() {
        return true;
    }

    protected void method_5712(class_2338 pos, class_2680 state) {
        this.method_5783(class_3417.field_16865, 0.2f, 1.0f);
    }

    public void method_6007() {
        if (!this.method_37908().field_9236) {
            if (this.method_5987() || !this.getAngelPose().equals((Object)AngelPose.MOVING)) {
                this.stopMovement();
            }
            boolean bl = (Boolean)this.field_6011.method_12789(ISNOTSTONE);
            boolean bl2 = this.shouldBeNotStone();
            if (bl2 != bl) {
                if (bl2) {
                    this.setAngelPose(AngelPose.MOVING);
                    this.method_5783(class_3417.field_15026, 0.5f, 1.0f);
                } else {
                    this.stopMovement();
                    this.method_5783(class_3417.field_14574, 0.5f, 0.1f);
                    this.method_18800(0.0, 0.0, 0.0);
                    this.setAngelPose(this.getRandomAngelPose());
                    if (this.isAngryEnough()) {
                        this.method_5783(class_3417.field_14792, 1.0f, 0.1f);
                    }
                    if (ServerLifecycleHooks.get().method_3780() % 20 == 0) {
                        this.addBloodlust(1);
                    }
                }
            }
            this.field_6011.method_12778(ISNOTSTONE, (Object)bl2);
        }
        super.method_6007();
    }

    protected class_3414 method_6011(class_1282 source) {
        return class_3417.field_14658;
    }

    public void stopMovement() {
        this.method_5942().method_6340();
        this.method_5938(0.0f);
        this.method_5976(0.0f);
        this.method_6125(0.0f);
    }

    public boolean method_5822() {
        return this.isNotStone();
    }

    public void method_6078(class_1282 damageSource) {
        super.method_6078(damageSource);
        class_1799 stack = new class_1799((class_1935)ANGEL_DROPS.get(this.method_37908().method_8409().method_39332(0, ANGEL_DROPS.size() - 1)));
        stack.method_7939(this.method_37908().method_8409().method_39332(1, 4));
        StackUtil.spawn(this.method_37908(), this.method_24515(), stack);
    }

    public boolean method_30948() {
        return !this.isNotStone();
    }

    private void extinguishNearbyLights() {
        class_238 area = new class_238(this.method_24515()).method_1014(5.0);
        class_2338 min = new class_2338((int)area.field_1323, (int)area.field_1322, (int)area.field_1321);
        class_2338 max = new class_2338((int)area.field_1320, (int)area.field_1325, (int)area.field_1324);
        for (class_2338 pos : class_2338.method_10097((class_2338)min, (class_2338)max)) {
            class_2248 block = this.method_37908().method_8320(pos).method_26204();
            if (!LIGHT_SOURCES.contains(block) || this.flickeringLights.containsKey(pos)) continue;
            this.flickeringLights.put(pos.method_10062(), 40);
            this.method_37908().method_8396(null, pos, class_3417.field_15102, class_3419.field_15245, 0.5f, 1.0f);
            break;
        }
    }

    private void processFlickeringLights() {
        Iterator<Map.Entry<class_2338, Integer>> iterator = this.flickeringLights.entrySet().iterator();
        while (iterator.hasNext()) {
            class_1937 class_19372;
            Map.Entry<class_2338, Integer> entry = iterator.next();
            class_2338 pos = entry.getKey();
            int ticksLeft = entry.getValue();
            if (ticksLeft <= 0) {
                if (this.method_37908().method_8320(pos).method_28498((class_2769)class_2746.method_11825((String)"lit"))) {
                    class_2680 state = this.method_37908().method_8320(pos);
                    this.method_37908().method_8501(pos, (class_2680)state.method_11657((class_2769)class_2746.method_11825((String)"lit"), (Comparable)Boolean.valueOf((Boolean)state.method_11654((class_2769)class_2746.method_11825((String)"lit")) == false)));
                } else {
                    this.method_37908().method_22352(pos, true);
                }
                iterator.remove();
                continue;
            }
            if (ticksLeft % 5 == 0 && (class_19372 = this.method_37908()) instanceof class_3218) {
                class_3218 serverWorld = (class_3218)class_19372;
                serverWorld.method_14199((class_2394)class_2398.field_11251, (double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.7, (double)pos.method_10260() + 0.5, 2, 0.1, 0.1, 0.1, 0.01);
            }
            entry.setValue(ticksLeft - 1);
        }
    }

    public boolean shouldBeNotStone() {
        class_4051 targetPredicate = class_4051.method_36625().method_18418(500.0);
        List players = this.method_37908().method_18466(class_1657.class, targetPredicate, (class_1309)this, this.method_5829().method_1014(1000.0));
        List angels = this.method_37908().method_18466(WeepingAngelEntity.class, targetPredicate, (class_1309)this, this.method_5829().method_1014(1000.0));
        boolean isActive = this.isActive();
        if (players.isEmpty() && angels.isEmpty()) {
            if (isActive) {
                this.deactivate();
            }
            return true;
        }
        for (WeepingAngelEntity angel : angels) {
            if (!this.method_18395((class_1309)angel) || this.getAngelPose().equals((Object)AngelPose.HIDING) && angel.getAngelPose().equals((Object)AngelPose.HIDING) || this.getAngelPose().equals((Object)AngelPose.RETREATING) && angel.getAngelPose().equals((Object)AngelPose.RETREATING) || this.method_5722((class_1297)angel) || !angel.isEntityLookingAtMe((class_1309)this, 1.0, false, this.method_23320(), this.method_23318() + 0.5 * (double)this.method_17825(), (this.method_23320() + this.method_23318()) / 2.0) || !this.isEntityLookingAtMe((class_1309)angel, 1.0, false, angel.method_23320(), angel.method_23318() + 0.5 * (double)angel.method_17825(), (angel.method_23320() + angel.method_23318()) / 2.0)) continue;
            if (this.isActive()) {
                if (this.method_6051().method_43056()) {
                    this.method_5783(class_3417.field_14958, 1.0f, 2.0f);
                } else {
                    angel.method_5783(class_3417.field_14958, 1.0f, 2.0f);
                }
            }
            this.deactivate();
            angel.deactivate();
            return false;
        }
        for (class_1309 entity : players) {
            boolean tooDarkToSee;
            if (!this.method_18395(entity) || this.method_5722((class_1297)entity)) continue;
            class_2338 entityPos = entity.method_24515();
            int lightLevel = this.method_37908().method_22339(entityPos);
            boolean bl = tooDarkToSee = lightLevel < 2;
            if (tooDarkToSee) {
                this.field_18321.method_18878(class_4140.field_22355, (Object)entity);
                this.deactivate();
                return true;
            }
            if (!isActive && NOT_WEARING_GAZE_DISGUISE_PREDICATE.test(entity) || !this.isEntityLookingAtMe(entity, 1.0, false, this.method_23320(), this.method_23318() + 0.5 * (double)this.method_17825(), (this.method_23320() + this.method_23318()) / 2.0)) continue;
            if (isActive) {
                return false;
            }
            if (entity.method_5858((class_1297)this) < 500.0) {
                if (entity instanceof class_1657) {
                    class_1657 player = (class_1657)entity;
                    this.activate(player);
                }
                return false;
            }
            this.field_18321.method_18878(class_4140.field_22355, (Object)entity);
            this.deactivate();
        }
        if (isActive) {
            this.deactivate();
        }
        return true;
    }

    public boolean isEntityLookingAtMe(class_1309 entity, double d, boolean bl, double ... checkedYs) {
        class_243 lookVec = entity.method_5828(1.0f).method_1029();
        for (double e : checkedYs) {
            class_243 toAngel = new class_243(this.method_23317() - entity.method_23317(), e - entity.method_23320(), this.method_23321() - entity.method_23321());
            double distance = toAngel.method_1033();
            double dot = lookVec.method_1026(toAngel = toAngel.method_1029());
            if (!(dot > Math.cos(Math.toRadians(90.0))) || !this.method_6057((class_1297)this)) continue;
            return true;
        }
        return false;
    }

    public boolean method_6057(class_1297 entity) {
        if (entity.method_37908() != this.method_37908()) {
            return false;
        }
        class_243 vec3d = new class_243(this.method_23317(), this.method_23320(), this.method_23321());
        class_243 vec3d2 = new class_243(entity.method_23317(), entity.method_23320(), entity.method_23321());
        return !(vec3d2.method_1022(vec3d) > 128.0) && this.method_37908().method_17742(new class_3959(vec3d, vec3d2, class_3959.class_3960.field_23142, class_3959.class_242.field_1348, (class_1297)this)).method_17783() == class_239.class_240.field_1333;
    }

    public void activate(class_1657 player) {
        if (!this.isActive()) {
            this.method_18868().method_18878(class_4140.field_22355, (Object)player);
            this.setAngelPose(AngelPose.MOVING);
            this.setActive(true);
        }
    }

    public double method_33191(class_1309 target) {
        return this.method_17681() * 2.0f * this.method_17681() * 2.0f + target.method_17681();
    }

    public void deactivate() {
        if (this.isActive()) {
            this.setActive(false);
        }
    }

    public AngelPose getRandomAngelPose() {
        AngelPose pose;
        if (this.method_6051().method_43057() < 0.7f) {
            return AngelPose.HIDING;
        }
        AngelPose[] poses = AngelPose.values();
        while ((pose = poses[this.method_6051().method_43048(poses.length)]) == AngelPose.HIDING && poses.length > 1) {
        }
        return pose;
    }

    public void setActive(boolean active) {
        this.field_6011.method_12778(ACTIVE, (Object)active);
    }

    public boolean isActive() {
        return (Boolean)this.field_6011.method_12789(ACTIVE);
    }

    public boolean method_5810() {
        return super.method_5810() && this.isNotStone();
    }

    public void method_5762(double deltaX, double deltaY, double deltaZ) {
        if (this.isNotStone()) {
            super.method_5762(deltaX, deltaY, deltaZ);
        }
    }

    public boolean isNotStone() {
        return (Boolean)this.field_6011.method_12789(ISNOTSTONE);
    }

    public AngelPose getAngelPose() {
        return (AngelPose)((Object)this.field_6011.method_12789(ANGEL_POSE));
    }

    public void setAngelPose(AngelPose pose) {
        this.field_6011.method_12778(ANGEL_POSE, (Object)pose);
    }

    public boolean isAngryEnough() {
        return this.getBloodlust() >= 70;
    }

    protected void method_5959() {
        super.method_5959();
        this.field_6201.method_6277(1, (class_1352)new BreakDoorGoal((class_1308)this));
    }

    static {
        class_2943.method_12720(ANGEL_POSES);
    }

    class AngelLookControl
    extends class_1333 {
        public AngelLookControl(WeepingAngelEntity angel) {
            super((class_1308)angel);
        }

        public void method_6231() {
            if (WeepingAngelEntity.this.isNotStone()) {
                super.method_6231();
            }
        }
    }

    class AngelMoveControl
    extends class_1335 {
        public AngelMoveControl(WeepingAngelEntity angel) {
            super((class_1308)angel);
        }

        public void method_6240() {
            if (WeepingAngelEntity.this.isNotStone()) {
                super.method_6240();
            }
        }
    }

    class AngelJumpControl
    extends class_1334 {
        public AngelJumpControl(WeepingAngelEntity angel) {
            super((class_1308)angel);
        }

        public void method_6234() {
            if (WeepingAngelEntity.this.isNotStone()) {
                super.method_6234();
            } else {
                WeepingAngelEntity.this.method_6100(false);
            }
        }
    }

    class AngelNavigation
    extends class_1409 {
        AngelNavigation(WeepingAngelEntity angel, class_1937 world) {
            super((class_1308)angel, world);
        }

        public void method_6360() {
            if (WeepingAngelEntity.this.isNotStone()) {
                super.method_6360();
            }
        }

        protected class_13 method_6336(int range) {
            this.field_6678 = new AngelLandPathNodeMaker();
            this.field_6678.method_15(true);
            return new class_13(this.field_6678, range);
        }
    }

    public static enum AngelPose {
        DEFAULT,
        MOVING,
        HIDING,
        ATTACKING,
        ANGRY,
        AFRAID,
        RETREATING;

    }

    class AngelBodyControl
    extends class_1330 {
        public AngelBodyControl(WeepingAngelEntity angel) {
            super((class_1308)angel);
        }

        public void method_6224() {
            if (WeepingAngelEntity.this.isNotStone()) {
                super.method_6224();
            }
        }
    }

    class BreakDoorGoal
    extends class_1339 {
        public BreakDoorGoal(class_1308 mobEntity) {
            super(mobEntity, 6, DOOR_BREAK_DIFFICULTY_CHECKER);
            this.method_6265(EnumSet.of(class_1352.class_4134.field_18405));
        }

        public boolean method_6266() {
            return WeepingAngelEntity.this.isNotStone() && super.method_6266();
        }

        public void method_6268() {
            if (WeepingAngelEntity.this.isNotStone()) {
                super.method_6268();
            }
        }

        public boolean method_6264() {
            return WeepingAngelEntity.this.isNotStone() && WeepingAngelEntity.this.field_5974.method_43048(BreakDoorGoal.method_38848((int)10)) == 0 && super.method_6264();
        }

        public void method_6269() {
            super.method_6269();
            this.field_6413.method_16826(0);
        }
    }

    class AngelLandPathNodeMaker
    extends class_14 {
        private static final int MAX_RANGE = 1024;

        AngelLandPathNodeMaker() {
        }

        public class_7 method_17(class_1922 world, int x, int y, int z) {
            return super.method_17(world, x, y, z);
        }
    }
}

