/*
 * Decompiled with CFR 0.152.
 */
package com.loqor.core.entities.brain.tasks;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_11;
import net.minecraft.class_1308;
import net.minecraft.class_1314;
import net.minecraft.class_1408;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_3218;
import net.minecraft.class_4095;
import net.minecraft.class_4097;
import net.minecraft.class_4102;
import net.minecraft.class_4115;
import net.minecraft.class_4140;
import net.minecraft.class_4141;
import net.minecraft.class_4142;
import net.minecraft.class_5532;
import org.jetbrains.annotations.Nullable;

public class MoveToTargetTask
extends class_4097<class_1308> {
    private static final int MAX_UPDATE_COUNTDOWN = 40;
    private int pathUpdateCountdownTicks;
    @Nullable
    private class_11 path;
    @Nullable
    private class_2338 lookTargetPos;
    private float speed;

    public MoveToTargetTask() {
        this(150, 250);
    }

    public MoveToTargetTask(int minRunTime, int maxRunTime) {
        super((Map)ImmutableMap.of((Object)class_4140.field_19293, (Object)class_4141.field_18458, (Object)class_4140.field_18449, (Object)class_4141.field_18457, (Object)class_4140.field_18445, (Object)class_4141.field_18456), minRunTime, maxRunTime);
    }

    protected boolean shouldRun(class_3218 serverWorld, class_1308 mobEntity) {
        if (this.pathUpdateCountdownTicks > 0) {
            --this.pathUpdateCountdownTicks;
            return false;
        }
        class_4095 brain = mobEntity.method_18868();
        class_4142 walkTarget = (class_4142)brain.method_18904(class_4140.field_18445).get();
        boolean bl = this.hasReached(mobEntity, walkTarget);
        if (!bl && this.hasFinishedPath(mobEntity, walkTarget, serverWorld.method_8510())) {
            this.lookTargetPos = walkTarget.method_19094().method_18989();
            return true;
        }
        brain.method_18875(class_4140.field_18445);
        if (bl) {
            brain.method_18875(class_4140.field_19293);
        }
        return false;
    }

    protected boolean shouldKeepRunning(class_3218 serverWorld, class_1308 mobEntity, long l) {
        if (this.path != null && this.lookTargetPos != null) {
            Optional optional = mobEntity.method_18868().method_18904(class_4140.field_18445);
            boolean bl = optional.map(MoveToTargetTask::isTargetSpectator).orElse(false);
            class_1408 entityNavigation = mobEntity.method_5942();
            return !entityNavigation.method_6357() && optional.isPresent() && !this.hasReached(mobEntity, (class_4142)optional.get()) && !bl;
        }
        return false;
    }

    protected void finishRunning(class_3218 serverWorld, class_1308 mobEntity, long l) {
        if (mobEntity.method_18868().method_18896(class_4140.field_18445) && !this.hasReached(mobEntity, (class_4142)mobEntity.method_18868().method_18904(class_4140.field_18445).get()) && mobEntity.method_5942().method_31267()) {
            this.pathUpdateCountdownTicks = serverWorld.method_8409().method_43048(40);
        }
        mobEntity.method_5942().method_6340();
        mobEntity.method_18868().method_18875(class_4140.field_18445);
        mobEntity.method_18868().method_18875(class_4140.field_18449);
        this.path = null;
    }

    protected void run(class_3218 serverWorld, class_1308 mobEntity, long l) {
        mobEntity.method_18868().method_18878(class_4140.field_18449, (Object)this.path);
        mobEntity.method_5942().method_6334(this.path, (double)this.speed);
    }

    protected void keepRunning(class_3218 serverWorld, class_1308 mobEntity, long l) {
        class_4142 walkTarget;
        class_11 path = mobEntity.method_5942().method_6345();
        class_4095 brain = mobEntity.method_18868();
        if (this.path != path) {
            this.path = path;
            brain.method_18878(class_4140.field_18449, (Object)path);
        }
        if (path != null && this.lookTargetPos != null && (walkTarget = (class_4142)brain.method_18904(class_4140.field_18445).get()).method_19094().method_18989().method_10262((class_2382)this.lookTargetPos) > 4.0 && this.hasFinishedPath(mobEntity, walkTarget, serverWorld.method_8510())) {
            this.lookTargetPos = walkTarget.method_19094().method_18989();
            this.run(serverWorld, mobEntity, l);
        }
    }

    private boolean hasFinishedPath(class_1308 entity, class_4142 walkTarget, long time) {
        class_2338 blockPos = walkTarget.method_19094().method_18989();
        this.path = entity.method_5942().method_6348(blockPos, 0);
        this.speed = walkTarget.method_19095();
        class_4095 brain = entity.method_18868();
        if (this.hasReached(entity, walkTarget)) {
            brain.method_18875(class_4140.field_19293);
        } else {
            boolean bl;
            boolean bl2 = bl = this.path != null && this.path.method_21655();
            if (bl) {
                brain.method_18875(class_4140.field_19293);
            } else if (!brain.method_18896(class_4140.field_19293)) {
                brain.method_18878(class_4140.field_19293, (Object)time);
            }
            if (this.path != null) {
                return true;
            }
            class_243 vec3d = class_5532.method_31512((class_1314)((class_1314)entity), (int)10, (int)7, (class_243)class_243.method_24955((class_2382)blockPos), (double)1.5707963705062866);
            if (vec3d != null) {
                this.path = entity.method_5942().method_6352(vec3d.field_1352, vec3d.field_1351, vec3d.field_1350, 0);
                return this.path != null;
            }
        }
        return false;
    }

    private boolean hasReached(class_1308 entity, class_4142 walkTarget) {
        return walkTarget.method_19094().method_18989().method_19455((class_2382)entity.method_24515()) <= walkTarget.method_19096();
    }

    private static boolean isTargetSpectator(class_4142 target) {
        class_4102 entityLookTarget;
        class_4115 class_41152 = target.method_19094();
        return class_41152 instanceof class_4102 && (entityLookTarget = (class_4102)class_41152).method_35066().method_7325();
    }
}

