/*
 * Decompiled with CFR 0.152.
 */
package com.zhenshiz.chatbox.client;

import com.zhenshiz.chatbox.client.ChatBoxClient;
import com.zhenshiz.chatbox.event.fabric.InputEvent;
import com.zhenshiz.chatbox.network.s2c.ChatBoxPayload;
import com.zhenshiz.chatbox.render.ChatBoxRenderCommon;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.client.rendering.v1.HudRenderCallback;
import net.minecraft.class_2960;

public class ChatBoxClientFabric
implements ClientModInitializer {
    public void onInitializeClient() {
        ChatBoxClient.init();
        ChatBoxClientFabric.registerClientHandlers();
        this.registerRenderEvents();
    }

    public static void registerClientHandlers() {
        ClientPlayNetworking.registerGlobalReceiver((class_2960)ChatBoxPayload.OpenScreen.ID, (client, h, buf, r) -> ChatBoxPayload.OpenScreen.handleOnClient(ChatBoxPayload.OpenScreen.decode(buf)));
        ClientPlayNetworking.registerGlobalReceiver((class_2960)ChatBoxPayload.AllChatBoxThemeToClient.ID, (client, h, buf, r) -> ChatBoxPayload.AllChatBoxThemeToClient.handleOnClient(ChatBoxPayload.AllChatBoxThemeToClient.decode(buf)));
        ClientPlayNetworking.registerGlobalReceiver((class_2960)ChatBoxPayload.AllChatBoxDialoguesToClient.ID, (client, h, buf, r) -> ChatBoxPayload.AllChatBoxDialoguesToClient.handleOnClient(ChatBoxPayload.AllChatBoxDialoguesToClient.decode(buf)));
        ClientPlayNetworking.registerGlobalReceiver((class_2960)ChatBoxPayload.SimplePayload.ID, (client, h, buf, r) -> ChatBoxPayload.SimplePayload.handleOnClient(ChatBoxPayload.SimplePayload.decode(buf)));
    }

    private void registerRenderEvents() {
        HudRenderCallback.EVENT.register(ChatBoxRenderCommon::onHudRender);
        ClientTickEvents.END_CLIENT_TICK.register(ChatBoxRenderCommon::onEndTick);
        InputEvent.KEY.register(ChatBoxRenderCommon::onKey);
        InputEvent.MouseButton.POST.register(ChatBoxRenderCommon::mousePost);
        InputEvent.MOUSE_SCROLLING.register(ChatBoxRenderCommon::onMouseScroll);
    }
}

