/*
 * Decompiled with CFR 0.152.
 */
package com.zhenshiz.chatbox.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.zhenshiz.chatbox.ChatBox;
import com.zhenshiz.chatbox.data.ChatBoxDialoguesLoader;
import com.zhenshiz.chatbox.data.ChatBoxThemeLoader;
import com.zhenshiz.chatbox.data.ChatBoxTriggerCount;
import com.zhenshiz.chatbox.network.s2c.ChatBoxPayload;
import com.zhenshiz.chatbox.utils.chatbox.ChatBoxCommandUtil;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2172;
import net.minecraft.class_2232;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_7157;

public class ChatBoxCommand {
    public static final class_2561 ERROR_ENTITY_ONLY = class_2561.method_43471((String)"command.target.entity.only");
    public static final class_2561 ERROR_PLAYER_ONLY = class_2561.method_43471((String)"command.target.player.only");

    public static void register(CommandDispatcher<class_2168> dispatcher, class_7157 buildContext, class_2170.class_5364 commandSelection) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"chatbox").requires(commandSourceStack -> commandSourceStack.method_9259(2))).then(class_2170.method_9247((String)"theme").then(class_2170.method_9244((String)"Theme", (ArgumentType)class_2232.method_9441()).suggests((context, builder) -> class_2172.method_9270(ChatBoxThemeLoader.themeMap.keySet(), (SuggestionsBuilder)builder)).executes(ChatBoxCommand::toggleTheme)))).then(class_2170.method_9247((String)"skip").then(class_2170.method_9244((String)"Dialogues", (ArgumentType)class_2232.method_9441()).suggests((context, builder) -> class_2172.method_9270(ChatBoxDialoguesLoader.dialoguesMap.keySet(), (SuggestionsBuilder)builder)).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"Group", (ArgumentType)StringArgumentType.string()).suggests((context, builder) -> {
            class_2960 dialogues = class_2232.method_9443((CommandContext)context, (String)"Dialogues");
            ChatBoxDialoguesLoader.dialoguesGroupMap.get(dialogues).forEach(arg_0 -> ((SuggestionsBuilder)builder).suggest(arg_0));
            return builder.buildFuture();
        }).executes(context -> ChatBoxCommand.skipDialogues((CommandContext<class_2168>)context, 0))).then(class_2170.method_9244((String)"Index", (ArgumentType)IntegerArgumentType.integer()).executes(context -> ChatBoxCommand.skipDialogues((CommandContext<class_2168>)context, IntegerArgumentType.getInteger((CommandContext)context, (String)"Index")))))))).then(class_2170.method_9247((String)"open").executes(ChatBoxCommand::openChatBox))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"maxTriggerCount").then(class_2170.method_9244((String)"Dialogues", (ArgumentType)class_2232.method_9441()).suggests((context, builder) -> class_2172.method_9270(ChatBoxDialoguesLoader.dialoguesMap.keySet(), (SuggestionsBuilder)builder)).then(class_2170.method_9244((String)"MaxTriggerCount", (ArgumentType)IntegerArgumentType.integer()).executes(ChatBoxCommand::setMaxTriggerCount)))).then(class_2170.method_9247((String)"reset").executes(ChatBoxCommand::resetMaxTriggerCount)))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"command").then(class_2170.method_9247((String)"nextDialogue").executes(ChatBoxCommand::nextDialogue))).then(class_2170.method_9247((String)"autoPlay").then(class_2170.method_9244((String)"AutoPlay", (ArgumentType)BoolArgumentType.bool()).executes(ChatBoxCommand::autoPlay)))).then(class_2170.method_9247((String)"isScreen").then(class_2170.method_9244((String)"IsScreen", (ArgumentType)BoolArgumentType.bool()).executes(ChatBoxCommand::setIsScreen)))));
    }

    private static int setIsScreen(CommandContext<class_2168> context) {
        boolean isScreen = BoolArgumentType.getBool(context, (String)"IsScreen");
        class_3222 player = ((class_2168)context.getSource()).method_44023();
        if (player != null) {
            ChatBox.PLATFORM.sendToClient(player, new ChatBoxPayload.SimplePayload("set_is_screen", String.valueOf(isScreen)));
            return 1;
        }
        ((class_2168)context.getSource()).method_9213(ERROR_PLAYER_ONLY);
        return 0;
    }

    private static int autoPlay(CommandContext<class_2168> context) {
        boolean autoPlay = BoolArgumentType.getBool(context, (String)"AutoPlay");
        class_3222 player = ((class_2168)context.getSource()).method_44023();
        if (player != null) {
            ChatBox.PLATFORM.sendToClient(player, new ChatBoxPayload.SimplePayload("auto_play", String.valueOf(autoPlay)));
            return 1;
        }
        ((class_2168)context.getSource()).method_9213(ERROR_PLAYER_ONLY);
        return 0;
    }

    private static int nextDialogue(CommandContext<class_2168> context) {
        class_3222 player = ((class_2168)context.getSource()).method_44023();
        if (player != null) {
            ChatBox.PLATFORM.sendToClient(player, new ChatBoxPayload.SimplePayload("next_dialogue", ""));
            return 1;
        }
        ((class_2168)context.getSource()).method_9213(ERROR_PLAYER_ONLY);
        return 0;
    }

    private static int toggleTheme(CommandContext<class_2168> context) {
        class_2960 theme = class_2232.method_9443(context, (String)"Theme");
        class_3222 player = ((class_2168)context.getSource()).method_44023();
        if (player != null) {
            ChatBoxCommandUtil.serverToggleTheme(player, theme);
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43471((String)"commands.toggle.theme"), true);
            return 1;
        }
        ((class_2168)context.getSource()).method_9213(ERROR_PLAYER_ONLY);
        return 0;
    }

    private static int skipDialogues(CommandContext<class_2168> context, int index) {
        class_2960 dialogues = class_2232.method_9443(context, (String)"Dialogues");
        String group = StringArgumentType.getString(context, (String)"Group");
        class_3222 player = ((class_2168)context.getSource()).method_44023();
        if (player != null) {
            ChatBoxTriggerCount counts = ChatBox.getTriggerCounts();
            int count = counts.getPlayerMaxTriggerCount(player, dialogues);
            if (count != 0) {
                counts.setPlayerMaxTriggerCount(player, dialogues, count - 1);
                ChatBoxCommandUtil.serverSkipDialogues(player, dialogues, group, index);
                ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43469((String)"commands.skip.dialogues", (Object[])new Object[]{group, index + 1}), true);
            }
            return 1;
        }
        ((class_2168)context.getSource()).method_9213(ERROR_PLAYER_ONLY);
        return 0;
    }

    private static int openChatBox(CommandContext<class_2168> context) {
        class_3222 player = ((class_2168)context.getSource()).method_44023();
        if (player != null) {
            ChatBoxCommandUtil.serverOpenChatBox(player);
            return 1;
        }
        ((class_2168)context.getSource()).method_9213(ERROR_PLAYER_ONLY);
        return 0;
    }

    private static int setMaxTriggerCount(CommandContext<class_2168> context) {
        class_3222 player = ((class_2168)context.getSource()).method_44023();
        if (player != null) {
            class_2960 dialogues = class_2232.method_9443(context, (String)"Dialogues");
            int maxTriggerCount = IntegerArgumentType.getInteger(context, (String)"MaxTriggerCount");
            ChatBox.getTriggerCounts().setPlayerMaxTriggerCount(player, dialogues, maxTriggerCount);
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43469((String)"commands.set.max.trigger.count", (Object[])new Object[]{dialogues.toString(), maxTriggerCount}), true);
            return 1;
        }
        ((class_2168)context.getSource()).method_9213(ERROR_PLAYER_ONLY);
        return 0;
    }

    private static int resetMaxTriggerCount(CommandContext<class_2168> context) {
        class_3222 player = ((class_2168)context.getSource()).method_44023();
        if (player != null) {
            ChatBox.getTriggerCounts().resetPlayerMaxTriggerCount(player);
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43471((String)"commands.reset.max.trigger.count"), true);
            return 1;
        }
        ((class_2168)context.getSource()).method_9213(ERROR_PLAYER_ONLY);
        return 0;
    }
}

