/*
 * Decompiled with CFR 0.152.
 */
package com.zhenshiz.chatbox.component;

import com.zhenshiz.chatbox.ChatBox;
import com.zhenshiz.chatbox.api.ChatOptionClickEvent;
import com.zhenshiz.chatbox.component.AbstractComponent;
import com.zhenshiz.chatbox.utils.chatbox.ChatBoxUtil;
import com.zhenshiz.chatbox.utils.chatbox.RenderUtil;
import com.zhenshiz.chatbox.utils.common.StrUtil;
import net.minecraft.class_241;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_4587;

public class ChatOption
extends AbstractComponent<ChatOption> {
    public class_2960 texture;
    public class_2960 selectTexture;
    public class_2960 lockTexture;
    public class_2561 optionChat;
    public float optionChatX;
    public float optionChatY;
    public Runnable onClickEvent;
    public boolean isLock;
    public class_2561 optionTooltip;
    public TextAlign textAlign;
    public String next;
    public boolean isSelect;

    public ChatOption() {
        this.setTextures(ChatBox.ResourceLocationMod("textures/options/default_no_checked_option.png"));
        this.setSelectTexture(ChatBox.ResourceLocationMod("textures/options/default_checked_option.png"));
        this.setLockTexture(ChatBox.ResourceLocationMod("textures/options/default_no_checked_option.png"));
        this.setOptionChat("", false);
        this.setOptionChatPosition(0.0f, 0.0f);
        this.setClickEvent(() -> {});
        this.setIsLock(false);
        this.setOptionTooltip("", false);
        this.setTextAlign(TextAlign.LEFT);
        this.setNext("");
        this.setIsSelect(false);
    }

    public ChatOption setOptionChat(String optionChat, boolean isTranslatable) {
        if (optionChat != null) {
            this.optionChat = isTranslatable ? class_2561.method_43471((String)optionChat) : class_2561.method_30163((String)optionChat);
        }
        return this;
    }

    public ChatOption setOptionTooltip(String optionTooltip, boolean isTranslatable) {
        if (optionTooltip != null) {
            this.optionTooltip = isTranslatable ? class_2561.method_43471((String)optionTooltip) : class_2561.method_30163((String)optionTooltip);
        }
        return this;
    }

    public ChatOption setTextures(class_2960 textures) {
        if (textures != null) {
            this.texture = textures;
        }
        return this;
    }

    public ChatOption setTextures(String textures) {
        if (textures != null) {
            return this.setTextures(class_2960.method_12829((String)textures));
        }
        return this;
    }

    public ChatOption setSelectTexture(class_2960 selectTexture) {
        if (selectTexture != null) {
            this.selectTexture = selectTexture;
        }
        return this;
    }

    public ChatOption setSelectTexture(String selectTexture) {
        if (selectTexture != null) {
            return this.setSelectTexture(class_2960.method_12829((String)selectTexture));
        }
        return this;
    }

    public ChatOption setLockTexture(class_2960 lockTexture) {
        if (lockTexture != null) {
            this.lockTexture = lockTexture;
        }
        return this;
    }

    public ChatOption setLockTexture(String lockTexture) {
        if (lockTexture != null) {
            return this.setLockTexture(class_2960.method_12829((String)lockTexture));
        }
        return this;
    }

    public ChatOption setClickEvent(Runnable onClickEvent) {
        if (onClickEvent != null) {
            this.onClickEvent = onClickEvent;
        }
        return this;
    }

    public ChatOption setClickEvent(String type, String value) {
        if (type != null) {
            this.onClickEvent = () -> {
                if (ChatOption.minecraft.field_1724 != null && ChatOptionClickEvent.CLICK_EVENTS.containsKey(type.toUpperCase())) {
                    ChatOptionClickEvent.CLICK_EVENTS.get(type.toUpperCase()).execute(value == null ? "" : value);
                }
            };
        }
        return this;
    }

    public ChatOption setIsLock(boolean isLock) {
        this.isLock = isLock;
        return this;
    }

    public ChatOption setNext(String next) {
        if (next != null) {
            this.next = next;
        }
        return this;
    }

    public ChatOption setOptionChatPosition(float x, float y) {
        this.optionChatX = x;
        this.optionChatY = y;
        return this;
    }

    public ChatOption setTextAlign(TextAlign textAlign) {
        if (textAlign != null) {
            this.textAlign = textAlign;
        }
        return this;
    }

    public ChatOption setIsSelect(boolean isSelect) {
        this.isSelect = isSelect;
        return this;
    }

    public void click() {
        if (!this.isLock && ChatOption.minecraft.field_1724 != null) {
            this.onClickEvent.run();
            if (StrUtil.isEmpty(this.next)) {
                ChatBoxUtil.skipDialogues(ChatBoxUtil.dialoguesResourceLocation, ChatBoxUtil.group, ChatBoxUtil.index + 1);
            } else if (StrUtil.isInteger(this.next)) {
                int index = Integer.parseInt(this.next);
                ChatBoxUtil.skipDialogues(ChatBoxUtil.dialoguesResourceLocation, ChatBoxUtil.group, index);
            } else {
                ChatBoxUtil.skipDialogues(ChatBoxUtil.dialoguesResourceLocation, this.next);
            }
        }
    }

    @Override
    public void render(class_332 guiGraphics, int mouseX, int mouseY, float pPartialTick) {
        class_241 pos = this.getCurrentPosition();
        float x = pos.field_1343;
        float y = pos.field_1342;
        int color = -1;
        class_2960 texture = this.texture;
        if (this.isLock) {
            texture = this.lockTexture;
            color = -6250336;
        } else if (this.isSelect(mouseX, mouseY)) {
            texture = this.selectTexture;
            color = -256;
        }
        this.renderInCommon(guiGraphics, texture, color, x, y);
        if (!this.optionTooltip.getString().isEmpty() && this.isSelect(mouseX, mouseY)) {
            guiGraphics.method_51438(ChatOption.minecraft.field_1772, this.optionTooltip, mouseX, mouseY);
        }
    }

    @Override
    public void render(class_332 guiGraphics, float pPartialTick) {
        class_241 pos = this.getCurrentPosition();
        float x = pos.field_1343;
        float y = pos.field_1342;
        int color = -1;
        class_2960 texture = this.texture;
        if (this.isLock) {
            texture = this.lockTexture;
            color = -6250336;
        } else if (this.isSelect) {
            texture = this.selectTexture;
            color = -256;
        }
        this.renderInCommon(guiGraphics, texture, color, x, y);
    }

    private void renderInCommon(class_332 guiGraphics, class_2960 texture, int color, float x, float y) {
        if (texture != null) {
            this.renderImage(guiGraphics, texture);
        }
        class_4587 poseStack = guiGraphics.method_51448();
        poseStack.method_22903();
        switch (this.textAlign) {
            case LEFT: {
                RenderUtil.drawLeftScaleText(guiGraphics, class_2561.method_30163((String)this.parseText(this.optionChat.getString())), (int)ChatOption.getResponsiveWidth(x + this.width / 2.0f + this.optionChatX), (int)ChatOption.getResponsiveHeight(y + this.height / 2.0f + this.optionChatY), 1.0f, false, color);
                break;
            }
            case CENTER: {
                RenderUtil.drawCenterScaleText(guiGraphics, class_2561.method_30163((String)this.parseText(this.optionChat.getString())), (int)ChatOption.getResponsiveWidth(x + this.width / 2.0f + this.optionChatX), (int)ChatOption.getResponsiveHeight(y + this.height / 2.0f + this.optionChatY), 1.0f, false, color);
                break;
            }
            case RIGHT: {
                RenderUtil.drawRightScaleText(guiGraphics, class_2561.method_30163((String)this.parseText(this.optionChat.getString())), (int)ChatOption.getResponsiveWidth(x + this.width / 2.0f + this.optionChatX), (int)ChatOption.getResponsiveHeight(y + this.height / 2.0f + this.optionChatY), 1.0f, false, color);
            }
        }
        poseStack.method_22909();
    }

    public static enum TextAlign {
        LEFT,
        CENTER,
        RIGHT;


        public static TextAlign of(String text) {
            if (text == null) {
                return LEFT;
            }
            return TextAlign.valueOf(text.toUpperCase());
        }
    }
}

