/*
 * Decompiled with CFR 0.152.
 */
package com.zhenshiz.chatbox.data;

import com.google.common.reflect.TypeToken;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.zhenshiz.chatbox.ChatBox;
import com.zhenshiz.chatbox.data.ChatBoxDialogues;
import com.zhenshiz.chatbox.data.ChatBoxTriggerCount;
import com.zhenshiz.chatbox.network.s2c.ChatBoxPayload;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.class_175;
import net.minecraft.class_184;
import net.minecraft.class_195;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3300;
import net.minecraft.class_3695;
import net.minecraft.class_4309;
import net.minecraft.class_5257;
import net.minecraft.class_60;
import org.jetbrains.annotations.NotNull;

public class ChatBoxDialoguesLoader
extends class_4309 {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    public static final ChatBoxDialoguesLoader INSTANCE = new ChatBoxDialoguesLoader();
    public static final Map<class_2960, String> dialoguesMap = new HashMap<class_2960, String>();
    public static final Map<class_2960, Set<String>> dialoguesGroupMap = new HashMap<class_2960, Set<String>>();
    private static final Map<class_2960, Map<String, Map<String, class_175>>> dialoguesCriteriaMap = new HashMap<class_2960, Map<String, Map<String, class_175>>>();
    public static final Map<class_2960, Integer> defaultMaxTriggerCount = new HashMap<class_2960, Integer>();
    private static final class_60 lootDataManager = new class_60();

    public ChatBoxDialoguesLoader() {
        super(GSON, "chatbox/dialogues");
    }

    protected void apply(@NotNull Map<class_2960, JsonElement> resourceLocationJsonElementMap, @NotNull class_3300 resourceManager, @NotNull class_3695 profilerFiller) {
        dialoguesMap.clear();
        dialoguesGroupMap.clear();
        dialoguesCriteriaMap.clear();
        defaultMaxTriggerCount.clear();
        resourceLocationJsonElementMap.forEach((resourceLocation, jsonElement) -> dialoguesMap.put((class_2960)resourceLocation, jsonElement.toString()));
        ChatBoxDialoguesLoader.setDialogues();
    }

    public static <T extends class_195> void triggerDialog(class_3222 player, Predicate<T> testTrigger) {
        for (Map.Entry<class_2960, Map<String, Map<String, class_175>>> entry : dialoguesCriteriaMap.entrySet()) {
            class_2960 rl = entry.getKey();
            Map<String, Map<String, class_175>> groupWithCriteria = entry.getValue();
            for (Map.Entry<String, Map<String, class_175>> entry1 : groupWithCriteria.entrySet()) {
                String group = entry1.getKey();
                Map<String, class_175> criteria = entry1.getValue();
                for (Map.Entry<String, class_175> entry2 : criteria.entrySet()) {
                    class_175 criterion = entry2.getValue();
                    class_184 instance = criterion.method_774();
                    try {
                        ChatBoxTriggerCount counts;
                        int count;
                        class_195 t = (class_195)instance;
                        if (!testTrigger.test(t) || (count = (counts = ChatBox.getTriggerCounts()).getPlayerMaxTriggerCount(player, rl)) == 0) continue;
                        counts.setPlayerMaxTriggerCount(player, rl, count - 1);
                        ChatBox.PLATFORM.sendToClient(player, new ChatBoxPayload.OpenScreen(rl, group, 0));
                    }
                    catch (ClassCastException classCastException) {}
                }
            }
        }
    }

    private static void setDialogues() {
        dialoguesMap.forEach((resourceLocation, str) -> {
            JsonElement jsonElement = (JsonElement)GSON.fromJson(str, JsonElement.class);
            if (jsonElement == null) {
                return;
            }
            JsonElement dialoguesElement = jsonElement.getAsJsonObject().get("dialogues");
            if (dialoguesElement != null) {
                ChatBoxDialogues chatBoxDialogues = (ChatBoxDialogues)GSON.fromJson(jsonElement, new TypeToken<ChatBoxDialogues>(){}.getType());
                dialoguesGroupMap.put((class_2960)resourceLocation, chatBoxDialogues.dialogues.keySet());
                JsonElement maxTriggerCountElement = jsonElement.getAsJsonObject().get("maxTriggerCount");
                int maxTriggerCount = maxTriggerCountElement != null ? maxTriggerCountElement.getAsInt() : -1;
                defaultMaxTriggerCount.put((class_2960)resourceLocation, maxTriggerCount);
                JsonElement criteriaElement = jsonElement.getAsJsonObject().get("criteria");
                if (criteriaElement != null) {
                    JsonObject criteriaObject = criteriaElement.getAsJsonObject();
                    String group = (String)dialoguesGroupMap.get(resourceLocation).stream().toList().get(0);
                    try {
                        Map criteria = class_175.method_772((JsonObject)criteriaObject, (class_5257)new class_5257(resourceLocation, lootDataManager));
                        HashMap<String, Map> groupCriteriaMap = new HashMap<String, Map>();
                        groupCriteriaMap.put(group, criteria);
                        dialoguesCriteriaMap.put((class_2960)resourceLocation, (Map<String, Map<String, class_175>>)groupCriteriaMap);
                    }
                    catch (Exception var6x) {
                        ChatBox.LOGGER.error("Parsing error loading dialog {}: {}", resourceLocation, (Object)var6x.getMessage());
                    }
                }
            }
        });
    }
}

