/*
 * Decompiled with CFR 0.152.
 */
package com.zhenshiz.chatbox.network.s2c;

import com.zhenshiz.chatbox.ChatBox;
import com.zhenshiz.chatbox.network.CustomPacket;
import com.zhenshiz.chatbox.utils.chatbox.ChatBoxCommandUtil;
import com.zhenshiz.chatbox.utils.chatbox.ChatBoxUtil;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.class_2540;
import net.minecraft.class_2960;

public class ChatBoxPayload {
    private static Map<class_2960, String> mergeString(Map<class_2960, List<String>> map) {
        HashMap<class_2960, String> result = new HashMap<class_2960, String>();
        for (Map.Entry<class_2960, List<String>> entry : map.entrySet()) {
            class_2960 rl = entry.getKey();
            List<String> parts = entry.getValue();
            StringBuilder builder = new StringBuilder();
            for (String part : parts) {
                builder.append(part);
            }
            result.put(rl, builder.toString());
        }
        return result;
    }

    public record SimplePayload(String name, String value) implements CustomPacket
    {
        public static final class_2960 ID = ChatBox.ResourceLocationMod("simple_payload");
        private static final Map<String, Consumer<String>> handlers = new HashMap<String, Consumer<String>>();

        @Override
        public class_2960 id() {
            return ID;
        }

        @Override
        public void write(class_2540 buf) {
            SimplePayload.encode(this, buf);
        }

        public static void encode(SimplePayload packet, class_2540 buf) {
            buf.method_10814(packet.name);
            buf.method_10814(packet.value);
        }

        public static SimplePayload decode(class_2540 buf) {
            return new SimplePayload(buf.method_19772(), buf.method_19772());
        }

        public static void handleOnClient(SimplePayload packet) {
            ChatBox.PLATFORM.runOnClient(() -> {
                if (handlers.containsKey(packet.name)) {
                    handlers.get(packet.name).accept(packet.value);
                }
            });
        }

        static {
            handlers.put("open_dialog", s -> ChatBoxCommandUtil.clientOpenChatBox());
            handlers.put("set_theme", ChatBoxCommandUtil::clientToggleTheme);
            handlers.put("next_dialogue", s -> ChatBoxCommandUtil.clientNextDialogue());
            handlers.put("auto_play", s -> ChatBoxCommandUtil.clientAutoPlay(Boolean.parseBoolean(s)));
            handlers.put("set_is_screen", s -> ChatBoxCommandUtil.clientSetIsScreen(Boolean.parseBoolean(s)));
        }
    }

    public record AllChatBoxDialoguesToClient(Map<class_2960, List<String>> dialoguesMap) implements CustomPacket
    {
        public static final class_2960 ID = ChatBox.ResourceLocationMod("all_chat_box_dialogues_to_client");

        @Override
        public class_2960 id() {
            return ID;
        }

        @Override
        public void write(class_2540 buf) {
            AllChatBoxDialoguesToClient.encode(this, buf);
        }

        public static void encode(AllChatBoxDialoguesToClient packet, class_2540 buf) {
            buf.method_34063(packet.dialoguesMap, class_2540::method_10812, (vBuf, v) -> vBuf.method_34062((Collection)v, class_2540::method_10814));
        }

        public static AllChatBoxDialoguesToClient decode(class_2540 buf) {
            return new AllChatBoxDialoguesToClient(buf.method_34067(class_2540::method_10810, v -> v.method_34066(class_2540::method_19772)));
        }

        public static void handleOnClient(AllChatBoxDialoguesToClient packet) {
            ChatBox.PLATFORM.runOnClient(() -> ChatBoxUtil.setDialogues(ChatBoxPayload.mergeString(packet.dialoguesMap)));
        }
    }

    public record AllChatBoxThemeToClient(Map<class_2960, List<String>> themeMap) implements CustomPacket
    {
        public static final class_2960 ID = ChatBox.ResourceLocationMod("all_chat_box_theme_to_client");

        @Override
        public class_2960 id() {
            return ID;
        }

        @Override
        public void write(class_2540 buf) {
            AllChatBoxThemeToClient.encode(this, buf);
        }

        public static void encode(AllChatBoxThemeToClient packet, class_2540 buf) {
            buf.method_34063(packet.themeMap, class_2540::method_10812, (vBuf, v) -> vBuf.method_34062((Collection)v, class_2540::method_10814));
        }

        public static AllChatBoxThemeToClient decode(class_2540 buf) {
            return new AllChatBoxThemeToClient(buf.method_34067(class_2540::method_10810, v -> v.method_34066(class_2540::method_19772)));
        }

        public static void handleOnClient(AllChatBoxThemeToClient packet) {
            ChatBox.PLATFORM.runOnClient(() -> {
                class_2960 theme;
                ChatBoxUtil.setTheme(ChatBoxPayload.mergeString(packet.themeMap));
                if (ChatBoxUtil.themeResourceLocation != null && (theme = class_2960.method_12829((String)ChatBoxUtil.themeResourceLocation)) != null) {
                    ChatBoxUtil.toggleTheme(theme);
                }
            });
        }
    }

    public record OpenScreen(class_2960 dialogues, String group, int index) implements CustomPacket
    {
        public static final class_2960 ID = ChatBox.ResourceLocationMod("open_screen");

        @Override
        public class_2960 id() {
            return ID;
        }

        @Override
        public void write(class_2540 buf) {
            OpenScreen.encode(this, buf);
        }

        public static void encode(OpenScreen packet, class_2540 buf) {
            buf.method_10812(packet.dialogues);
            buf.method_10814(packet.group);
            buf.writeInt(packet.index);
        }

        public static OpenScreen decode(class_2540 buf) {
            return new OpenScreen(buf.method_10810(), buf.method_19772(), buf.readInt());
        }

        public static void handleOnClient(OpenScreen packet) {
            ChatBox.PLATFORM.runOnClient(() -> ChatBoxCommandUtil.clientSkipDialogues(packet.dialogues, packet.group, packet.index));
        }
    }
}

