/*
 * Decompiled with CFR 0.152.
 */
package com.zhenshiz.chatbox.render;

import com.zhenshiz.chatbox.component.AbstractComponent;
import com.zhenshiz.chatbox.utils.chatbox.ChatBoxUtil;
import com.zhenshiz.chatbox.utils.chatbox.RenderUtil;
import com.zhenshiz.chatbox.utils.common.BeanUtil;
import java.util.Objects;
import net.minecraft.class_241;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;

public class KeyPromptRender
extends AbstractComponent<KeyPromptRender> {
    public Boolean visible;
    public Float mouseTextureWidth;
    public Float mouseTextureHeight;
    public class_2960 rightClickTexture;
    public class_2960 scrollTexture;

    public KeyPromptRender setMouseTextureSize(Float width, Float height) {
        if (width != null) {
            this.mouseTextureWidth = width;
        }
        if (height != null) {
            this.mouseTextureHeight = height;
        }
        return this;
    }

    public KeyPromptRender setVisible(Boolean visible) {
        if (visible != null) {
            this.visible = visible;
        }
        return this;
    }

    public KeyPromptRender setRightClickTexture(String rightClickTexture) {
        if (rightClickTexture != null) {
            this.rightClickTexture = new class_2960(rightClickTexture);
        }
        return this;
    }

    public KeyPromptRender setScrollTexture(String scrollTexture) {
        if (scrollTexture != null) {
            this.scrollTexture = new class_2960(scrollTexture);
        }
        return this;
    }

    @Override
    public void render(class_332 guiGraphics, float pPartialTick) {
        if (this.visible.booleanValue()) {
            RenderUtil.renderOpacity(guiGraphics, this.opacity.floatValue(), () -> {
                class_327 font = KeyPromptRender.minecraft.field_1772;
                String keyRightClick = class_2561.method_43471((String)"chatbox.key.right_click").getString();
                String keyScroll = class_2561.method_43471((String)"chatbox.key.scroll").getString();
                String keyEsc = class_2561.method_43471((String)"chatbox.key.esc").getString();
                String keyCtrl = class_2561.method_43471((String)"chatbox.key.ctrl").getString();
                String keyF6 = class_2561.method_43471((String)"chatbox.key.f6").getString();
                class_241 vec2 = this.getCurrentPosition();
                float x = vec2.field_1343;
                float y = vec2.field_1342;
                RenderUtil.renderImage(guiGraphics, BeanUtil.getValueOrDefault(this.rightClickTexture, new class_2960("chatbox:textures/key/right_mouse.png")), x, y + 2.0f, 0.0f, this.mouseTextureWidth.floatValue(), this.mouseTextureHeight.floatValue(), 1.0f, 0.0f);
                float f = x + this.mouseTextureWidth.floatValue() + 2.0f;
                Objects.requireNonNull(font);
                KeyPromptRender.drawText(guiGraphics, f, y + 9.0f / 2.0f, keyRightClick);
                RenderUtil.renderImage(guiGraphics, BeanUtil.getValueOrDefault(this.scrollTexture, new class_2960("chatbox:textures/key/scroll_mouse.png")), x += this.mouseTextureWidth.floatValue() + (float)font.method_1727(keyRightClick) + 4.0f, y + 2.0f, 0.0f, this.mouseTextureWidth.floatValue(), this.mouseTextureHeight.floatValue(), 1.0f, 0.0f);
                float f2 = x + this.mouseTextureWidth.floatValue() + 2.0f;
                Objects.requireNonNull(font);
                KeyPromptRender.drawText(guiGraphics, f2, y + 9.0f / 2.0f, keyScroll);
                int n = (int)(x += this.mouseTextureWidth.floatValue() + (float)font.method_1727(keyScroll) + 4.0f);
                int n2 = (int)y;
                Objects.requireNonNull(font);
                KeyPromptRender.drawKeyBoardKey(guiGraphics, n, n2 + 9 / 2, "Esc", false);
                float f3 = x + (float)font.method_1727("Esc") + 6.0f;
                Objects.requireNonNull(font);
                KeyPromptRender.drawText(guiGraphics, f3, y + 9.0f / 2.0f, keyEsc);
                int n3 = (int)(x += (float)(10 + font.method_1727("Esc") + font.method_1727(keyEsc)));
                int n4 = (int)y;
                Objects.requireNonNull(font);
                KeyPromptRender.drawKeyBoardKey(guiGraphics, n3, n4 + 9 / 2, "Ctrl", false);
                float f4 = x + (float)font.method_1727("Ctrl") + 6.0f;
                Objects.requireNonNull(font);
                KeyPromptRender.drawText(guiGraphics, f4, y + 9.0f / 2.0f, keyCtrl);
                int n5 = (int)(x += (float)(10 + font.method_1727("Ctrl") + font.method_1727(keyCtrl)));
                int n6 = (int)y;
                Objects.requireNonNull(font);
                KeyPromptRender.drawKeyBoardKey(guiGraphics, n5, n6 + 9 / 2, "F6", ChatBoxUtil.chatBoxScreen.autoPlay);
                float f5 = x + (float)font.method_1727("F6") + 6.0f;
                Objects.requireNonNull(font);
                KeyPromptRender.drawText(guiGraphics, f5, y + 9.0f / 2.0f, keyF6);
            });
        }
    }

    public static void drawKeyBoardKey(class_332 guiGraphics, int x, int y, String key, boolean pressed) {
        class_327 font = KeyPromptRender.minecraft.field_1772;
        int width = font.method_1727(key) + 4;
        int height = 12;
        int topColor = -9408400;
        int faceColor = -11513776;
        int bottomColor = -14671840;
        if (pressed) {
            topColor = -11513776;
            faceColor = -14671840;
            bottomColor = -16777216;
        }
        guiGraphics.method_25296(x, y, x + width, y + height, topColor, bottomColor);
        guiGraphics.method_25294(x, y, x + width, y + height, faceColor);
        guiGraphics.method_25294(x, y, x + width, y + 1, topColor);
        guiGraphics.method_25294(x, y, x + 1, y + height, topColor);
        guiGraphics.method_25294(x, y + height - 1, x + width, y + height, bottomColor);
        guiGraphics.method_25294(x + width - 1, y, x + width, y + height, bottomColor);
        guiGraphics.method_25300(font, key, x + width / 2, y + (height - 8) / 2, -1);
    }

    public static void drawText(class_332 guiGraphics, float x, float y, String text) {
        class_327 font = class_310.method_1551().field_1772;
        guiGraphics.method_51433(font, text, (int)(x - 1.0f), (int)y, -16777216, true);
        guiGraphics.method_51433(font, text, (int)(x + 1.0f), (int)y, -16777216, true);
        guiGraphics.method_51433(font, text, (int)x, (int)(y - 1.0f), -16777216, true);
        guiGraphics.method_51433(font, text, (int)x, (int)(y + 1.0f), -16777216, true);
        guiGraphics.method_51433(font, text, (int)x, (int)y, -1, true);
    }
}

