/*
 * Decompiled with CFR 0.152.
 */
package com.zhenshiz.chatbox.screen;

import com.zhenshiz.chatbox.ChatBox;
import com.zhenshiz.chatbox.component.AbstractComponent;
import com.zhenshiz.chatbox.component.ChatOption;
import com.zhenshiz.chatbox.component.DialogBox;
import com.zhenshiz.chatbox.component.FunctionalButton;
import com.zhenshiz.chatbox.component.Portrait;
import com.zhenshiz.chatbox.component.Video;
import com.zhenshiz.chatbox.mixin.client.SoundEngineAccessor;
import com.zhenshiz.chatbox.mixin.client.SoundInstanceAccessor;
import com.zhenshiz.chatbox.render.KeyPromptRender;
import com.zhenshiz.chatbox.utils.chatbox.ChatBoxUtil;
import com.zhenshiz.chatbox.utils.chatbox.RenderUtil;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1113;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_4235;
import net.minecraft.class_437;
import org.jetbrains.annotations.NotNull;

public class ChatBoxScreen
extends class_437 {
    public List<ChatOption> chatOptions = new ArrayList<ChatOption>();
    public List<Portrait> portraits = new ArrayList<Portrait>();
    public DialogBox dialogBox = new DialogBox();
    public List<FunctionalButton> functionalButtons = new ArrayList<FunctionalButton>();
    public class_2960 backgroundImage;
    public Boolean isTranslatable;
    public Boolean isEsc;
    public Boolean isPause;
    public Boolean isHistoricalSkip;
    public Video video;
    public KeyPromptRender keyPromptRender = new KeyPromptRender();
    public boolean fastForward = false;
    public boolean autoPlay = false;
    public int tickAutoPlay = 20;
    public boolean hideDialogBox = false;

    public ChatBoxScreen() {
        super(class_2561.method_30163((String)"ChatBoxScreen"));
    }

    public ChatBoxScreen addChatOptions(ChatOption chatOption) {
        if (chatOption != null) {
            this.chatOptions.add(chatOption);
        }
        return this;
    }

    public ChatBoxScreen setChatOptions(List<ChatOption> chatOptions) {
        if (chatOptions != null) {
            this.chatOptions = chatOptions;
        }
        return this;
    }

    public ChatBoxScreen setDialogBox(DialogBox dialogBox) {
        if (dialogBox != null) {
            this.dialogBox = dialogBox;
        }
        return this;
    }

    public ChatBoxScreen setPortrait(List<Portrait> portraits) {
        if (portraits != null) {
            this.portraits = portraits;
        }
        return this;
    }

    public ChatBoxScreen setFunctionalButtons(List<FunctionalButton> functionalButtons) {
        if (functionalButtons != null) {
            this.functionalButtons = functionalButtons;
        }
        return this;
    }

    public ChatBoxScreen setBackgroundImage(class_2960 backgroundImage) {
        this.backgroundImage = backgroundImage;
        return this;
    }

    public ChatBoxScreen setBackgroundImage(String backgroundImage) {
        if (backgroundImage != null) {
            return this.setBackgroundImage(class_2960.method_12829((String)backgroundImage));
        }
        this.backgroundImage = null;
        return this;
    }

    public ChatBoxScreen setVideo(Video video) {
        if (!ChatBox.isWaterMediaLoaded()) {
            return this;
        }
        if (this.video != null) {
            this.video.close();
        }
        if (video != null) {
            this.video = video;
        }
        return this;
    }

    public ChatBoxScreen setIsTranslatable(Boolean isTranslatable) {
        if (isTranslatable != null) {
            this.isTranslatable = isTranslatable;
        }
        return this;
    }

    public ChatBoxScreen setIsEsc(Boolean isEsc) {
        if (isEsc != null) {
            this.isEsc = isEsc;
        }
        return this;
    }

    public ChatBoxScreen setIsPause(Boolean isPause) {
        if (isPause != null) {
            this.isPause = isPause;
        }
        return this;
    }

    public ChatBoxScreen setIsHistoricalSkip(Boolean isHistoricalSkip) {
        if (isHistoricalSkip != null) {
            this.isHistoricalSkip = isHistoricalSkip;
        }
        return this;
    }

    public ChatBoxScreen setKeyPromptRender(KeyPromptRender keyPromptRender) {
        if (keyPromptRender != null) {
            this.keyPromptRender = keyPromptRender;
        }
        return this;
    }

    public void method_25394(@NotNull class_332 guiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
        if (this.dialogBox != null) {
            if (ChatBox.PLATFORM.postRenderEventPre(guiGraphics)) {
                return;
            }
            if (this.backgroundImage != null) {
                RenderUtil.renderImage(guiGraphics, this.backgroundImage, 0.0f, 0.0f, 0.0f, RenderUtil.screenWidth(), RenderUtil.screenHeight(), 1.0f, 0.0f);
            }
            ArrayList<AbstractComponent> list = new ArrayList<AbstractComponent>();
            if (!this.hideDialogBox) {
                list.add(this.dialogBox);
            }
            if (this.video != null) {
                list.add(this.video);
            }
            if (this.chatOptions != null && !this.hideDialogBox) {
                list.addAll(this.chatOptions);
            }
            if (this.portraits != null) {
                list.addAll(this.hideDialogBox ? this.portraits.stream().filter(portrait -> portrait.renderOrder < this.dialogBox.renderOrder).toList() : this.portraits);
            }
            if (this.functionalButtons != null && !this.hideDialogBox) {
                list.addAll(this.functionalButtons);
            }
            list.sort(Comparator.comparingInt(p -> p.renderOrder));
            list.forEach(abstractComponent -> abstractComponent.render(guiGraphics, pMouseX, pMouseY, pPartialTick));
            ChatBox.PLATFORM.postRenderEventPost(guiGraphics);
        }
        super.method_25394(guiGraphics, pMouseX, pMouseY, pPartialTick);
    }

    public boolean shouldGotoNext() {
        if (this.video != null && this.video.isPlaying() && !this.video.canSkip) {
            return false;
        }
        return this.chatOptions.isEmpty();
    }

    private FunctionalButton getButton(FunctionalButton.Type type) {
        return this.functionalButtons.stream().filter(b -> b.type == type).findFirst().orElse(null);
    }

    public boolean method_25402(double pMouseX, double pMouseY, int pButton) {
        if (this.hideDialogBox) {
            this.hideDialogBox = false;
            return true;
        }
        if (pButton == 1) {
            this.hideDialogBox = true;
            this.fastForward = false;
            return true;
        }
        if (pButton == 0 && this.dialogBox != null) {
            this.fastForward = false;
            for (ChatOption chatOption : this.chatOptions) {
                if (!chatOption.isSelect(pMouseX, pMouseY) || !this.dialogBox.isAllOver) continue;
                chatOption.click();
                return super.method_25402(pMouseX, pMouseY, pButton);
            }
            for (FunctionalButton button : this.functionalButtons) {
                if (!button.isSelect(pMouseX, pMouseY)) continue;
                button.click();
                return super.method_25402(pMouseX, pMouseY, pButton);
            }
            this.dialogBox.click(this.shouldGotoNext());
        }
        return super.method_25402(pMouseX, pMouseY, pButton);
    }

    public boolean method_25401(double mouseX, double mouseY, double scrollY) {
        FunctionalButton logButton;
        this.fastForward = false;
        if (this.hideDialogBox) {
            this.hideDialogBox = false;
            return true;
        }
        if (scrollY < 0.0 && this.dialogBox != null) {
            this.dialogBox.click(this.shouldGotoNext());
            return true;
        }
        if (scrollY > 0.0 && (logButton = this.getButton(FunctionalButton.Type.LOG)) != null) {
            logButton.click();
            return true;
        }
        return super.method_25401(mouseX, mouseY, scrollY);
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (this.video != null && this.video.isPlaying()) {
            this.video.keyPressed(keyCode, scanCode, modifiers);
        }
        return super.method_25404(keyCode, scanCode, modifiers);
    }

    public void method_25419() {
        this.autoPlay = false;
        this.fastForward = false;
        this.hideDialogBox = false;
        if (this.video != null) {
            this.video.close();
        }
        super.method_25419();
    }

    public void method_25393() {
        if (this.hideDialogBox) {
            return;
        }
        if (!this.shouldGotoNext()) {
            this.fastForward = false;
        }
        if (this.dialogBox != null) {
            this.dialogBox.tick();
            if (this.fastForward) {
                this.dialogBox.click(this.shouldGotoNext());
            }
            class_310 minecraft = class_310.method_1551();
            if (this.autoPlay) {
                SoundInstanceAccessor soundEngine = (SoundInstanceAccessor)((SoundEngineAccessor)minecraft.method_1483()).getSoundEngine();
                if (minecraft.method_1493()) {
                    soundEngine.invokeTickNonPaused();
                }
                if (ChatBoxUtil.lastSoundResourceLocation != null) {
                    Map<class_1113, class_4235.class_4236> instanceToChannel = soundEngine.getInstanceToChannel();
                    for (class_1113 soundInstance : instanceToChannel.keySet()) {
                        if (!soundInstance.method_4775().equals((Object)ChatBoxUtil.lastSoundResourceLocation) || !minecraft.method_1483().method_4877(soundInstance)) continue;
                        return;
                    }
                }
                if (!this.dialogBox.isAllOver || this.video != null && this.video.isPlaying()) {
                    return;
                }
                --this.tickAutoPlay;
                if (this.tickAutoPlay <= 0) {
                    this.tickAutoPlay = 20;
                    this.dialogBox.click(this.shouldGotoNext());
                }
            }
        }
    }

    public boolean method_25422() {
        return this.isEsc;
    }

    public boolean method_25421() {
        return this.isPause;
    }

    public void method_25420(class_332 guiGraphics) {
    }
}

