/*
 * Decompiled with CFR 0.152.
 */
package com.zhenshiz.chatbox.utils.chatbox;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.reflect.TypeToken;
import com.zhenshiz.chatbox.ChatBox;
import com.zhenshiz.chatbox.client.ChatBoxClient;
import com.zhenshiz.chatbox.component.HistoricalDialogue;
import com.zhenshiz.chatbox.component.Portrait;
import com.zhenshiz.chatbox.data.ChatBoxDialogues;
import com.zhenshiz.chatbox.data.ChatBoxTheme;
import com.zhenshiz.chatbox.network.c2s.SendClickEvent;
import com.zhenshiz.chatbox.render.ChatBoxRenderCommon;
import com.zhenshiz.chatbox.screen.ChatBoxScreen;
import com.zhenshiz.chatbox.screen.HistoricalDialogueScreen;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3414;
import net.minecraft.class_437;
import net.minecraft.class_6880;

public class ChatBoxUtil {
    private static final class_310 minecraft = class_310.method_1551();
    public static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    public static final Map<class_2960, ChatBoxTheme> themeMap = new HashMap<class_2960, ChatBoxTheme>();
    public static final Map<class_2960, ChatBoxDialogues> dialoguesMap = new HashMap<class_2960, ChatBoxDialogues>();
    public static final Map<String, List<ChatBoxTheme.Portrait.CustomAnimation>> animationMap = new HashMap<String, List<ChatBoxTheme.Portrait.CustomAnimation>>();
    public static ChatBoxTheme chatBoxTheme;
    public static ChatBoxScreen chatBoxScreen;
    public static HistoricalDialogueScreen historicalDialogue;
    public static class_2960 lastSoundResourceLocation;
    public static String themeResourceLocation;
    public static class_2960 dialoguesResourceLocation;
    public static String group;
    public static Integer index;
    public static boolean isScreen;

    public static void setDialoguesInfo(class_2960 resourceLocation, String group, Integer index) {
        if (resourceLocation != null && group != null && index != null) {
            dialoguesResourceLocation = resourceLocation;
            ChatBoxUtil.group = group;
            ChatBoxUtil.index = index;
        }
    }

    private static List<Portrait> bakePortrait(class_2960 newRl, String newGroup, Integer newIndex) {
        ChatBoxDialogues.Dialogues dialog;
        int i;
        List<Portrait> portraits = ChatBoxUtil.chatBoxScreen.portraits;
        List<ChatBoxDialogues.Dialogues> dialogues = ChatBoxUtil.dialoguesMap.get((Object)newRl).dialogues.get(newGroup);
        if (dialoguesResourceLocation != null && group != null && index != null && newRl == dialoguesResourceLocation && Objects.equals(newGroup, group) && newIndex == index + 1) {
            return dialogues.get(newIndex).setPortraitDialogues(portraits);
        }
        int startIndex = 0;
        for (i = newIndex.intValue(); i >= 0; --i) {
            dialog = dialogues.get(i);
            if (!dialog.clearOldPortrait.booleanValue()) continue;
            startIndex = i;
            break;
        }
        for (i = startIndex; i <= newIndex; ++i) {
            dialog = dialogues.get(i);
            dialog.setPortraitDialogues(portraits);
        }
        return portraits;
    }

    public static void skipDialogues(class_2960 dialoguesResourceLocation, String group, int index) {
        String theme;
        if (ChatBoxUtil.minecraft.field_1724 == null) {
            return;
        }
        ChatBoxDialogues chatBoxDialogues = dialoguesMap.get(dialoguesResourceLocation);
        Boolean isTranslatable = chatBoxDialogues.isTranslatable;
        if (chatBoxDialogues.isScreen != null) {
            isScreen = chatBoxDialogues.isScreen;
        }
        if ((theme = chatBoxDialogues.theme) != null && !theme.equals(themeResourceLocation)) {
            ChatBoxUtil.toggleTheme(new class_2960(theme));
            themeResourceLocation = theme;
        }
        List<ChatBoxDialogues.Dialogues> dialogues = chatBoxDialogues.dialogues.get(group);
        if (index >= 0 && index < dialogues.size()) {
            ChatBoxDialogues.Dialogues dialog = dialogues.get(index);
            ChatBoxDialogues.Dialogues.DialogBox dialogBox = dialog.dialogBox;
            chatBoxScreen.setDialogBox(dialogBox.setDialogBoxDialogues(ChatBoxUtil.chatBoxScreen.dialogBox, isTranslatable)).setVideo(dialog.video != null ? dialog.video.setVideo() : null).setPortrait(ChatBoxUtil.bakePortrait(dialoguesResourceLocation, group, index)).setChatOptions(dialog.setChatOptionDialogues(isTranslatable)).setBackgroundImage(dialog.backgroundImage).setIsTranslatable(isTranslatable).setIsEsc(chatBoxDialogues.isEsc).setIsPause(chatBoxDialogues.isPause).setIsHistoricalSkip(chatBoxDialogues.isHistoricalSkip);
            ChatBoxUtil.chatBoxScreen.dialogBox.resetTickCount();
            ChatBoxUtil.chatBoxScreen.dialogBox.setAllOver(false);
            if (!(ChatBoxUtil.minecraft.field_1755 instanceof ChatBoxScreen) && !(ChatBoxUtil.minecraft.field_1755 instanceof HistoricalDialogueScreen)) {
                historicalDialogue = new HistoricalDialogueScreen();
            }
            ChatBoxUtil.historicalDialogue.historicalDialogue.addHistoricalInfo(new HistoricalDialogue.HistoricalInfo(dialoguesResourceLocation, group, index).setName(dialogBox.name, isTranslatable).setText(dialogBox.text, isTranslatable));
            if (dialog.command != null) {
                ChatBox.PLATFORM.sendToServer(new SendClickEvent("COMMAND", dialog.command));
            }
            class_2960 soundResourceLocation = class_2960.method_12829((String)dialog.sound);
            if (!ChatBoxClient.conf.soundInterruptionEnabled && Objects.equals(dialog.sound, "")) {
                soundResourceLocation = null;
            }
            if (soundResourceLocation != null) {
                if (lastSoundResourceLocation != null) {
                    minecraft.method_1483().method_4875(lastSoundResourceLocation, null);
                }
                class_3414 soundEvent = (class_3414)class_6880.method_40223((Object)class_3414.method_47908((class_2960)soundResourceLocation)).comp_349();
                lastSoundResourceLocation = soundResourceLocation;
                ChatBoxUtil.minecraft.field_1724.method_5783(soundEvent, dialog.volume.floatValue(), dialog.pitch.floatValue());
            }
            ChatBox.PLATFORM.postSkipChatEvent(chatBoxScreen, dialoguesResourceLocation, group, index);
            if (isScreen) {
                minecraft.method_1507((class_437)chatBoxScreen);
            } else {
                ChatBoxRenderCommon.isOpenChatBox = true;
            }
            ChatBoxUtil.setDialoguesInfo(dialoguesResourceLocation, group, index);
        } else if (isScreen) {
            if (ChatBoxUtil.minecraft.field_1755 != null) {
                ChatBoxUtil.minecraft.field_1755.method_25419();
            }
        } else {
            ChatBoxRenderCommon.onClose();
        }
    }

    public static void skipDialogues(class_2960 dialoguesResourceLocation, String dialogBlock) {
        ChatBoxUtil.skipDialogues(dialoguesResourceLocation, dialogBlock, 0);
    }

    public static void toggleTheme(class_2960 themeResourceLocation) {
        chatBoxTheme = themeMap.get(themeResourceLocation);
        chatBoxScreen.setDialogBox(ChatBoxUtil.chatBoxTheme.dialogBox.setDialogBoxTheme(ChatBoxUtil.chatBoxScreen.dialogBox)).setFunctionalButtons(ChatBoxTheme.FunctionButton.setFunctionalButtonTheme(ChatBoxUtil.chatBoxTheme.functionButtons)).setKeyPromptRender(ChatBoxUtil.chatBoxTheme.keyPrompt.setKeyPromptTheme(ChatBoxUtil.chatBoxScreen.keyPromptRender));
    }

    public static void setTheme(Map<class_2960, String> map) {
        map.forEach((resourceLocation, str) -> {
            JsonElement jsonElement = (JsonElement)GSON.fromJson(str, JsonElement.class);
            if (jsonElement == null) {
                return;
            }
            JsonObject jsonObject = jsonElement.getAsJsonObject();
            JsonElement portraitElement = jsonObject.get("portrait");
            JsonElement chatOptionElement = jsonObject.get("option");
            JsonElement dialogBoxElement = jsonObject.get("dialogBox");
            JsonElement fbElement = jsonObject.get("functionalButton");
            JsonElement keyPromptElement = jsonObject.get("keyPrompt");
            JsonElement customAnimationElement = jsonObject.get("customAnimation");
            HashMap<String, ChatBoxTheme.Portrait> portrait = new HashMap();
            ChatBoxTheme.Option option = new ChatBoxTheme.Option();
            ChatBoxTheme.DialogBox dialogBox = new ChatBoxTheme.DialogBox();
            ArrayList<ChatBoxTheme.FunctionButton> functionButton = new ArrayList();
            ChatBoxTheme.KeyPrompt keyPrompt = new ChatBoxTheme.KeyPrompt();
            Map customAnimation = new HashMap();
            if (portraitElement != null) {
                portrait = (Map)GSON.fromJson(portraitElement, new TypeToken<Map<String, ChatBoxTheme.Portrait>>(){}.getType());
            }
            if (chatOptionElement != null) {
                option = (ChatBoxTheme.Option)GSON.fromJson(chatOptionElement, ChatBoxTheme.Option.class);
            }
            if (dialogBoxElement != null) {
                dialogBox = (ChatBoxTheme.DialogBox)GSON.fromJson(dialogBoxElement, ChatBoxTheme.DialogBox.class);
            }
            if (fbElement != null) {
                functionButton = (List)GSON.fromJson(fbElement, new TypeToken<List<ChatBoxTheme.FunctionButton>>(){}.getType());
            }
            if (keyPromptElement != null) {
                keyPrompt = (ChatBoxTheme.KeyPrompt)GSON.fromJson(keyPromptElement, ChatBoxTheme.KeyPrompt.class);
            }
            if (customAnimationElement != null) {
                customAnimation = (Map)GSON.fromJson(customAnimationElement, new TypeToken<Map<String, List<ChatBoxTheme.Portrait.CustomAnimation>>>(){}.getType());
            }
            animationMap.putAll(customAnimation);
            themeMap.put((class_2960)resourceLocation, new ChatBoxTheme(portrait, option, dialogBox, functionButton, keyPrompt).setDefaultValue());
        });
    }

    public static void setDialogues(Map<class_2960, String> map) {
        map.forEach((resourceLocation, str) -> {
            JsonElement jsonElement = (JsonElement)GSON.fromJson(str, JsonElement.class);
            if (jsonElement != null) {
                ChatBoxDialogues chatBoxDialogues = (ChatBoxDialogues)GSON.fromJson(jsonElement, new TypeToken<ChatBoxDialogues>(){}.getType());
                dialoguesMap.put((class_2960)resourceLocation, chatBoxDialogues);
            }
        });
    }

    public static String parseText(String input, boolean isLineBreak) {
        if (ChatBoxUtil.minecraft.field_1724 != null) {
            input = input.replaceAll("(?<!@)@s", Objects.requireNonNull(ChatBoxUtil.minecraft.field_1724.method_5476()).getString());
            if (isLineBreak) {
                input = input.replaceAll("\n", "");
            }
            return input.replaceAll("@@", "@");
        }
        return input;
    }

    static {
        chatBoxScreen = new ChatBoxScreen();
        historicalDialogue = new HistoricalDialogueScreen();
        lastSoundResourceLocation = null;
        themeResourceLocation = null;
        isScreen = true;
    }
}

