/*
 * Decompiled with CFR 0.152.
 */
package com.zhenshiz.chatbox.utils.chatbox;

import com.mojang.authlib.GameProfile;
import com.mojang.authlib.minecraft.MinecraftProfileTexture;
import com.mojang.blaze3d.systems.RenderSystem;
import com.zhenshiz.chatbox.data.ChatBoxTheme;
import java.awt.Point;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.class_1041;
import net.minecraft.class_1068;
import net.minecraft.class_1071;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2631;
import net.minecraft.class_286;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_5348;
import net.minecraft.class_7532;
import net.minecraft.class_757;
import org.joml.Matrix4f;
import org.joml.Quaternionf;
import org.lwjgl.glfw.GLFW;

public class RenderUtil {
    private static final class_310 minecraft = class_310.method_1551();
    private static final Map<String, class_2960> skins = new HashMap<String, class_2960>();

    public static int screenWidth() {
        return minecraft.method_22683().method_4486();
    }

    public static int screenHeight() {
        return minecraft.method_22683().method_4502();
    }

    public static void fillRect(class_332 guiGraphics, int x, int y, int w, int h, int color) {
        class_287 buf = RenderUtil.getBuffer();
        buf.method_1328(class_293.class_5596.field_27382, class_290.field_1576);
        Matrix4f mat = guiGraphics.method_51448().method_23760().method_23761();
        buf.method_22918(mat, (float)x, (float)y, 0.0f).method_39415(color).method_1344();
        buf.method_22918(mat, (float)(x + w), (float)y, 0.0f).method_39415(color).method_1344();
        buf.method_22918(mat, (float)(x + w), (float)(y + h), 0.0f).method_39415(color).method_1344();
        buf.method_22918(mat, (float)x, (float)(y + h), 0.0f).method_39415(color).method_1344();
        RenderUtil.beginRendering();
        RenderUtil.drawBuffer(buf);
        RenderUtil.finishRendering();
    }

    public static void fillArc(class_332 guiGraphics, int cX, int cY, int radius, int start, int end, int color) {
        class_287 buf = RenderUtil.getBuffer();
        buf.method_1328(class_293.class_5596.field_27381, class_290.field_1576);
        Matrix4f mat = guiGraphics.method_51448().method_23760().method_23761();
        buf.method_22918(mat, (float)cX, (float)cY, 0.0f).method_39415(color).method_1344();
        for (int i = start - 90; i <= end - 90; ++i) {
            double angle = Math.toRadians(i);
            float x = (float)(Math.cos(angle) * (double)radius) + (float)cX;
            float y = (float)(Math.sin(angle) * (double)radius) + (float)cY;
            buf.method_22918(mat, x, y, 0.0f).method_39415(color).method_1344();
        }
        RenderUtil.beginRendering();
        RenderUtil.drawBuffer(buf);
        RenderUtil.finishRendering();
    }

    public static void fillCircle(class_332 guiGraphics, int cX, int cY, int radius, int color) {
        RenderUtil.fillArc(guiGraphics, cX, cY, radius, 0, 360, color);
    }

    public static void fillAnnulusArc(class_332 guiGraphics, int cx, int cy, int radius, int start, int end, int thickness, int color) {
        class_287 buf = RenderUtil.getBuffer();
        buf.method_1328(class_293.class_5596.field_27380, class_290.field_1576);
        Matrix4f mat = guiGraphics.method_51448().method_23760().method_23761();
        for (int i = start - 90; i <= end - 90; ++i) {
            float angle = (float)Math.toRadians(i);
            float cos = (float)Math.cos(angle);
            float sin = (float)Math.sin(angle);
            float x1 = (float)cx + cos * (float)radius;
            float y1 = (float)cy + sin * (float)radius;
            float x2 = (float)cx + cos * (float)(radius + thickness);
            float y2 = (float)cy + sin * (float)(radius + thickness);
            buf.method_22918(mat, x1, y1, 0.0f).method_39415(color).method_1344();
            buf.method_22918(mat, x2, y2, 0.0f).method_39415(color).method_1344();
        }
        RenderUtil.beginRendering();
        RenderUtil.drawBuffer(buf);
        RenderUtil.finishRendering();
    }

    public static void fillAnnulus(class_332 guiGraphics, int cx, int cy, int radius, int thickness, int color) {
        RenderUtil.fillAnnulusArc(guiGraphics, cx, cy, radius, 0, 360, thickness, color);
    }

    public static void fillRoundRect(class_332 guiGraphics, int x, int y, int w, int h, int r, int color) {
        r = class_3532.method_15340((int)r, (int)0, (int)(Math.min(w, h) / 2));
        class_287 buf = RenderUtil.getBuffer();
        buf.method_1328(class_293.class_5596.field_27381, class_290.field_1576);
        Matrix4f mat = guiGraphics.method_51448().method_23760().method_23761();
        buf.method_22918(mat, (float)x + (float)w / 2.0f, (float)y + (float)h / 2.0f, 0.0f).method_39415(color).method_1344();
        int[][] corners = new int[][]{{x + w - r, y + r}, {x + w - r, y + h - r}, {x + r, y + h - r}, {x + r, y + r}};
        for (int corner = 0; corner < 4; ++corner) {
            int cornerStart = (corner - 1) * 90;
            int cornerEnd = cornerStart + 90;
            for (int i = cornerStart; i <= cornerEnd; i += 10) {
                float angle = (float)Math.toRadians(i);
                float rx = (float)corners[corner][0] + (float)(Math.cos(angle) * (double)r);
                float ry = (float)corners[corner][1] + (float)(Math.sin(angle) * (double)r);
                buf.method_22918(mat, rx, ry, 0.0f).method_39415(color).method_1344();
            }
        }
        buf.method_22918(mat, (float)corners[0][0], (float)y, 0.0f).method_39415(color).method_1344();
        RenderUtil.beginRendering();
        RenderUtil.drawBuffer(buf);
        RenderUtil.finishRendering();
    }

    public static void fillRoundShadow(class_332 guiGraphics, int x, int y, int w, int h, int r, int thickness, int innerColor, int outerColor) {
        r = class_3532.method_15340((int)r, (int)0, (int)(Math.min(w, h) / 2));
        class_287 buf = RenderUtil.getBuffer();
        buf.method_1328(class_293.class_5596.field_27380, class_290.field_1576);
        Matrix4f mat = guiGraphics.method_51448().method_23760().method_23761();
        int[][] corners = new int[][]{{x + w - r, y + r}, {x + w - r, y + h - r}, {x + r, y + h - r}, {x + r, y + r}};
        for (int corner = 0; corner < 4; ++corner) {
            int cornerStart = (corner - 1) * 90;
            int cornerEnd = cornerStart + 90;
            for (int i = cornerStart; i <= cornerEnd; i += 10) {
                float angle = (float)Math.toRadians(i);
                float rx1 = (float)corners[corner][0] + (float)(Math.cos(angle) * (double)r);
                float ry1 = (float)corners[corner][1] + (float)(Math.sin(angle) * (double)r);
                float rx2 = (float)corners[corner][0] + (float)(Math.cos(angle) * (double)(r + thickness));
                float ry2 = (float)corners[corner][1] + (float)(Math.sin(angle) * (double)(r + thickness));
                buf.method_22918(mat, rx1, ry1, 0.0f).method_39415(innerColor).method_1344();
                buf.method_22918(mat, rx2, ry2, 0.0f).method_39415(outerColor).method_1344();
            }
        }
        buf.method_22918(mat, (float)corners[0][0], (float)y, 0.0f).method_39415(innerColor).method_1344();
        buf.method_22918(mat, (float)corners[0][0], (float)(y - thickness), 0.0f).method_39415(outerColor).method_1344();
        RenderUtil.beginRendering();
        RenderUtil.drawBuffer(buf);
        RenderUtil.finishRendering();
    }

    public static void fillRoundTabTop(class_332 guiGraphics, int x, int y, int w, int h, int r, int color) {
        r = class_3532.method_15340((int)r, (int)0, (int)(Math.min(w, h) / 2));
        class_287 buf = RenderUtil.getBuffer();
        buf.method_1328(class_293.class_5596.field_27381, class_290.field_1576);
        Matrix4f mat = guiGraphics.method_51448().method_23760().method_23761();
        buf.method_22918(mat, (float)x + (float)w / 2.0f, (float)y + (float)h / 2.0f, 0.0f).method_39415(color).method_1344();
        int[][] corners = new int[][]{{x + r, y + r}, {x + w - r, y + r}};
        for (int corner = 0; corner < 2; ++corner) {
            int cornerStart = (corner - 2) * 90;
            int cornerEnd = cornerStart + 90;
            for (int i = cornerStart; i <= cornerEnd; i += 10) {
                float angle = (float)Math.toRadians(i);
                float rx = (float)corners[corner][0] + (float)(Math.cos(angle) * (double)r);
                float ry = (float)corners[corner][1] + (float)(Math.sin(angle) * (double)r);
                buf.method_22918(mat, rx, ry, 0.0f).method_39415(color).method_1344();
            }
        }
        buf.method_22918(mat, (float)(x + w), (float)(y + h), 0.0f).method_39415(color).method_1344();
        buf.method_22918(mat, (float)x, (float)(y + h), 0.0f).method_39415(color).method_1344();
        buf.method_22918(mat, (float)x, (float)corners[0][1], 0.0f).method_39415(color).method_1344();
        RenderUtil.beginRendering();
        RenderUtil.drawBuffer(buf);
        RenderUtil.finishRendering();
    }

    public static void fillRoundTabBottom(class_332 guiGraphics, int x, int y, int w, int h, int r, int color) {
        r = class_3532.method_15340((int)r, (int)0, (int)(Math.min(w, h) / 2));
        class_287 buf = RenderUtil.getBuffer();
        buf.method_1328(class_293.class_5596.field_27381, class_290.field_1576);
        Matrix4f mat = guiGraphics.method_51448().method_23760().method_23761();
        buf.method_22918(mat, (float)x + (float)w / 2.0f, (float)y + (float)h / 2.0f, 0.0f).method_39415(color).method_1344();
        int[][] corners = new int[][]{{x + w - r, y + h - r}, {x + r, y + h - r}};
        for (int corner = 0; corner < 2; ++corner) {
            int cornerStart = corner * 90;
            int cornerEnd = cornerStart + 90;
            for (int i = cornerStart; i <= cornerEnd; i += 10) {
                float angle = (float)Math.toRadians(i);
                float rx = (float)corners[corner][0] + (float)(Math.cos(angle) * (double)r);
                float ry = (float)corners[corner][1] + (float)(Math.sin(angle) * (double)r);
                buf.method_22918(mat, rx, ry, 0.0f).method_39415(color).method_1344();
            }
        }
        buf.method_22918(mat, (float)x, (float)y, 0.0f).method_39415(color).method_1344();
        buf.method_22918(mat, (float)(x + w), (float)y, 0.0f).method_39415(color).method_1344();
        buf.method_22918(mat, (float)(x + w), (float)corners[0][1], 0.0f).method_39415(color).method_1344();
        RenderUtil.beginRendering();
        RenderUtil.drawBuffer(buf);
        RenderUtil.finishRendering();
    }

    public static void fillRoundHorLine(class_332 guiGraphics, int x, int y, int length, int thickness, int color) {
        RenderUtil.fillRoundRect(guiGraphics, x, y, length, thickness, thickness / 2, color);
    }

    public static void fillRoundVerLine(class_332 guiGraphics, int x, int y, int length, int thickness, int color) {
        RenderUtil.fillRoundRect(guiGraphics, x, y, thickness, length, thickness / 2, color);
    }

    public static void drawRect(class_332 guiGraphics, int x, int y, int w, int h, int color) {
        RenderUtil.drawHorLine(guiGraphics, x, y, w, color);
        RenderUtil.drawVerLine(guiGraphics, x, y + 1, h - 2, color);
        RenderUtil.drawVerLine(guiGraphics, x + w - 1, y + 1, h - 2, color);
        RenderUtil.drawHorLine(guiGraphics, x, y + h - 1, w, color);
    }

    public static void drawBox(class_332 guiGraphics, int x, int y, int w, int h, int color) {
        RenderUtil.drawLine(guiGraphics, x, y, x + w, y, color);
        RenderUtil.drawLine(guiGraphics, x, y + h, x + w, y + h, color);
        RenderUtil.drawLine(guiGraphics, x, y, x, y + h, color);
        RenderUtil.drawLine(guiGraphics, x + w, y, x + w, y + h, color);
    }

    public static void drawHorLine(class_332 guiGraphics, int x, int y, int length, int color) {
        RenderUtil.fillRect(guiGraphics, x, y, length, 1, color);
    }

    public static void drawVerLine(class_332 guiGraphics, int x, int y, int length, int color) {
        RenderUtil.fillRect(guiGraphics, x, y, 1, length, color);
    }

    public static void drawLine(class_332 guiGraphics, int x1, int y1, int x2, int y2, int color) {
        class_287 buf = RenderUtil.getBuffer();
        buf.method_1328(class_293.class_5596.field_29344, class_290.field_1576);
        Matrix4f mat = guiGraphics.method_51448().method_23760().method_23761();
        buf.method_22918(mat, (float)x1, (float)y1, 0.0f).method_39415(color).method_1344();
        buf.method_22918(mat, (float)x2, (float)y2, 0.0f).method_39415(color).method_1344();
        RenderUtil.beginRendering();
        RenderUtil.drawBuffer(buf);
        RenderUtil.finishRendering();
    }

    public static void drawArc(class_332 guiGraphics, int cX, int cY, int radius, int start, int end, int color) {
        class_287 buf = RenderUtil.getBuffer();
        buf.method_1328(class_293.class_5596.field_29345, class_290.field_1576);
        Matrix4f mat = guiGraphics.method_51448().method_23760().method_23761();
        for (int i = start - 90; i <= end - 90; ++i) {
            double angle = Math.toRadians(i);
            float x = (float)(Math.cos(angle) * (double)radius) + (float)cX;
            float y = (float)(Math.sin(angle) * (double)radius) + (float)cY;
            buf.method_22918(mat, x, y, 0.0f).method_39415(color).method_1344();
        }
        RenderUtil.beginRendering();
        RenderUtil.drawBuffer(buf);
        RenderUtil.finishRendering();
    }

    public static void drawCircle(class_332 guiGraphics, int cX, int cY, int radius, int color) {
        RenderUtil.drawArc(guiGraphics, cX, cY, radius, 0, 360, color);
    }

    public static void drawRoundRect(class_332 guiGraphics, int x, int y, int w, int h, int r, int color) {
        r = class_3532.method_15340((int)r, (int)0, (int)(Math.min(w, h) / 2));
        class_287 buf = RenderUtil.getBuffer();
        buf.method_1328(class_293.class_5596.field_29345, class_290.field_1576);
        Matrix4f mat = guiGraphics.method_51448().method_23760().method_23761();
        int[][] corners = new int[][]{{x + w - r, y + r}, {x + w - r, y + h - r}, {x + r, y + h - r}, {x + r, y + r}};
        for (int corner = 0; corner < 4; ++corner) {
            int cornerStart = (corner - 1) * 90;
            int cornerEnd = cornerStart + 90;
            for (int i = cornerStart; i <= cornerEnd; i += 10) {
                float angle = (float)Math.toRadians(i);
                float rx = (float)corners[corner][0] + (float)(Math.cos(angle) * (double)r);
                float ry = (float)corners[corner][1] + (float)(Math.sin(angle) * (double)r);
                buf.method_22918(mat, rx, ry, 0.0f).method_39415(color).method_1344();
            }
        }
        buf.method_22918(mat, (float)corners[0][0], (float)y, 0.0f).method_39415(color).method_1344();
        RenderUtil.beginRendering();
        RenderUtil.drawBuffer(buf);
        RenderUtil.finishRendering();
    }

    public static void drawRoundHorLine(class_332 guiGraphics, int x, int y, int length, int thickness, int color) {
        RenderUtil.drawRoundRect(guiGraphics, x, y, length, thickness, thickness / 2, color);
    }

    public static void drawRoundVerLine(class_332 guiGraphics, int x, int y, int length, int thickness, int color) {
        RenderUtil.drawRoundRect(guiGraphics, x, y, thickness, length, thickness / 2, color);
    }

    public static void renderImageInner(class_332 guiGraphics, class_2960 resourceLocation, float x, float y, float z, float uw, float uh, float width, float height) {
        class_287 buf = RenderUtil.getBuffer();
        buf.method_1328(class_293.class_5596.field_27382, class_290.field_1585);
        Matrix4f matrix4f = guiGraphics.method_51448().method_23760().method_23761();
        buf.method_22918(matrix4f, x, y, z).method_22913(0.0f, 0.0f).method_1344();
        buf.method_22918(matrix4f, x, y + height, z).method_22913(0.0f, uh).method_1344();
        buf.method_22918(matrix4f, x + width, y + height, z).method_22913(uw, uh).method_1344();
        buf.method_22918(matrix4f, x + width, y, z).method_22913(uw, 0.0f).method_1344();
        RenderSystem.setShader(class_757::method_34542);
        RenderSystem.setShaderTexture((int)0, (class_2960)resourceLocation);
        RenderSystem.enableBlend();
        class_286.method_43433((class_287.class_7433)buf.method_1326());
        RenderSystem.disableBlend();
    }

    public static void renderImage(class_332 guiGraphics, class_2960 resourceLocation, float x, float y, float z, float width, float height, float scale, float angle, List<ChatBoxTheme.Portrait.Attachment> attachments) {
        guiGraphics.method_51448().method_22903();
        guiGraphics.method_51448().method_49278(new Quaternionf().fromAxisAngleDeg(0.0f, 0.0f, 1.0f, angle), x + width / 2.0f, y + height / 2.0f, 0.0f);
        guiGraphics.method_51448().method_22905(scale, scale, scale);
        RenderUtil.renderImageInner(guiGraphics, resourceLocation, x /= scale, y /= scale, z, 1.0f, 1.0f, width, height);
        for (ChatBoxTheme.Portrait.Attachment attachment : attachments) {
            ChatBoxTheme.Portrait.Attachment a = attachment.mapParameter();
            RenderUtil.renderImageInner(guiGraphics, new class_2960(a.value), x + a.x.floatValue(), y + a.y.floatValue(), z, 1.0f, 1.0f, a.width.floatValue(), a.height.floatValue());
        }
        guiGraphics.method_51448().method_22909();
    }

    public static void renderImage(class_332 guiGraphics, class_2960 resourceLocation, float x, float y, float z, float width, float height, float scale, float angle) {
        RenderUtil.renderImage(guiGraphics, resourceLocation, x, y, z, width, height, scale, angle, List.of());
    }

    public static void renderPlayerHead(class_332 guiGraphics, String input, int x, int y, int size, float scale, float angle) {
        guiGraphics.method_51448().method_22903();
        guiGraphics.method_51448().method_49278(new Quaternionf().fromAxisAngleDeg(0.0f, 0.0f, 1.0f, angle), (float)x + (float)size / 2.0f, (float)y + (float)size / 2.0f, 0.0f);
        x = (int)((float)x / scale);
        y = (int)((float)y / scale);
        guiGraphics.method_51448().method_22905(scale, scale, scale);
        class_7532.method_44443((class_332)guiGraphics, (class_2960)RenderUtil.getSkin(input), (int)x, (int)y, (int)size);
        guiGraphics.method_51448().method_22909();
    }

    public static void renderItem(class_332 guiGraphics, class_1799 item, int x, int y, float scale, float angle, String text) {
        guiGraphics.method_51448().method_22903();
        guiGraphics.method_51448().method_49278(new Quaternionf().fromAxisAngleDeg(0.0f, 0.0f, 1.0f, angle), (float)x + 8.0f, (float)y + 8.0f, 0.0f);
        x = (int)((float)x / scale);
        y = (int)((float)y / scale);
        guiGraphics.method_51448().method_22905(scale, scale, scale);
        guiGraphics.method_51427(item, x, y);
        guiGraphics.method_51432(RenderUtil.minecraft.field_1772, item, x, y, text);
        guiGraphics.method_51448().method_22909();
    }

    public static void renderItem(class_332 guiGraphics, class_1799 item, int x, int y, float scale, float angle) {
        RenderUtil.renderItem(guiGraphics, item, x, y, scale, angle, "");
    }

    public static void drawLeftScaleText(class_332 guiGraphics, class_2561 component, int x, int y, float scale, boolean shadow, int color) {
        class_4587 poseStack = guiGraphics.method_51448();
        poseStack.method_22905(scale, scale, scale);
        float rescale = 1.0f / scale;
        x = (int)((float)x * rescale);
        y = (int)((float)y * rescale);
        guiGraphics.method_51439(RenderUtil.minecraft.field_1772, component, x, y, color, shadow);
        poseStack.method_22905(rescale, rescale, rescale);
    }

    public static void drawCenterScaleText(class_332 guiGraphics, class_2561 component, int centerX, int y, float scale, boolean shadow, int color) {
        class_4587 poseStack = guiGraphics.method_51448();
        poseStack.method_22905(scale, scale, scale);
        float rescale = 1.0f / scale;
        centerX = (int)((float)centerX * rescale);
        y = (int)((float)y * rescale);
        guiGraphics.method_51439(RenderUtil.minecraft.field_1772, component, centerX -= RenderUtil.minecraft.field_1772.method_27525((class_5348)component) / 2, y, color, shadow);
        poseStack.method_22905(rescale, rescale, rescale);
    }

    public static void drawRightScaleText(class_332 guiGraphics, class_2561 component, int rightX, int y, float scale, boolean shadow, int color) {
        class_4587 poseStack = guiGraphics.method_51448();
        poseStack.method_22905(scale, scale, scale);
        float rescale = 1.0f / scale;
        rightX = (int)((float)rightX * rescale);
        y = (int)((float)y * rescale);
        guiGraphics.method_51439(RenderUtil.minecraft.field_1772, component, rightX -= RenderUtil.minecraft.field_1772.method_27525((class_5348)component), y, color, shadow);
        poseStack.method_22905(rescale, rescale, rescale);
    }

    public static void setCursor(int x, int y) {
        class_1041 window = minecraft.method_22683();
        int w1 = window.method_4489();
        int w2 = RenderUtil.screenWidth();
        int h1 = window.method_4506();
        int h2 = RenderUtil.screenHeight();
        double ratW = (double)w2 / (double)w1;
        double ratH = (double)h2 / (double)h1;
        GLFW.glfwSetCursorPos((long)window.method_4490(), (double)((double)x / ratW), (double)((double)y / ratH));
    }

    public static Point getCursor() {
        class_1041 window = minecraft.method_22683();
        int w1 = window.method_4489();
        int w2 = RenderUtil.screenWidth();
        int h1 = window.method_4506();
        int h2 = RenderUtil.screenHeight();
        double rW = (double)w2 / (double)w1;
        double rH = (double)h2 / (double)h1;
        return new Point((int)(rW * RenderUtil.minecraft.field_1729.method_1603()), (int)(rH * RenderUtil.minecraft.field_1729.method_1604()));
    }

    public static void renderOpacity(class_332 guiGraphics, float opacity, Runnable runnable) {
        RenderSystem.enableBlend();
        guiGraphics.method_51422(1.0f, 1.0f, 1.0f, opacity);
        runnable.run();
        RenderSystem.disableBlend();
    }

    private static void drawBuffer(class_287 buf) {
        class_286.method_43433((class_287.class_7433)buf.method_1326());
    }

    public static void beginRendering() {
        RenderSystem.disableCull();
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShader(class_757::method_34540);
    }

    public static void finishRendering() {
        RenderSystem.enableCull();
        RenderSystem.disableBlend();
        RenderSystem.setShader(class_757::method_34542);
    }

    private static class_287 getBuffer() {
        return class_289.method_1348().method_1349();
    }

    private static GameProfile createProfileComponent(String input) {
        try {
            return new GameProfile(UUID.fromString(input), null);
        }
        catch (IllegalArgumentException e) {
            return new GameProfile(null, input);
        }
    }

    private static class_2960 getSkin(String input) {
        if (skins.containsKey(input)) {
            return skins.get(input);
        }
        GameProfile profile = RenderUtil.createProfileComponent(input);
        class_2631.method_11335((GameProfile)profile, gameProfile -> {
            class_1071 manager = minecraft.method_1582();
            Map map = manager.method_4654(gameProfile);
            if (map.containsKey(MinecraftProfileTexture.Type.SKIN)) {
                skins.put(input, manager.method_4656((MinecraftProfileTexture)map.get(MinecraftProfileTexture.Type.SKIN), MinecraftProfileTexture.Type.SKIN));
            }
        });
        if (skins.containsKey(input)) {
            return skins.get(input);
        }
        return class_1068.method_4648((UUID)Objects.requireNonNull(minecraft.method_1548().method_44717()));
    }
}

