/*
 * Decompiled with CFR 0.152.
 */
package com.zhenshiz.chatbox;

import com.mojang.logging.LogUtils;
import com.zhenshiz.chatbox.api.ChatOptionClickEvent;
import com.zhenshiz.chatbox.command.ChatBoxCommand;
import com.zhenshiz.chatbox.data.ChatBoxDialoguesLoader;
import com.zhenshiz.chatbox.data.ChatBoxTriggerCount;
import com.zhenshiz.chatbox.event.ChatBoxSettingLoader;
import com.zhenshiz.chatbox.network.server.Packets;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerWorldEvents;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1937;
import net.minecraft.class_2960;
import org.slf4j.Logger;

public class ChatBox
implements ModInitializer {
    public static final String MOD_ID = "chatbox";
    public static final Logger LOGGER = LogUtils.getLogger();
    private static ChatBoxTriggerCount triggerCounts;

    public void onInitialize() {
        LOGGER.info("Ciallo\uff5e(\u2220\u00b7\u03c9< )\u2312\u2605");
        ChatOptionClickEvent.Command.register();
        ChatBoxSettingLoader.chatBoxLoader();
        Packets.register();
        CommandRegistrationCallback.EVENT.register(ChatBoxCommand::register);
        ServerWorldEvents.LOAD.register((server, world) -> {
            if (world.method_27983() == class_1937.field_25179) {
                triggerCounts = (ChatBoxTriggerCount)world.method_17983().method_17924(ChatBoxTriggerCount.getType());
            }
        });
        ServerLifecycleEvents.END_DATA_PACK_RELOAD.register((s, manager, bl) -> {
            ChatBoxDialoguesLoader.loadCriteria(s);
            s.method_3760().method_14571().forEach(ChatBoxSettingLoader::initializeChatBoxScreen);
        });
        ServerLifecycleEvents.SERVER_STARTED.register(ChatBoxDialoguesLoader::loadCriteria);
    }

    public static class_2960 ResourceLocationMod(String path) {
        return class_2960.method_60655((String)MOD_ID, (String)path);
    }

    public static boolean isModLoaded(String modId) {
        return FabricLoader.getInstance().isModLoaded(modId);
    }

    public static boolean isWaterMediaLoaded() {
        return false;
    }

    public static ChatBoxTriggerCount getTriggerCounts() {
        return triggerCounts;
    }
}

