/*
 * Decompiled with CFR 0.152.
 */
package com.zhenshiz.chatbox.client;

import com.zhenshiz.chatbox.Config;
import com.zhenshiz.chatbox.event.fabric.InputEvent;
import com.zhenshiz.chatbox.network.s2c.ChatBoxPayload;
import com.zhenshiz.chatbox.render.ChatBoxRender;
import me.shedaniel.autoconfig.AutoConfig;
import me.shedaniel.autoconfig.serializer.Toml4jConfigSerializer;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.client.rendering.v1.HudRenderCallback;

public class ChatBoxClient
implements ClientModInitializer {
    public static Config conf;

    public void onInitializeClient() {
        AutoConfig.register(Config.class, Toml4jConfigSerializer::new);
        conf = (Config)AutoConfig.getConfigHolder(Config.class).getConfig();
        ChatBoxClient.registerReceiver();
        this.registerRenderEvents();
    }

    private static void registerReceiver() {
        ClientPlayNetworking.registerGlobalReceiver(ChatBoxPayload.OpenScreenPayload.TYPE, ChatBoxPayload.OpenScreenPayload::execute);
        ClientPlayNetworking.registerGlobalReceiver(ChatBoxPayload.AllChatBoxThemeToClient.TYPE, ChatBoxPayload.AllChatBoxThemeToClient::execute);
        ClientPlayNetworking.registerGlobalReceiver(ChatBoxPayload.AllChatBoxDialoguesToClient.TYPE, ChatBoxPayload.AllChatBoxDialoguesToClient::execute);
        ClientPlayNetworking.registerGlobalReceiver(ChatBoxPayload.SimplePayload.TYPE, ChatBoxPayload.SimplePayload::execute);
    }

    private void registerRenderEvents() {
        HudRenderCallback.EVENT.register((Object)new ChatBoxRender());
        ClientTickEvents.END_CLIENT_TICK.register((Object)new ChatBoxRender());
        InputEvent.KEY.register((Object)new ChatBoxRender());
        InputEvent.MouseButton.POST.register((Object)new ChatBoxRender());
        InputEvent.MOUSE_SCROLLING.register((Object)new ChatBoxRender());
    }
}

