/*
 * Decompiled with CFR 0.152.
 */
package com.zhenshiz.chatbox.component;

import com.zhenshiz.chatbox.ChatBox;
import com.zhenshiz.chatbox.client.ChatBoxClient;
import com.zhenshiz.chatbox.component.AbstractComponent;
import com.zhenshiz.chatbox.utils.chatbox.ChatBoxUtil;
import com.zhenshiz.chatbox.utils.common.StrUtil;
import java.util.ArrayList;
import net.minecraft.class_241;
import net.minecraft.class_2477;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_5348;
import org.joml.Matrix3x2fStack;

public class DialogBox
extends AbstractComponent<DialogBox> {
    public class_2960 texture;
    private String text;
    public float textX;
    public float textY;
    public class_2561 name;
    public float nameX;
    public float nameY;
    public float lineWidth;
    public boolean isAllOver;
    public int tickCount;
    private String[] textBuffer;
    private int charIndex;

    public DialogBox() {
        this.setTexture(ChatBox.ResourceLocationMod("textures/chatbox/default_dialog_box.png"));
        this.setText("", false);
        this.setTextPosition(0.0f, 0.0f);
        this.setName("", false);
        this.setNamePosition(0.0f, 0.0f);
        this.setLineWidth(Float.valueOf(100.0f));
        this.setAllOver(false);
        this.resetTickCount();
        this.textBuffer = new String[]{""};
    }

    public DialogBox setTexture(class_2960 texture) {
        if (texture != null) {
            this.texture = texture;
        }
        return this;
    }

    public DialogBox setTexture(String texture) {
        if (texture != null) {
            return this.setTexture(class_2960.method_12829((String)texture));
        }
        return this;
    }

    public DialogBox setText(String text, boolean isTranslatable) {
        if (text != null) {
            String string = text = isTranslatable ? class_2477.method_10517().method_48307(text) : text;
            if (ChatBox.isModLoaded("textanimator")) {
                text = text.replaceAll("<typewriter>", "");
            }
            this.text = text;
            this.textToTextBuffer();
        }
        return this;
    }

    public DialogBox setName(String name, boolean isTranslatable) {
        if (name != null) {
            this.name = isTranslatable ? class_2561.method_43471((String)name) : class_2561.method_30163((String)name);
        }
        return this;
    }

    public DialogBox setNamePosition(float x, float y) {
        this.nameX = x;
        this.nameY = y;
        return this;
    }

    public DialogBox setTextPosition(float x, float y) {
        this.textX = x;
        this.textY = y;
        return this;
    }

    public DialogBox setLineWidth(Float lineWidth) {
        if (this.checkSize(lineWidth.floatValue())) {
            this.lineWidth = lineWidth.floatValue();
        }
        return this;
    }

    public DialogBox setAllOver(boolean allOver) {
        this.isAllOver = allOver;
        return this;
    }

    public DialogBox resetTickCount() {
        this.tickCount = 0;
        this.charIndex = 0;
        return this;
    }

    private void textToTextBuffer() {
        String input = this.text;
        ArrayList<String> result = new ArrayList<String>(input.length());
        StringBuilder stringBuilder = new StringBuilder();
        for (int index = 0; index < input.length(); ++index) {
            int closing;
            char c = input.charAt(index);
            stringBuilder.append(c);
            if (ChatBox.isModLoaded("textanimator") && c == '<' && (closing = input.indexOf(62, index + 1)) != -1) {
                stringBuilder.append(input, index + 1, closing + 1);
                index = closing;
            }
            if (c == '\\' || c == '\u00a7') {
                stringBuilder.append(input.charAt(index + 1));
                ++index;
            }
            result.add(stringBuilder.toString());
        }
        this.textBuffer = result.toArray(new String[0]);
    }

    public void click(boolean gotoNext) {
        if (!this.isAllOver) {
            this.charIndex = this.textBuffer.length - 1;
            this.setAllOver(true);
        } else if (gotoNext && DialogBox.minecraft.field_1724 != null) {
            ChatBoxUtil.skipDialogues(ChatBoxUtil.dialoguesResourceLocation, ChatBoxUtil.group, ChatBoxUtil.index + 1);
            ChatBoxUtil.chatBoxScreen.tickAutoPlay = 20;
        }
    }

    public void tick() {
        if (!this.isAllOver) {
            if (this.charIndex == this.textBuffer.length - 1) {
                this.setAllOver(true);
                return;
            }
            ++this.tickCount;
            float charPerTick = (float)ChatBoxClient.conf.charPerSecond / 20.0f;
            if ((float)this.tickCount * charPerTick >= (float)(this.charIndex + 1)) {
                this.charIndex = Math.min((int)((float)this.tickCount * charPerTick), this.textBuffer.length - 1);
            }
        }
    }

    @Override
    public void render(class_332 guiGraphics, int mouseX, int mouseY, float pPartialTick) {
        if (this.texture != null) {
            this.renderImage(guiGraphics, this.texture);
        }
        class_241 position = this.getCurrentPosition();
        float x = position.field_1343;
        float y = position.field_1342;
        Matrix3x2fStack poseStack = guiGraphics.method_51448();
        poseStack.pushMatrix();
        if (StrUtil.isNotEmpty(this.name.getString())) {
            guiGraphics.method_65179(DialogBox.minecraft.field_1772, (class_5348)class_2561.method_30163((String)this.parseText(StrUtil.format("[{}]", this.name.getString()))), (int)DialogBox.getResponsiveWidth(x + this.nameX), (int)DialogBox.getResponsiveHeight(y + this.nameY), (int)DialogBox.getResponsiveWidth(this.lineWidth), -1);
        }
        if (StrUtil.isNotEmpty(this.text)) {
            guiGraphics.method_65179(DialogBox.minecraft.field_1772, (class_5348)class_2561.method_30163((String)this.parseText(this.textBuffer[this.charIndex])), (int)DialogBox.getResponsiveWidth(x + this.textX), (int)DialogBox.getResponsiveHeight(y + this.textY), (int)DialogBox.getResponsiveWidth(this.lineWidth), -1);
        }
        poseStack.popMatrix();
    }
}

