/*
 * Decompiled with CFR 0.152.
 */
package com.zhenshiz.chatbox.component;

import com.zhenshiz.chatbox.client.ChatBoxClient;
import com.zhenshiz.chatbox.utils.chatbox.ChatBoxUtil;
import com.zhenshiz.chatbox.utils.common.StrUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_5244;
import net.minecraft.class_5348;
import net.minecraft.class_6382;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix3x2fStack;
import org.joml.Vector4i;

public class HistoricalDialogue
extends class_339 {
    public List<HistoricalInfo> historicalInfos = new ArrayList<HistoricalInfo>();
    private float yOffset = 0.0f;
    private float verticalScrollAmount = 0.0f;
    private static final class_310 minecraft = class_310.method_1551();

    public HistoricalDialogue(int x, int y, int width, int height) {
        super(x, y, width, height, (class_2561)class_2561.method_43473());
    }

    public HistoricalDialogue addHistoricalInfo(HistoricalInfo historicalInfo) {
        if (historicalInfo != null) {
            this.historicalInfos.add(historicalInfo);
        }
        return this;
    }

    public HistoricalDialogue setHistoricalInfo(List<HistoricalInfo> historicalInfos) {
        if (historicalInfos != null) {
            this.historicalInfos = historicalInfos;
        }
        return this;
    }

    protected void method_48579(@NotNull class_332 guiGraphics, int mouseX, int mouseY, float delta) {
        Objects.requireNonNull(HistoricalDialogue.minecraft.field_1772);
        this.yOffset = Math.clamp(this.yOffset + this.verticalScrollAmount * delta, (float)(this.field_22759 - 30 - (9 + 27) * this.historicalInfos.size()), (float)(this.field_22759 - 30));
        this.verticalScrollAmount = this.verticalScrollAmount > 0.0f ? Math.clamp(this.verticalScrollAmount - delta * 3.0f, 0.0f, Float.MAX_VALUE) : Math.clamp(this.verticalScrollAmount + delta * 3.0f, -3.4028235E38f, 0.0f);
        Matrix3x2fStack poseStack = guiGraphics.method_51448();
        poseStack.pushMatrix();
        poseStack.translate(0.0f, 27.0f + this.yOffset);
        for (HistoricalInfo historicalInfo : this.historicalInfos) {
            historicalInfo.render(this, guiGraphics, mouseX, mouseY, delta);
            Objects.requireNonNull(HistoricalDialogue.minecraft.field_1772);
            poseStack.translate(0.0f, (float)(9 + 27));
        }
        poseStack.popMatrix();
    }

    public boolean method_25401(double mouseX, double mouseY, double horizontalAmount, double verticalAmount) {
        float direction = (float)Math.signum(verticalAmount);
        float baseSpeed = ChatBoxClient.conf.historicalScrollSpeed;
        this.verticalScrollAmount = direction * baseSpeed;
        return true;
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (button == 0 && ChatBoxUtil.chatBoxScreen.isHistoricalSkip.booleanValue()) {
            for (HistoricalInfo historicalInfo : this.historicalInfos) {
                if (!historicalInfo.isMouseInRect(mouseX, mouseY)) continue;
                int i = this.historicalInfos.indexOf(historicalInfo);
                this.historicalInfos = this.historicalInfos.subList(0, i);
                historicalInfo.click();
                return super.method_25402(mouseX, mouseY, button);
            }
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    protected void method_47399(@NotNull class_6382 narrationElementOutput) {
    }

    public static class HistoricalInfo {
        public class_2561 name = class_5244.field_39003;
        public class_2561 text = class_5244.field_39003;
        public class_2960 resourceLocation;
        public String group;
        public int index;
        private Vector4i vector4i;
        private float progress;

        public HistoricalInfo(class_2960 resourceLocation, String group, int index) {
            this.resourceLocation = resourceLocation;
            this.group = group;
            this.index = index;
        }

        public HistoricalInfo setName(String name, boolean isTranslatable) {
            if (name != null) {
                this.name = isTranslatable ? class_2561.method_43471((String)name) : class_2561.method_30163((String)name);
            }
            return this;
        }

        public HistoricalInfo setText(String text, boolean isTranslatable) {
            if (text != null) {
                this.text = isTranslatable ? class_2561.method_43471((String)text) : class_2561.method_30163((String)text);
            }
            return this;
        }

        private void render(HistoricalDialogue historicalDialogue, class_332 guiGraphics, double mouseX, double mouseY, float delta) {
            this.vector4i = this.createEntryAbsoluteRect(guiGraphics);
            Matrix3x2fStack poseStack = guiGraphics.method_51448();
            poseStack.pushMatrix();
            poseStack.translate((float)historicalDialogue.field_22758 * -0.025f * this.progress, 0.0f);
            poseStack.scale(1.0f + 0.05f * this.progress, 1.0f + 0.05f * this.progress);
            Vector4i relativelyRect = this.createEntryRelativelyRect();
            class_327 font = class_310.method_1551().field_1772;
            boolean inRect = this.isMouseInRect(mouseX, mouseY);
            this.progress = Math.clamp(this.progress + (inRect ? delta * 0.5f : -delta * 0.5f), 0.0f, 1.0f);
            guiGraphics.method_25294(relativelyRect.x, relativelyRect.y, relativelyRect.z, relativelyRect.w, this.getBackgroundColor());
            int lineBreak = class_310.method_1551().method_22683().method_4486() / 7 * 5;
            guiGraphics.method_65179(font, (class_5348)class_2561.method_30163((String)StrUtil.maxLength(ChatBoxUtil.parseText(this.name.getString(), true), 60)), relativelyRect.x + 3, -5, lineBreak, -1);
            guiGraphics.method_65179(font, (class_5348)class_2561.method_30163((String)StrUtil.maxLength(ChatBoxUtil.parseText(this.text.getString(), true), 60)), relativelyRect.x + 3, 8, lineBreak, -1);
            poseStack.popMatrix();
        }

        public void click() {
            ChatBoxUtil.skipDialogues(this.resourceLocation, this.group, this.index);
        }

        public boolean isMouseInRect(double mouseX, double mouseY) {
            return (double)this.vector4i.x <= mouseX && mouseX <= (double)this.vector4i.z && (double)this.vector4i.y <= mouseY && mouseY <= (double)this.vector4i.w;
        }

        public Vector4i createEntryAbsoluteRect(class_332 guiGraphics) {
            int y = (int)guiGraphics.method_51448().m21();
            return this.createEntryRelativelyRect().add(0, y, 0, y);
        }

        private Vector4i createEntryRelativelyRect() {
            int width = class_310.method_1551().method_22683().method_4486();
            int n = width / 7;
            int n2 = width / 7 * 6;
            Objects.requireNonNull(class_310.method_1551().field_1772);
            return new Vector4i(n, -7, n2, 20 + 9);
        }

        private int getBackgroundColor() {
            return (int)(34.0f + 102.0f * this.progress) << 24 | 0xFFFFFF;
        }
    }
}

