/*
 * Decompiled with CFR 0.152.
 */
package com.zhenshiz.chatbox.component;

import com.mojang.blaze3d.opengl.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.textures.GpuTextureView;
import com.zhenshiz.chatbox.ChatBox;
import com.zhenshiz.chatbox.component.AbstractComponent;
import com.zhenshiz.chatbox.utils.chatbox.FloatBlitRenderState;
import com.zhenshiz.chatbox.utils.chatbox.RenderUtil;
import java.awt.image.BufferedImage;
import java.net.URI;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import java.util.concurrent.Executor;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_10799;
import net.minecraft.class_11231;
import net.minecraft.class_11244;
import net.minecraft.class_241;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3419;
import org.joml.Matrix3x2f;
import org.watermedia.api.image.ImageAPI;
import org.watermedia.api.image.ImageRenderer;
import org.watermedia.api.player.videolan.VideoPlayer;
import org.watermedia.core.tools.JarTool;
import org.watermedia.videolan4j.player.base.State;
import org.watermedia.videolan4j.player.component.CallbackMediaPlayerComponent;

public class Video
extends AbstractComponent<Video> {
    private static final DateFormat FORMAT = new SimpleDateFormat("HH:mm:ss");
    private float actualX;
    private float actualY;
    private float actualWidth;
    private float actualHeight;
    private int tick = 0;
    private float fadeStep30 = 0.0f;
    private float fadeStep10 = 0.0f;
    private boolean started;
    private float volume = 100.0f;
    private final boolean loop;
    private boolean success;
    private final boolean canControl;
    public final boolean canSkip;
    private final class_310 minecraft = class_310.method_1551();
    private final VideoPlayer player;
    private final URI uri;
    int videoTexture = -1;
    ImageRenderer IMG_PAUSED = ImageAPI.renderer((BufferedImage)JarTool.readImage((String)"/pictures/paused.png"), (boolean)true);
    ImageRenderer IMG_STEP30 = ImageAPI.renderer((BufferedImage)JarTool.readImage((String)"/pictures/step30.png"), (boolean)true);
    ImageRenderer IMG_STEP10 = ImageAPI.renderer((BufferedImage)JarTool.readImage((String)"/pictures/step10.png"), (boolean)true);

    public Video(URI uri, boolean canControl, boolean canSkip, boolean loop) {
        this.canControl = canControl;
        this.canSkip = canSkip;
        this.loop = loop;
        this.uri = uri;
        this.player = new VideoPlayer((Executor)this.minecraft);
        ChatBox.LOGGER.info("Playing video ({}blocked) ({} with volume: {}", new Object[]{canControl ? "not " : "", uri, (int)(this.minecraft.field_1690.method_1630(class_3419.field_15250) * 100.0f)});
        this.player.setVolume((int)(this.minecraft.field_1690.method_1630(class_3419.field_15250) * 100.0f));
        this.started = true;
        this.player.start(uri);
        this.success = false;
    }

    public boolean isPlaying() {
        return this.started;
    }

    public State getState() {
        CallbackMediaPlayerComponent raw = this.player.raw();
        if (raw == null) {
            return null;
        }
        return raw.mediaPlayer().status().state();
    }

    @Override
    public void render(class_332 guiGraphics, int mouseX, int mouseY, float pPartialTick) {
        if (!this.isPlaying()) {
            return;
        }
        if (!this.success && this.getState() == State.PLAYING) {
            this.success = true;
        }
        ++this.tick;
        if (this.player.isEnded() || this.player.isStopped()) {
            if (this.loop) {
                this.player.start(this.uri);
                return;
            }
            this.stop();
            return;
        }
        class_241 pos = this.getCurrentPosition();
        this.actualX = Video.getResponsiveWidth(pos.field_1343);
        this.actualY = Video.getResponsiveHeight(pos.field_1342);
        this.actualWidth = Video.getResponsiveWidth(this.width);
        this.actualHeight = Video.getResponsiveHeight(this.height);
        this.videoTexture = this.player.preRender();
        if (this.player.isPlaying() || this.player.isPaused()) {
            this.renderTexture(guiGraphics, this.videoTexture);
        }
        if (!this.player.isPlaying()) {
            if (this.player.isPaused()) {
                this.renderIcon(guiGraphics, this.IMG_PAUSED);
            } else {
                this.renderIcon(guiGraphics, ImageAPI.loadingGif());
            }
        }
        this.renderStep10(guiGraphics, pPartialTick);
        this.renderStep30(guiGraphics, pPartialTick);
        if (FabricLoader.getInstance().isDevelopmentEnvironment()) {
            this.draw(guiGraphics, String.format("State: %s", this.player.getStateName()), this.getHeightCenter(-12));
            this.draw(guiGraphics, String.format("Time: %s (%s) / %s (%s)", FORMAT.format(new Date(this.player.getTime())), this.player.getTime(), FORMAT.format(new Date(this.player.getDuration())), this.player.getDuration()), this.getHeightCenter(0));
        }
    }

    private void renderTexture(class_332 guiGraphics, int texture) {
        if (this.player.dimension() == null) {
            return;
        }
        this.drawTexture(guiGraphics, texture, this.actualX, this.actualY, this.actualWidth, this.actualHeight, -1);
    }

    private int getHeightCenter(int offset) {
        return (int)(this.actualHeight / 2.0f + (float)offset);
    }

    private void renderIcon(class_332 guiGraphics, ImageRenderer image) {
        int iconSize = 36;
        float xOffset = this.actualWidth - (float)iconSize + this.actualX;
        float yOffset = this.actualHeight - (float)iconSize + this.actualY;
        this.drawTexture(guiGraphics, image.texture(this.tick, 1L, true), xOffset, yOffset, iconSize, iconSize, -1);
    }

    private void renderStep30(class_332 guiGraphics, float pPartialTicks) {
        if (this.fadeStep30 == 0.0f) {
            return;
        }
        int texture = this.IMG_STEP30.texture(this.tick, 1L, true);
        float alpha = this.fadeStep30 * 100.0f;
        float x = this.actualWidth / 2.0f + 70.0f + this.actualX;
        float y = this.actualHeight / 2.0f - 32.0f + this.actualY;
        int size = 64;
        this.drawTexture(guiGraphics, texture, x, y, size, size, RenderUtil.getColor(alpha));
        this.fadeStep30 = Math.max(this.fadeStep30 - pPartialTicks / 8.0f, 0.0f);
    }

    private void renderStep10(class_332 guiGraphics, float pPartialTicks) {
        if (this.fadeStep10 == 0.0f) {
            return;
        }
        int texture = this.IMG_STEP10.texture(this.tick, 1L, true);
        float alpha = this.fadeStep10 * 100.0f;
        float x = this.actualWidth / 2.0f - 134.0f + this.actualX;
        float y = this.actualHeight / 2.0f - 32.0f + this.actualY;
        int size = 64;
        this.drawTexture(guiGraphics, texture, x, y, size, size, RenderUtil.getColor(alpha));
        this.fadeStep10 = Math.max(this.fadeStep10 - pPartialTicks / 8.0f, 0.0f);
    }

    private void drawTexture(class_332 guiGraphics, int texture, float x, float y, float width, float height, int color) {
        GpuTextureView shaderTexture = RenderSystem.getShaderTexture((int)texture);
        guiGraphics.field_59826.method_70919((class_11244)new FloatBlitRenderState(guiGraphics, class_10799.field_56883, class_11231.method_70900((GpuTextureView)shaderTexture), (Matrix3x2f)guiGraphics.method_51448(), x, y, width, height, 1.0f, 1.0f, color));
    }

    private void draw(class_332 guiGraphics, String text, int height) {
        guiGraphics.method_25303(this.minecraft.field_1772, text, 5 + (int)this.actualX, height + (int)this.actualY, -1);
    }

    public void keyPressed(int pKeyCode, int pScanCode, int pModifiers) {
        float newVolume;
        float actualVolume;
        if (pKeyCode == 265) {
            if (this.volume <= 95.0f) {
                this.volume += 5.0f;
            } else {
                this.volume = 100.0f;
                float masterVolume = this.minecraft.field_1690.method_1630(class_3419.field_15250);
                if ((double)masterVolume <= 0.95) {
                    this.minecraft.field_1690.method_45578(class_3419.field_15250).method_41748((Object)((double)masterVolume + 0.05));
                } else {
                    this.minecraft.field_1690.method_45578(class_3419.field_15250).method_41748((Object)1.0);
                }
            }
            actualVolume = this.minecraft.field_1690.method_1630(class_3419.field_15250);
            newVolume = this.volume * actualVolume;
            ChatBox.LOGGER.info("Volume UP to: {}", (Object)Float.valueOf(newVolume));
            this.player.setVolume((int)newVolume);
        }
        if (pKeyCode == 264) {
            this.volume = this.volume >= 5.0f ? (this.volume -= 5.0f) : 0.0f;
            actualVolume = this.minecraft.field_1690.method_1630(class_3419.field_15250);
            newVolume = this.volume * actualVolume;
            ChatBox.LOGGER.info("Volume DOWN to: {}", (Object)Float.valueOf(newVolume));
            this.player.setVolume((int)newVolume);
        }
        if (pKeyCode == 77) {
            if (!this.player.isMuted()) {
                this.player.mute();
            } else {
                this.player.unmute();
            }
        }
        if (!this.canControl) {
            return;
        }
        if (pKeyCode == 262) {
            long time = this.loop && this.player.getTime() + 30000L > this.player.getDuration() ? 0L : this.player.getTime() + 30000L;
            this.player.seekTo(time);
            this.fadeStep30 = 1.0f;
        }
        if (pKeyCode == 263) {
            this.player.seekTo(this.player.getTime() - 10000L);
            this.fadeStep10 = 1.0f;
        }
        if (pKeyCode == 32) {
            if (!this.player.isPaused()) {
                this.player.pause();
            } else {
                this.player.play();
            }
        }
    }

    private void stop() {
        if (!this.success) {
            this.player.start(this.uri);
            return;
        }
        this.close();
    }

    public void close() {
        if (this.started) {
            this.started = false;
            this.player.stop();
            GlStateManager._deleteTexture((int)this.videoTexture);
            this.player.release();
        }
    }

    static {
        FORMAT.setTimeZone(TimeZone.getTimeZone("GMT-00:00"));
    }
}

