/*
 * Decompiled with CFR 0.152.
 */
package com.zhenshiz.chatbox.data;

import com.google.common.reflect.TypeToken;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.zhenshiz.chatbox.ChatBox;
import com.zhenshiz.chatbox.data.ChatBoxDialogues;
import com.zhenshiz.chatbox.data.ChatBoxTriggerCount;
import com.zhenshiz.chatbox.data.SimpleJsonDataLoader;
import com.zhenshiz.chatbox.network.s2c.ChatBoxPayload;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.minecraft.class_175;
import net.minecraft.class_184;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3300;
import net.minecraft.class_3695;
import net.minecraft.class_4558;
import net.minecraft.class_6903;
import net.minecraft.class_7654;
import net.minecraft.class_8710;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;

public class ChatBoxDialoguesLoader
extends SimpleJsonDataLoader
implements IdentifiableResourceReloadListener {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    public static final Map<class_2960, String> dialoguesMap = new HashMap<class_2960, String>();
    public static final Map<class_2960, Set<String>> dialoguesGroupMap = new HashMap<class_2960, Set<String>>();
    private static final Map<class_2960, JsonElement> criteriaElements = new HashMap<class_2960, JsonElement>();
    private static final Map<class_2960, Map<String, Map<String, class_175<?>>>> dialoguesCriteriaMap = new HashMap();
    private static final Codec<Map<String, class_175<?>>> CRITERIA_CODEC = Codec.unboundedMap((Codec)Codec.STRING, (Codec)class_175.field_47188).validate(map -> map.isEmpty() ? DataResult.error(() -> "Advancement criteria cannot be empty") : DataResult.success((Object)map));
    public static final Map<class_2960, Integer> defaultMaxTriggerCount = new HashMap<class_2960, Integer>();

    public ChatBoxDialoguesLoader() {
        super(class_7654.method_45114((String)"chatbox/dialogues"));
    }

    protected void apply(@NotNull Map<class_2960, JsonElement> resourceLocationJsonElementMap, @NotNull class_3300 resourceManager, @NotNull class_3695 profilerFiller) {
        dialoguesMap.clear();
        dialoguesGroupMap.clear();
        criteriaElements.clear();
        dialoguesCriteriaMap.clear();
        defaultMaxTriggerCount.clear();
        resourceLocationJsonElementMap.forEach((resourceLocation, jsonElement) -> dialoguesMap.put((class_2960)resourceLocation, jsonElement.toString()));
        ChatBoxDialoguesLoader.setDialogues();
    }

    public static <T extends class_4558.class_8788> void triggerDialog(class_3222 player, Predicate<T> testTrigger) {
        for (Map.Entry<class_2960, Map<String, Map<String, class_175<?>>>> entry : dialoguesCriteriaMap.entrySet()) {
            class_2960 rl = entry.getKey();
            Map<String, Map<String, class_175<?>>> groupWithCriteria = entry.getValue();
            for (Map.Entry<String, Map<String, class_175<?>>> entry1 : groupWithCriteria.entrySet()) {
                String group = entry1.getKey();
                Map<String, class_175<?>> criteria = entry1.getValue();
                for (Map.Entry<String, class_175<?>> entry2 : criteria.entrySet()) {
                    class_175<?> criterion = entry2.getValue();
                    class_184 instance = criterion.comp_1924();
                    try {
                        ChatBoxTriggerCount counts;
                        int count;
                        class_4558.class_8788 t = (class_4558.class_8788)instance;
                        if (!testTrigger.test(t) || (count = (counts = ChatBox.getTriggerCounts()).getPlayerMaxTriggerCount(player, rl)) == 0) continue;
                        counts.setPlayerMaxTriggerCount(player, rl, count - 1);
                        ServerPlayNetworking.send((class_3222)player, (class_8710)new ChatBoxPayload.OpenScreenPayload(rl, group, 0));
                    }
                    catch (ClassCastException classCastException) {}
                }
            }
        }
    }

    private static void setDialogues() {
        dialoguesMap.forEach((resourceLocation, str) -> {
            JsonElement jsonElement = (JsonElement)GSON.fromJson(str, JsonElement.class);
            if (jsonElement == null) {
                return;
            }
            JsonElement dialoguesElement = jsonElement.getAsJsonObject().get("dialogues");
            if (dialoguesElement != null) {
                ChatBoxDialogues chatBoxDialogues = (ChatBoxDialogues)GSON.fromJson(jsonElement, new TypeToken<ChatBoxDialogues>(){}.getType());
                dialoguesGroupMap.put((class_2960)resourceLocation, chatBoxDialogues.dialogues.keySet());
                JsonElement maxTriggerCountElement = jsonElement.getAsJsonObject().get("maxTriggerCount");
                int maxTriggerCount = maxTriggerCountElement != null ? maxTriggerCountElement.getAsInt() : -1;
                defaultMaxTriggerCount.put((class_2960)resourceLocation, maxTriggerCount);
                JsonElement criteria = jsonElement.getAsJsonObject().get("criteria");
                if (criteria != null) {
                    criteriaElements.put((class_2960)resourceLocation, criteria);
                }
            }
        });
    }

    public static void loadCriteria(MinecraftServer server) {
        for (Map.Entry<class_2960, JsonElement> entry : criteriaElements.entrySet()) {
            class_2960 rl = entry.getKey();
            JsonElement criteriaElement = entry.getValue();
            String group = (String)dialoguesGroupMap.get(rl).stream().toList().getFirst();
            class_6903 registryOps = server.method_30611().method_57093((DynamicOps)JsonOps.INSTANCE);
            try {
                Map criteria = (Map)CRITERIA_CODEC.parse((DynamicOps)registryOps, (Object)criteriaElement).getOrThrow(JsonParseException::new);
                HashMap<String, Map> groupCriteriaMap = new HashMap<String, Map>();
                groupCriteriaMap.put(group, criteria);
                dialoguesCriteriaMap.put(rl, groupCriteriaMap);
            }
            catch (Exception var6x) {
                ChatBox.LOGGER.error("Parsing error loading dialog {}: {}", (Object)rl, (Object)var6x.getMessage());
            }
        }
    }

    public class_2960 getFabricId() {
        return class_2960.method_60655((String)"chatbox", (String)"chatbox/dialogues");
    }
}

