/*
 * Decompiled with CFR 0.152.
 */
package com.zhenshiz.chatbox.data;

import com.zhenshiz.chatbox.component.AbstractComponent;
import com.zhenshiz.chatbox.component.ChatOption;
import com.zhenshiz.chatbox.component.FunctionalButton;
import com.zhenshiz.chatbox.component.Portrait;
import com.zhenshiz.chatbox.render.KeyPromptRender;
import com.zhenshiz.chatbox.utils.common.BeanUtil;
import com.zhenshiz.chatbox.utils.math.EasingUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class ChatBoxTheme {
    private static final Float DEFAULT_FLOAT = Float.valueOf(0.0f);
    public Map<String, Portrait> portrait;
    public Option option;
    public DialogBox dialogBox;
    public List<FunctionButton> functionButtons;
    public KeyPrompt keyPrompt;

    public ChatBoxTheme setDefaultValue() {
        for (FunctionButton button : this.functionButtons) {
            int i = this.functionButtons.indexOf(button);
            button.x = BeanUtil.getValueOrDefault(button.x, Float.valueOf((Objects.equals(button.alignX, AbstractComponent.AlignX.LEFT.name()) ? 5 : -5) * i));
        }
        return this;
    }

    public ChatBoxTheme(Map<String, Portrait> portrait, Option option, DialogBox dialogBox, List<FunctionButton> functionButtons, KeyPrompt keyPrompt) {
        this.portrait = portrait;
        this.option = option;
        this.dialogBox = dialogBox;
        this.functionButtons = functionButtons;
        this.keyPrompt = keyPrompt;
    }

    public static class FunctionButton
    extends Component {
        public String type;
        public String texture;
        public String hoverTexture;

        public FunctionButton() {
            this.x = null;
            this.width = Float.valueOf(5.0f);
            this.height = Float.valueOf(8.0f);
            this.alignX = AbstractComponent.AlignX.RIGHT.name();
            this.alignY = AbstractComponent.AlignY.BOTTOM.name();
            this.renderOrder = 30;
        }

        public static List<FunctionalButton> setFunctionalButtonTheme(List<FunctionButton> functionButtons) {
            return functionButtons.stream().map(b -> ((FunctionalButton)new FunctionalButton(FunctionalButton.Type.of(b.type)).setDefaultOption(b.x.floatValue(), b.y.floatValue(), b.width.floatValue(), b.height.floatValue(), AbstractComponent.AlignX.of(b.alignX), AbstractComponent.AlignY.of(b.alignY), b.opacity, b.renderOrder, b.angle)).setTexture(b.texture).setHoverTexture(b.hoverTexture)).toList();
        }
    }

    public static class Option
    extends Component {
        public String texture;
        public String selectTexture;
        public String lockTexture;
        public Float optionChatX;
        public Float optionChatY;
        public String textAlign;

        public Option() {
            this.renderOrder = 10;
            this.optionChatX = DEFAULT_FLOAT;
            this.optionChatY = DEFAULT_FLOAT;
            this.textAlign = ChatOption.TextAlign.LEFT.name();
        }

        public ChatOption setChatOptionTheme(ChatOption chatOption, int index) {
            return (ChatOption)((ChatOption)chatOption.setDefaultOption(this.x.floatValue(), this.y.floatValue() + this.height.floatValue() * (float)index, this.width.floatValue(), this.height.floatValue(), AbstractComponent.AlignX.of(this.alignX), AbstractComponent.AlignY.of(this.alignY), this.opacity, this.renderOrder, this.angle)).setTextures(this.texture).setSelectTexture(this.selectTexture).setLockTexture(this.lockTexture).setOptionChatPosition(this.optionChatX.floatValue(), this.optionChatY.floatValue()).setTextAlign(ChatOption.TextAlign.of(this.textAlign)).build();
        }
    }

    public static class DialogBox
    extends Component {
        public String texture;
        public Float lineWidth;
        public Float nameX;
        public Float nameY;
        public Float textX;
        public Float textY;

        public DialogBox() {
            this.renderOrder = 0;
            this.nameX = DEFAULT_FLOAT;
            this.nameY = DEFAULT_FLOAT;
            this.textX = DEFAULT_FLOAT;
            this.textY = DEFAULT_FLOAT;
        }

        public com.zhenshiz.chatbox.component.DialogBox setDialogBoxTheme(com.zhenshiz.chatbox.component.DialogBox dialogBox) {
            return (com.zhenshiz.chatbox.component.DialogBox)((com.zhenshiz.chatbox.component.DialogBox)dialogBox.setDefaultOption(this.x.floatValue(), this.y.floatValue(), this.width.floatValue(), this.height.floatValue(), AbstractComponent.AlignX.of(this.alignX), AbstractComponent.AlignY.of(this.alignY), this.opacity, this.renderOrder, this.angle)).setTexture(this.texture).setNamePosition(this.nameX.floatValue(), this.nameY.floatValue()).setTextPosition(this.textX.floatValue(), this.textY.floatValue()).setLineWidth(this.lineWidth).build();
        }
    }

    public static class KeyPrompt
    extends Component {
        public Boolean visible;
        public Float mouseTextureWidth;
        public Float mouseTextureHeight;
        public String rightClickTexture;
        public String scrollTexture;

        public KeyPrompt() {
            this.renderOrder = 40;
            this.visible = true;
            this.mouseTextureWidth = Float.valueOf(16.0f);
            this.mouseTextureHeight = Float.valueOf(16.0f);
        }

        public KeyPromptRender setKeyPromptTheme(KeyPromptRender keyPromptRender) {
            return (KeyPromptRender)((KeyPromptRender)((KeyPromptRender)((KeyPromptRender)((KeyPromptRender)keyPromptRender.setPosition(this.x.floatValue(), this.y.floatValue())).setAlign(AbstractComponent.AlignX.of(this.alignX), AbstractComponent.AlignY.of(this.alignY))).setOpacity(this.opacity)).setRenderOrder(this.renderOrder)).setVisible(this.visible).setMouseTextureSize(this.mouseTextureWidth, this.mouseTextureHeight).setRightClickTexture(this.rightClickTexture).setScrollTexture(this.scrollTexture).build();
        }
    }

    public static class Component {
        public Float x = DEFAULT_FLOAT;
        public Float y = DEFAULT_FLOAT;
        public Float width = Float.valueOf(10.0f);
        public Float height = Float.valueOf(10.0f);
        public String alignX = AbstractComponent.AlignX.LEFT.name();
        public String alignY = AbstractComponent.AlignY.TOP.name();
        public Float opacity = Float.valueOf(100.0f);
        public Integer renderOrder;
        public Float angle = DEFAULT_FLOAT;
    }

    public static class Portrait
    extends Component {
        public String type;
        public String value;
        public Integer customItemData;
        public String animation;
        public Float scale;
        public List<CustomAnimation> customAnimation;
        public Boolean loop;
        public List<Attachment> attachment;

        public Portrait() {
            this.renderOrder = 20;
            this.scale = Float.valueOf(1.0f);
            this.loop = false;
            this.attachment = new ArrayList<Attachment>();
        }

        public com.zhenshiz.chatbox.component.Portrait setPortraitTheme() {
            com.zhenshiz.chatbox.component.Portrait portrait = new com.zhenshiz.chatbox.component.Portrait(Portrait.Type.of(this.type), this.animation, this.customAnimation, this.scale, this.loop);
            switch (portrait.type) {
                case TEXTURE: {
                    portrait.createTexture(portrait, this.value, this.attachment).build();
                    break;
                }
                case PLAYER_HEAD: {
                    portrait.createPlayerHead(portrait, this.value).build();
                    break;
                }
                case ITEM: {
                    portrait.createItem(portrait, this.value, this.customItemData).build();
                }
            }
            return (com.zhenshiz.chatbox.component.Portrait)portrait.setDefaultOption(this.x.floatValue(), this.y.floatValue(), this.width.floatValue(), this.height.floatValue(), AbstractComponent.AlignX.of(this.alignX), AbstractComponent.AlignY.of(this.alignY), this.opacity, this.renderOrder, this.angle);
        }

        public static class Attachment {
            public String value;
            public Float x = DEFAULT_FLOAT;
            public Float y = DEFAULT_FLOAT;
            public Float width = DEFAULT_FLOAT;
            public Float height = DEFAULT_FLOAT;

            public Attachment mapParameter() {
                return new Attachment(this.value, Float.valueOf(AbstractComponent.getResponsiveWidth(this.x.floatValue())), Float.valueOf(AbstractComponent.getResponsiveHeight(this.y.floatValue())), Float.valueOf(AbstractComponent.getResponsiveWidth(this.width.floatValue())), Float.valueOf(AbstractComponent.getResponsiveHeight(this.height.floatValue())));
            }

            public Attachment(String value, Float x, Float y, Float width, Float height) {
                this.value = value;
                this.x = x;
                this.y = y;
                this.width = width;
                this.height = height;
            }

            public Attachment() {
            }
        }

        public static class CustomAnimation {
            public String texture;
            public Integer time;
            public Float x;
            public Float y;
            public Float xOffset;
            public Float yOffset;
            public Float scale;
            public Float opacity;
            public Float angle;
            public EasingUtil.Easing easing;
        }
    }
}

