/*
 * Decompiled with CFR 0.152.
 */
package com.zhenshiz.chatbox.network.s2c;

import com.zhenshiz.chatbox.ChatBox;
import com.zhenshiz.chatbox.utils.chatbox.ChatBoxCommandUtil;
import com.zhenshiz.chatbox.utils.chatbox.ChatBoxUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_8710;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import org.jetbrains.annotations.NotNull;

public class ChatBoxPayload {
    private static Map<class_2960, String> mergeString(Map<class_2960, List<String>> map) {
        HashMap<class_2960, String> result = new HashMap<class_2960, String>();
        for (Map.Entry<class_2960, List<String>> entry : map.entrySet()) {
            class_2960 rl = entry.getKey();
            List<String> parts = entry.getValue();
            StringBuilder builder = new StringBuilder();
            for (String part : parts) {
                builder.append(part);
            }
            result.put(rl, builder.toString());
        }
        return result;
    }

    public record SimplePayload(String name, String value) implements class_8710
    {
        public static final class_8710.class_9154<SimplePayload> TYPE = new class_8710.class_9154(ChatBox.ResourceLocationMod("simple_payload"));
        public static final class_9139<class_2540, SimplePayload> CODEC = class_9139.method_56435((class_9139)class_9135.field_48554, SimplePayload::name, (class_9139)class_9135.field_48554, SimplePayload::value, SimplePayload::new);
        private static final Map<String, Consumer<String>> handlers = new HashMap<String, Consumer<String>>();

        public static void execute(SimplePayload payload, ClientPlayNetworking.Context context) {
            if (handlers.containsKey(payload.name())) {
                handlers.get(payload.name()).accept(payload.value());
            }
        }

        @NotNull
        public class_8710.class_9154<? extends class_8710> method_56479() {
            return TYPE;
        }

        static {
            handlers.put("open_dialog", s -> ChatBoxCommandUtil.clientOpenChatBox());
            handlers.put("set_theme", ChatBoxCommandUtil::clientToggleTheme);
            handlers.put("next_dialogue", s -> ChatBoxCommandUtil.clientNextDialogue());
            handlers.put("auto_play", s -> ChatBoxCommandUtil.clientAutoPlay(Boolean.parseBoolean(s)));
            handlers.put("set_is_screen", s -> ChatBoxCommandUtil.clientSetIsScreen(Boolean.parseBoolean(s)));
        }
    }

    public record AllChatBoxDialoguesToClient(Map<class_2960, List<String>> dialoguesMap) implements class_8710
    {
        public static final class_8710.class_9154<AllChatBoxDialoguesToClient> TYPE = new class_8710.class_9154(ChatBox.ResourceLocationMod("all_chat_box_dialogues_to_client"));
        public static final class_9139<class_2540, AllChatBoxDialoguesToClient> CODEC = class_9139.method_56434((class_9139)class_9135.method_56377(HashMap::new, (class_9139)class_2960.field_48267, (class_9139)class_9135.method_56376(ArrayList::new, (class_9139)class_9135.field_48554)), AllChatBoxDialoguesToClient::dialoguesMap, AllChatBoxDialoguesToClient::new);

        @NotNull
        public class_8710.class_9154<? extends class_8710> method_56479() {
            return TYPE;
        }

        public static void execute(AllChatBoxDialoguesToClient payload, ClientPlayNetworking.Context context) {
            ChatBoxUtil.setDialogues(ChatBoxPayload.mergeString(payload.dialoguesMap()));
        }
    }

    public record AllChatBoxThemeToClient(Map<class_2960, List<String>> themeMap) implements class_8710
    {
        public static final class_8710.class_9154<AllChatBoxThemeToClient> TYPE = new class_8710.class_9154(ChatBox.ResourceLocationMod("all_chat_box_theme_to_client"));
        public static final class_9139<class_2540, AllChatBoxThemeToClient> CODEC = class_9139.method_56434((class_9139)class_9135.method_56377(HashMap::new, (class_9139)class_2960.field_48267, (class_9139)class_9135.method_56376(ArrayList::new, (class_9139)class_9135.field_48554)), AllChatBoxThemeToClient::themeMap, AllChatBoxThemeToClient::new);

        @NotNull
        public class_8710.class_9154<? extends class_8710> method_56479() {
            return TYPE;
        }

        public static void execute(AllChatBoxThemeToClient payload, ClientPlayNetworking.Context context) {
            class_2960 theme;
            ChatBoxUtil.setTheme(ChatBoxPayload.mergeString(payload.themeMap()));
            if (ChatBoxUtil.themeResourceLocation != null && (theme = class_2960.method_12829((String)ChatBoxUtil.themeResourceLocation)) != null) {
                ChatBoxUtil.toggleTheme(theme);
            }
        }
    }

    public record OpenScreenPayload(class_2960 dialogues, String group, int index) implements class_8710
    {
        public static final class_8710.class_9154<OpenScreenPayload> TYPE = new class_8710.class_9154(ChatBox.ResourceLocationMod("open_screen"));
        public static final class_9139<class_2540, OpenScreenPayload> CODEC = class_9139.method_56436((class_9139)class_2960.field_48267, OpenScreenPayload::dialogues, (class_9139)class_9135.field_48554, OpenScreenPayload::group, (class_9139)class_9135.field_49675, OpenScreenPayload::index, OpenScreenPayload::new);

        @NotNull
        public class_8710.class_9154<? extends class_8710> method_56479() {
            return TYPE;
        }

        public static void execute(OpenScreenPayload payload, ClientPlayNetworking.Context context) {
            ChatBoxCommandUtil.clientSkipDialogues(payload.dialogues(), payload.group(), payload.index());
        }
    }
}

